% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bounds.R
\name{V_bound}
\alias{V_bound}
\alias{as.V_bound}
\alias{is.V_bound}
\title{Objective Variable Bounds}
\usage{
V_bound(li, ui, lb, ub, nobj, ld = 0, ud = Inf, names = NULL)

as.V_bound(x)

is.V_bound(x)
}
\arguments{
\item{li}{an integer vector specifying the indices of non-standard
(i.e., values != 0) lower bounds.}

\item{ui}{an integer vector specifying the indices of non-standard
(i.e., values != Inf) upper bounds.}

\item{lb}{a numeric vector with lower bounds.}

\item{ub}{a numeric vector with upper bounds.}

\item{nobj}{an integer representing the number of objective variables}

\item{ld}{a numeric giving lower default bound.}

\item{ud}{a numeric giving upper default bound.}

\item{names}{a character vector giving the names of the bounds.}

\item{x}{object to be coerced or tested.}
}
\value{
An S3 object of class \code{"V_bound"} containing lower and
upper bounds of the objective variables.
}
\description{
Constructs a variable bounds object.
}
\details{
This function returns a sparse representation of objective
  variable bounds.
}
\examples{
V_bound(li=1:3, lb=rep.int(-Inf, 3))
V_bound(li=c(1, 5, 10), ui=13, lb=rep.int(-Inf, 3), ub=100, nobj=20)
}
