% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solution.R
\name{ROI_plugin_solution_prim}
\alias{ROI_plugin_solution_prim}
\alias{ROI_plugin_solution_prim.OP_solution}
\alias{ROI_plugin_solution_prim.OP_solution_set}
\alias{ROI_plugin_solution_dual}
\alias{ROI_plugin_solution_aux}
\alias{ROI_plugin_solution_psd}
\alias{ROI_plugin_solution_msg}
\alias{ROI_plugin_solution_status_code}
\alias{ROI_plugin_solution_status}
\alias{ROI_plugin_solution_objval}
\title{Extract solution from the solver.}
\usage{
ROI_plugin_solution_prim(x, force = FALSE)

\method{ROI_plugin_solution_prim}{OP_solution}(x, force = FALSE)

\method{ROI_plugin_solution_prim}{OP_solution_set}(x, force = FALSE)

ROI_plugin_solution_dual(x)

ROI_plugin_solution_aux(x)

ROI_plugin_solution_psd(x)

ROI_plugin_solution_msg(x)

ROI_plugin_solution_status_code(x)

ROI_plugin_solution_status(x)

ROI_plugin_solution_objval(x, force = FALSE)
}
\arguments{
\item{x}{an \code{R} object inheriting from \code{solution} or \code{solutions}.}

\item{force}{a logical to control the return value in the case that the 
status code is equal to 1 (i.e. something went wrong).
By default force is \code{FALSE} and a solution is only provided
if the status code is equal to 0 (i.e. success). If force is \code{TRUE}
\pkg{ROI} ignores the status code and also returns solutions
where the solver signaled an issue.}
}
\value{
the corresponding solution/s.
}
\description{
Generic getter functions used by the function 
    \code{\link{solution}}. These functions can be used to write
    a solver specific getter function.
}
\seealso{
Other plugin functions: \code{\link{ROI_plugin_add_status_code_to_db}},
  \code{\link{ROI_plugin_build_equality_constraints}},
  \code{\link{ROI_plugin_build_inequality_constraints}},
  \code{\link{ROI_plugin_canonicalize_solution}},
  \code{\link{ROI_plugin_get_solver_name}},
  \code{\link{ROI_plugin_make_signature}},
  \code{\link{ROI_plugin_register_solver_control}},
  \code{\link{ROI_plugin_register_solver_method}},
  \code{\link{ROI_registered_solver_control}}
}
