% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{translate}
\alias{translate}
\alias{rescale}
\alias{skew}
\alias{rotate}
\title{Apply simple transformations}
\usage{
translate(source, translation, ...)

rescale(source, scales, anchor = c("none", "origin", "centre", "center"),
  ...)

skew(source, skews, anchor = c("none", "origin", "centre", "center"), ...)

rotate(source, angles, anchor = c("none", "origin", "centre", "center"), ...)
}
\arguments{
\item{source}{A 2D or 3D image, in the sense of \code{\link{isImage}}.}

\item{translation}{Translations along each axis, in \code{\link{pixunits}}
units. May also be a list, such as that produced by
\code{\link{decomposeAffine}}, with elements for translation, scales,
skews and angles.}

\item{...}{Additional arguments to \code{\link{applyTransform}}.}

\item{scales}{Scale factors along each axis.}

\item{anchor}{The fixed point for the transformation. Setting this parameter
to a value other than \code{"none"} will override the \code{translation}
parameter, with the final translation set to ensure that the requested
point remains in the same place after transformation.}

\item{skews}{Skews in the XY, XZ and YZ planes.}

\item{angles}{Roll, pitch and yaw rotation angles, in radians. If
\code{source} is two-dimensional, a single angle will be interpreted as
being in the plane as expected.}
}
\value{
The transformed image.
}
\description{
These functions allow simple transformations to be applied quickly, or in a
chosen order. They represent simplified interfaces to the
\code{\link{buildAffine}} and \code{\link{applyTransform}} functions, and
are compatible with the chaining operator from the popular \code{magrittr}
package (although performing one single transformation may be preferable).
}
\seealso{
\code{\link{buildAffine}}, \code{\link{applyTransform}}
}
\author{
Jon Clayden <code@clayden.org>
}
