% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grabNRCSdata.R
\name{grabNRCS.data}
\alias{grabNRCS.data}
\title{grabNRCS.data}
\usage{
grabNRCS.data(network, site_id, timescale, DayBgn, DayEnd)
}
\arguments{
\item{network}{The network of the NRCS/AWDB site of interest. Currently only works for options: 'SCAN','SNTL','SNTLT', and 'OTHER'.\cr}

\item{site_id}{The NRCS site ID. Use grabNRCS.meta to retrieve a list of available sites in a specified network. Consider using the package 'metScanR' to locate sites.\cr}

\item{timescale}{Specify the desired timescale of the data. Typically 'hourly', 'daily', or 'monthly'\cr}

\item{DayBgn}{Specify the beginning date (as YYYY-MM-DD ) for the returned data.\cr}

\item{DayEnd}{Specify the end date (as YYYY-MM-DD ) for the returned data.\cr}
}
\value{
Returns a data frame of requested data. Only elements with at least one data will be returned in the data frame.\cr
}
\description{
A data downloading tool for NRCS networks. Data retrieval is limited by the speed of the connection, if timeout errors persist break requested time periods down into smaller chunks, or use a faster connection.
}
\examples{
grabNRCS.data(network="SNTLT", site_id=1198, timescale="monthly",
DayBgn = '2017-01-01', DayEnd = '2017-05-01')
#Return monthly summaries between January and May 2017 of record at a SNOLITE site.
}
\references{
Downloads <https://wcc.sc.egov.usda.gov/reportGenerator>
}
\seealso{
Currently none
}
\author{
Robert Lee \email{rhlee@colorado.edu}
}
\keyword{atmopsheric}
\keyword{atmosphere,}
\keyword{climate,}
\keyword{data,}
\keyword{environment,}
\keyword{environmental}
\keyword{in-situ,}
\keyword{weather\cr}
