% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{nhanes_data_files}
\alias{nhanes_data_files}
\title{List the NHANES data files}
\usage{
nhanes_data_files(components = "all", destination = tempfile(),
  cache = TRUE)
}
\arguments{
\item{components}{one of "all", "demographics", "dietary", "examination", "laboratory", "questionnaire"}

\item{destination}{destinatino to save the file lists}

\item{cache}{whether to cache the downloaded file lists so they don't have to be re-downloaded every time}
}
\value{
data frame of NHANES data files available to download
}
\description{
List the NHANES data files
}
\examples{
\dontrun{

# Download a data frame of all the NHANES data files
files <- nhanes_data_files()

# Download a data frame of just the laboratory files
lab_files <- nhanes_data_files(component = "laboratory")

}

}

