% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ValidCorrGpois.R
\name{ValidCorrGpois}
\alias{ValidCorrGpois}
\title{Validates Pairwise Correlation}
\usage{
ValidCorrGpois(corMat, theta.vec, lambda.vec)
}
\arguments{
\item{corMat}{a positive definite target correlation matrix whose entries are within the valid correlation bounds.}

\item{theta.vec}{rate parameters in the generalized Poisson distribution. It is assumed that the
length of the vector is at least two, and each value has to be a positive number.}

\item{lambda.vec}{dispersion parameters in the generalized Poisson distribution. It is assumed that the length
of the vector is at least two. All lambda values have to be < 1. For lambda < 0, lambda must be >= -theta/4.}
}
\value{
TRUE or FALSE.
}
\description{
\code{ValidCorrGpois} checks the validity of the values of pairwise correlations including
positive definiteness, symmetry, and correctness of the dimensions.
}
\examples{
\donttest{
 ValidCorrGpois(matrix(c(1, 0.9, 0.9, 1), byrow = TRUE, nrow = 2), c(0.5, 0.5), c(0.1, 0.105))
 ValidCorrGpois(matrix(c(1, 0.9, 0.9, 1), byrow = TRUE, nrow = 2), c(3, 2), c(-0.3, -0.2))}
}
\references{
Demirtas, H. and Hedeker, D. (2011). A practical way for computing approximate lower and upper correlation bounds.
 \emph{The American Statistician}, \bold{65(2)}, 104-109.

 Amatya, A. and Demirtas, H. (2017). PoisNor: An R package for generation of multivariate data with
 Poisson and normal marginals. \emph{Communications in Statistics - Simulation and Computation},
 \bold{46(3)}, 2241-2253.
}
