/*
 * Decompiled with CFR 0.152.
 */
package de.hzi.infg;

import de.hzi.infg.exceptions.ErrorFromWebserviceExeption;
import de.hzi.infg.exceptions.NoResultSoFarException;
import de.hzi.infg.exceptions.ParameterNotFoundException;
import de.hzi.infg.interfaces.RequestInterface;
import de.hzi.infg.interfaces.TypeInterface;
import de.hzi.infg.utilities.Utils;
import gov.nih.nlm.ncbi.www.soap.eutils.EUtilsServiceStub;
import gov.nih.nlm.ncbi.www.soap.eutils.elink.ELinkRequest;
import gov.nih.nlm.ncbi.www.soap.eutils.elink.ELinkResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class RequestELink
implements RequestInterface {
    private ELinkRequest request;
    private ELinkResult result;
    private Map<String, Object> resultMap;
    private static final String resultItemName = "linkset";

    public RequestELink(Map<String, String> arguments, EUtilsServiceStub service) throws ErrorFromWebserviceExeption, RemoteException {
        this.request = new ELinkRequest(arguments.keySet());
        this.resultMap = new HashMap<String, Object>();
        boolean somethingSet = false;
        Object[] idAr = null;
        boolean idToSet = false;
        for (String key : arguments.keySet()) {
            if (arguments.get(key).isEmpty()) continue;
            if (key.equalsIgnoreCase("id")) {
                String tmpId = arguments.get(key);
                idAr = tmpId.split("\\{bw\\}");
                idToSet = true;
            }
            somethingSet = true;
            Method getMethod = Utils.getSetMethodByName(key, this.request.getClass());
            try {
                if (idToSet) {
                    getMethod.invoke((Object)this.request, new Object[]{idAr});
                    idToSet = false;
                    continue;
                }
                getMethod.invoke((Object)this.request, arguments.get(key));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (!somethingSet) {
            throw new ErrorFromWebserviceExeption("All parameters are empty.");
        }
        this.result = service.run_eLink(this.request);
        if (this.result.getERROR() != null) {
            throw new ErrorFromWebserviceExeption("The request produced an error: " + this.result.getERROR());
        }
    }

    @Override
    public String[] getComplexType(String name) throws ParameterNotFoundException {
        if (!name.equalsIgnoreCase(resultItemName)) {
            throw new ParameterNotFoundException("The parameter \"" + name + "\" is not part of this result or is no complex type.");
        }
        ArrayList<String> listToReturn = new ArrayList<String>();
        String firstEntry = resultItemName;
        String values = "";
        Stack<String> ss = new Stack<String>();
        ss.push(resultItemName);
        values = Utils.recStructureBuild(values, this.result.getLinkSet(), new Stack<String>(), ss, false, 0);
        listToReturn.add(values);
        listToReturn.add(0, firstEntry);
        return listToReturn.toArray(new String[listToReturn.size()]);
    }

    @Override
    public String[] getParameter() {
        Class<?> resClazz = this.result.getClass();
        return Utils.getParameter(resClazz);
    }

    @Override
    public String[] getParameterByName(String parameter) throws ParameterNotFoundException {
        this.createResultMap();
        Object tmpObj = this.resultMap.get(parameter.toLowerCase());
        if (!this.resultMap.containsKey(parameter.toLowerCase())) {
            throw new ParameterNotFoundException("The parameter \"" + parameter + "\" has no further parameters to get.");
        }
        if (tmpObj instanceof String) {
            String[] tmp = new String[]{tmpObj.toString()};
            return tmp;
        }
        if (tmpObj == null) {
            String[] tmpReturn = new String[]{"empty"};
            return tmpReturn;
        }
        Map<String, Object> tmpParaMap = ((TypeInterface)tmpObj).getParametersMap();
        return tmpParaMap.keySet().toArray(new String[tmpParaMap.keySet().size()]);
    }

    @Override
    public Map<String, Object> getResultMap() throws NoResultSoFarException {
        if (this.result == null) {
            throw new NoResultSoFarException("There are no results to get.");
        }
        this.createResultMap();
        return this.resultMap;
    }

    @Override
    public String getSimpleType(String name) throws ParameterNotFoundException {
        this.createResultMap();
        Object stringToReturn = null;
        if (this.resultMap.containsKey(name) && (stringToReturn = this.resultMap.get(name)) == null) {
            stringToReturn = "empty";
        }
        if (stringToReturn == null) {
            throw new ParameterNotFoundException("The parameter \"" + name + "\" is not part of this result.");
        }
        if (!(stringToReturn instanceof String)) {
            throw new ParameterNotFoundException("The parameter \"" + name + "\" is a complex type.");
        }
        return (String)stringToReturn;
    }

    private void createResultMap() {
        if (this.resultMap.size() != 0) {
            return;
        }
        String[] tmpParName = this.getParameter();
        int i = 0;
        while (i < tmpParName.length) {
            Method getMethod = Utils.getGetMethodByName(tmpParName[i], this.result.getClass());
            Object obj = null;
            try {
                obj = getMethod.invoke((Object)this.result, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            this.resultMap.put(tmpParName[i], obj);
            i += 2;
        }
    }

    public ELinkResult getResult() {
        return this.result;
    }
}

