% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTL.R
\name{plotObj}
\alias{plotObj}
\title{Plot the historical values of objective function}
\usage{
plotObj(m)
}
\arguments{
\item{m}{A trained MTL model}
}
\description{
Plot the values of objective function across iterations in the
optimization procedure. This function indicates the "inner status" of the
solver during the optimization, and could be used for diagnosis of the
solver and training procedure.
}
\examples{
#create the example date
data<-Create_simulated_data(Regularization="L21", type="Regression")
#Train a MTL model
model<-MTL(data$X, data$Y, type="Regression", Regularization="L21",
    Lam1=0.1, Lam2=0, opts=list(init=0,  tol=10^-6, maxIter=1500))
#plot the objective values
plotObj(model)
}
