% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgbm.R
\name{rTrade}
\alias{rTrade}
\title{Simulate stock trade data}
\usage{
rTrade(time, start = 100, mu = 1e-04, sigma = 2e-04)
}
\arguments{
\item{time}{time vector of time, must be a "Date" type variable}

\item{start}{the start position}

\item{mu}{the \code{mu} parameter of GBM}

\item{sigma}{the \code{sigma} parameter of GBM}
}
\value{
Stock trade data with Open, High, Low and Close
}
\description{
Simulate stock trade data with assumption that the stock price following Geometric Brownian Motion (GBM).
}
\examples{
date <- as.Date("2015-01-01") + days(0:29)
rTrade(date)
}
