/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import moa.core.ObjectRepository;
import moa.options.ClassOption;
import moa.options.FileOption;
import moa.options.FlagOption;
import moa.options.IntOption;
import moa.streams.InstanceStream;
import moa.tasks.MainTask;
import moa.tasks.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriteStreamToARFFFile
extends MainTask {
    private static final long serialVersionUID = 1L;
    public ClassOption streamOption = new ClassOption("stream", 's', "Stream to write.", InstanceStream.class, "generators.RandomTreeGenerator");
    public FileOption arffFileOption = new FileOption("arffFile", 'f', "Destination ARFF file.", null, "arff", true);
    public IntOption maxInstancesOption = new IntOption("maxInstances", 'm', "Maximum number of instances to write to file.", 10000000, 0, Integer.MAX_VALUE);
    public FlagOption suppressHeaderOption = new FlagOption("suppressHeader", 'h', "Suppress header from output.");

    @Override
    public String getPurposeString() {
        return "Outputs a stream to an ARFF file.";
    }

    @Override
    protected Object doMainTask(TaskMonitor monitor, ObjectRepository repository) {
        InstanceStream stream = (InstanceStream)this.getPreparedClassOption(this.streamOption);
        File destFile = this.arffFileOption.getFile();
        if (destFile != null) {
            try {
                BufferedWriter w = new BufferedWriter(new FileWriter(destFile));
                monitor.setCurrentActivityDescription("Writing stream to ARFF");
                if (!this.suppressHeaderOption.isSet()) {
                    w.write(stream.getHeader().toString());
                    w.write("\n");
                }
                for (int numWritten = 0; numWritten < this.maxInstancesOption.getValue() && stream.hasMoreInstances(); ++numWritten) {
                    w.write(stream.nextInstance().toString());
                    w.write("\n");
                }
                ((Writer)w).close();
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed writing to file " + destFile, ex);
            }
            return "Stream written to ARFF file " + destFile;
        }
        throw new IllegalArgumentException("No destination file to write to.");
    }

    @Override
    public Class<?> getTaskResultType() {
        return String.class;
    }
}

