% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KorAPConnection.R
\name{auth,KorAPConnection-method}
\alias{auth,KorAPConnection-method}
\alias{auth}
\title{Authorize RKorAPClient}
\usage{
\S4method{auth}{KorAPConnection}(
  kco,
  app_id = generic_kor_app_id,
  app_secret = NULL,
  scope = kco@oauthScope
)
}
\arguments{
\item{kco}{KorAPConnection object}

\item{app_id}{OAuth2 application id. Defaults to the generic KorAP client application id.}

\item{app_secret}{OAuth2 application secret. Used with confidential client applications. Defaults to \code{NULL}.}

\item{scope}{OAuth2 scope. Defaults to "search match_info".}
}
\value{
KorAPConnection object with access token set in \verb{@accessToken}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Authorize RKorAPClient to make KorAP queries and download results on behalf of the user.
}
\examples{
\dontrun{
kco <- new("KorAPConnection", verbose = TRUE) \%>\% auth()
df <- collocationAnalysis(kco, "focus([marmot/p=ADJA] {Ameisenplage})",
  leftContextSize=1, rightContextSize=0)
}

}
\seealso{
\code{\link[=persistAccessToken]{persistAccessToken()}}, \code{\link[=clearAccessToken]{clearAccessToken()}}
}
