/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;

public class FGraph
implements Finder {
    protected Graph graph;

    public FGraph(Graph graph) {
        this.graph = graph;
    }

    public ExtendedIterator find(TriplePattern pattern) {
        if (this.graph == null) {
            return WrappedIterator.create(new NullIterator());
        }
        return this.graph.find(pattern.asTripleMatch());
    }

    public ExtendedIterator findWithContinuation(TriplePattern pattern, Finder continuation) {
        if (this.graph == null) {
            return WrappedIterator.create(new NullIterator());
        }
        if (continuation == null) {
            return this.graph.find(pattern.asTripleMatch());
        }
        return this.graph.find(pattern.asTripleMatch()).andThen(continuation.find(pattern));
    }

    public Graph getGraph() {
        return this.graph;
    }

    public boolean contains(TriplePattern pattern) {
        return this.graph.contains(pattern.getSubject(), pattern.getPredicate(), pattern.getObject());
    }
}

