% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DfReadCrossedModalities.R
\name{DfReadCrossedModalities}
\alias{DfReadCrossedModalities}
\title{Read a crossed-treatment data file}
\usage{
DfReadCrossedModalities(fileName, sequentialNames = FALSE)
}
\arguments{
\item{fileName}{A string specifying the name of the file that contains the dataset, 
which must be an extended-JAFROC format data file containing an 
additional treatment factor.}

\item{sequentialNames}{If \code{TRUE}, consecutive integers (starting from 1) will be used 
as the treatment and reader IDs. Otherwise, treatment and reader IDs in the 
original data file will be used. The default is \code{FALSE}.}
}
\value{
A dataset with the specified structure, similar to a standard 
   \pkg{RJafroc} dataset (see \code{\link{RJafroc-package}}). Because of the extra treatment factor, 
   \code{NL} and \code{LL} are each five dimensional arrays. There are also two 
   treatment IDS: \code{modalityID1} and \code{modalityID2}.
}
\description{
Read an crossed-treatment data file, in which the 
two treatment factors are crossed
}
\details{
The data format is  similar to the JAFROC format (see \code{\link{RJafroc-package}}). 
   The notable difference is that there are two treatment factors. A sample crossed 
   treatment file "CrossedModalities.xlsx" is in the \code{inst\\extdata} 
   subdirectory of \code{RJafroc}.
}
\examples{

\donttest{
crossedFileName <- system.file("extdata", 
   "CrossedModalities.xlsx", package = "RJafroc", mustWork = TRUE)
crossedData <- DfReadCrossedModalities(crossedFileName)
str(crossedData)
}

}
\references{
Thompson JD, Chakraborty DP, Szczepura K, et al. (2016) Effect of reconstruction 
methods and x-ray tube current-time product  on nodule detection in an 
anthropomorphic thorax phantom: a crossed-treatment JAFROC observer study. 
Medical Physics. 43(3):1265-1274.

Chakraborty DP (2017) \emph{Observer Performance Methods for Diagnostic Imaging - Foundations, 
Modeling, and Applications with R-Based Examples}, CRC Press, Boca Raton, FL. 
\url{https://www.routledge.com/Observer-Performance-Methods-for-Diagnostic-Imaging-Foundations-Modeling/Chakraborty/p/book/9781482214840}
}
