/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.helper;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.table.AbstractTableModel;

public class EnumedListTableModel<T>
extends AbstractTableModel {
    private static final long serialVersionUID = 3265022631397431923L;
    private Object[][] items = new Object[0][];

    public void clear() {
        this.items = new Object[0][];
        this.fireTableDataChanged();
    }

    public void setItems(List<T> list, Function<? super T, String[]> function) {
        Object[][] objectArrayArray = new Object[list.size()][];
        if (list != null) {
            Object[] objectArray = list.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                objectArrayArray[i] = new Object[]{i, null, null, objectArray[i]};
                System.arraycopy(function.apply(objectArray[i]), 0, objectArrayArray[i], 1, 2);
            }
        }
        this.items = objectArrayArray;
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return n == 0 ? Integer.class : String.class;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.items.length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.items[n][n2];
    }

    public List<T> getSource() {
        return Arrays.stream(this.items).map(objectArray -> objectArray[3]).map(object -> object).collect(Collectors.toList());
    }
}

