/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client.custom;

import it.bancaditalia.oss.sdmx.api.DSDIdentifier;
import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.client.RestSdmxClient;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxXmlContentException;
import it.bancaditalia.oss.sdmx.parser.v20.CodelistParser;
import it.bancaditalia.oss.sdmx.parser.v20.DataStructureParser;
import it.bancaditalia.oss.sdmx.parser.v20.DataflowParser;
import it.bancaditalia.oss.sdmx.parser.v21.CompactDataParser;
import it.bancaditalia.oss.sdmx.parser.v21.DataParsingResult;
import it.bancaditalia.oss.sdmx.parser.v21.Sdmx21Queries;
import java.net.URI;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class RestSdmx20Client
extends RestSdmxClient {
    private String acceptHdr = null;
    protected String format = "compact_v2";

    public RestSdmx20Client(String string, URI uRI, boolean bl, String string2, String string3) {
        super(string, uRI, bl, false, false);
        this.acceptHdr = string2;
        this.format = string3;
    }

    @Override
    public Map<String, Dataflow> getDataflows() throws SdmxException {
        URL uRL = this.buildFlowQuery("ALL", null, null);
        List<Dataflow> list = this.runQuery(new DataflowParser(), uRL, null);
        if (list.size() > 0) {
            HashMap<String, Dataflow> hashMap = new HashMap<String, Dataflow>();
            for (Dataflow dataflow : list) {
                hashMap.put(dataflow.getId(), dataflow);
            }
            return hashMap;
        }
        throw new SdmxXmlContentException("The query returned zero dataflows");
    }

    @Override
    public Dataflow getDataflow(String string, String string2, String string3) throws SdmxException {
        URL uRL = this.buildFlowQuery(string, string2, string3);
        List<Dataflow> list = this.runQuery(new DataflowParser(), uRL, null);
        if (list.size() >= 1) {
            for (Dataflow dataflow : list) {
                if (!dataflow.getId().equalsIgnoreCase(string)) continue;
                return dataflow;
            }
        }
        throw new SdmxXmlContentException("The query returned zero dataflows");
    }

    @Override
    public DataFlowStructure getDataFlowStructure(DSDIdentifier dSDIdentifier, boolean bl) throws SdmxException {
        if (dSDIdentifier != null) {
            URL uRL = this.buildDSDQuery(dSDIdentifier.getId(), dSDIdentifier.getAgency(), dSDIdentifier.getVersion(), bl);
            return this.runQuery(new DataStructureParser(), uRL, null).get(0);
        }
        throw new InvalidParameterException("Null dsd in input");
    }

    @Override
    public Map<String, String> getCodes(String string, String string2, String string3) throws SdmxException {
        URL uRL = this.buildCodelistQuery(string, string2, string3);
        return this.runQuery(new CodelistParser(), uRL, null);
    }

    @Override
    protected DataParsingResult getData(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        URL uRL = this.buildDataQuery(dataflow, string, string2, string3, bl, string4, bl2);
        return this.runQuery(new CompactDataParser(dataFlowStructure, dataflow, !bl), uRL, this.acceptHdr);
    }

    @Override
    protected URL buildDataQuery(Dataflow dataflow, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        if (this.endpoint != null && dataflow != null && string != null && !string.isEmpty()) {
            return Sdmx21Queries.createDataQuery(this.endpoint, dataflow.getFullIdentifier(), string, string2, string3, bl, string4, bl2, this.format).buildSdmx21Query();
        }
        throw new RuntimeException("Invalid query parameters: dataflow=" + dataflow + " resource=" + string + " endpoint=" + this.endpoint);
    }
}

