/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima;

import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.TableOfBoolean;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.modelling.IRobustStandardDeviationComputer;
import ec.tstoolkit.timeseries.regression.IOutlierFactory;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import ec.tstoolkit.utilities.DoubleList;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class AbstractSingleOutlierDetector<T extends IArimaModel> {
    protected final IRobustStandardDeviationComputer sdevComputer;
    private final ArrayList<IOutlierFactory> m_o = new ArrayList();
    private final DoubleList m_ow = new DoubleList();
    private RegArimaModel<T> m_model;
    private TsDomain m_domain;
    private int m_lbound;
    private int m_ubound;
    private Matrix m_T;
    private Matrix m_c;
    private TableOfBoolean m_bT;
    private int m_posmax = -1;
    private int m_omax = -1;

    public AbstractSingleOutlierDetector(IRobustStandardDeviationComputer sdevComputer) {
        this.sdevComputer = sdevComputer;
    }

    public void addOutlierFactory(IOutlierFactory o) {
        this.m_o.add(o);
        this.m_ow.add(1.0);
        this.clear(true);
    }

    public void addOutlierFactory(IOutlierFactory o, double weight) {
        this.m_o.add(o);
        this.m_ow.add(weight);
        this.clear(true);
    }

    public IRobustStandardDeviationComputer getStandardDeviationComputer() {
        return this.sdevComputer;
    }

    protected abstract boolean calc();

    protected void clear(boolean all) {
        this.sdevComputer.reset();
        this.m_model = null;
        this.m_omax = -1;
        this.m_posmax = -1;
        if (all) {
            this.m_T = null;
            this.m_c = null;
            this.m_bT = null;
        } else if (this.m_T != null) {
            this.m_T.clear();
            this.m_c.clear();
        }
    }

    public void clearOutlierFactories() {
        this.m_o.clear();
        this.m_ow.clear();
        this.clear(true);
    }

    public double coeff(int pos, int outlier) {
        return this.m_c.get(pos, outlier);
    }

    public void exclude(int pos, int ioutlier) {
        if (pos >= 0 && pos < this.m_bT.getRowsCount()) {
            this.m_bT.set(pos, ioutlier, false);
            this.m_T.set(pos, ioutlier, 0.0);
        }
    }

    public void allow(int pos, int ioutlier) {
        if (pos >= 0 && pos < this.m_bT.getRowsCount()) {
            this.m_bT.set(pos, ioutlier, true);
            this.m_T.set(pos, ioutlier, 0.0);
        }
    }

    public void exclude(int[] pos) {
        if (pos == null) {
            return;
        }
        for (int i = 0; i < pos.length; ++i) {
            for (int j = 0; j < this.m_o.size(); ++j) {
                this.exclude(pos[i], j);
            }
        }
    }

    public void allow(int[] pos) {
        if (pos == null) {
            return;
        }
        for (int i = 0; i < pos.length; ++i) {
            for (int j = 0; j < this.m_o.size(); ++j) {
                this.allow(pos[i], j);
            }
        }
    }

    public void exclude(int pos) {
        for (int j = 0; j < this.m_o.size(); ++j) {
            this.exclude(pos, j);
        }
    }

    public void exclude(IOutlierVariable o) {
        TsPeriod start = new TsPeriod(this.m_domain.getFrequency(), o.getPosition());
        for (int i = 0; i < this.m_o.size(); ++i) {
            IOutlierFactory exemplar = this.m_o.get(i);
            if (!exemplar.getOutlierCode().equals(o.getCode())) continue;
            int pos = start.minus(this.m_domain.getStart());
            this.exclude(pos, i);
            break;
        }
    }

    public void allow(IOutlierVariable o) {
        for (int i = 0; i < this.m_o.size(); ++i) {
            IOutlierFactory exemplar = this.m_o.get(i);
            TsPeriod start = new TsPeriod(this.m_domain.getFrequency(), o.getPosition());
            if (!exemplar.getOutlierCode().equals(o.getCode())) continue;
            int pos = start.minus(this.m_domain.getStart());
            this.allow(pos, i);
            break;
        }
    }

    public void exclude(IOutlierVariable[] outliers) {
        for (IOutlierVariable o : outliers) {
            this.exclude(o);
        }
    }

    public void exclude(Iterator<IOutlierVariable> outliers) {
        while (outliers.hasNext()) {
            this.exclude(outliers.next());
        }
    }

    public void exclude(TsPeriod pos, int ioutlier) {
        int r = pos.minus(this.m_domain.getStart());
        if (r >= 0) {
            this.exclude(r, ioutlier);
        }
    }

    public TsDomain getDomain() {
        return this.m_domain;
    }

    public int getLBound() {
        return this.m_lbound;
    }

    public double getMAD() {
        return this.sdevComputer.get();
    }

    public IOutlierVariable getMaxOutlier() {
        if (this.m_posmax == -1) {
            this.searchMax();
        }
        if (this.m_omax == -1) {
            return null;
        }
        return this.m_o.get(this.m_omax).create(this.m_domain.get(this.m_posmax));
    }

    public int getMaxOutlierType() {
        if (this.m_omax == -1) {
            this.searchMax();
        }
        return this.m_omax;
    }

    public int getMaxPosition() {
        if (this.m_posmax == -1) {
            this.searchMax();
        }
        return this.m_posmax;
    }

    public double getMaxTStat() {
        if (this.m_omax == -1) {
            this.searchMax();
        }
        double tmax = this.T(this.m_posmax, this.m_omax);
        return tmax;
    }

    public RegArimaModel<T> getModel() {
        return this.m_model;
    }

    public int getOutlierFactoriesCount() {
        return this.m_o.size();
    }

    public IOutlierFactory getOutlierFactory(int i) {
        return this.m_o.get(i);
    }

    public int getUBound() {
        return this.m_ubound;
    }

    public boolean isDefined(int pos, int outlier) {
        return this.m_bT.get(pos, outlier);
    }

    public void prepare(TsDomain estimationdomain, TsDomain outliersdomain) {
        this.m_domain = estimationdomain;
        if (outliersdomain == null) {
            this.m_lbound = 0;
            this.m_ubound = estimationdomain.getLength();
        } else {
            TsDomain common = estimationdomain.intersection(outliersdomain);
            this.m_lbound = common.getStart().minus(estimationdomain.getStart());
            this.m_ubound = this.m_lbound + common.getLength();
        }
        this.prepareT(estimationdomain.getLength());
    }

    protected void prepareT(int n) {
        this.m_T = new Matrix(n, this.m_o.size());
        this.m_c = new Matrix(n, this.m_o.size());
        this.m_bT = new TableOfBoolean(n, this.m_o.size());
        for (int i = 0; i < this.m_o.size(); ++i) {
            IOutlierFactory fac = this.getOutlierFactory(i);
            TsDomain dom = fac.definitionDomain(this.m_domain);
            int jstart = Math.max(this.m_lbound, dom.getStart().minus(this.m_domain.getStart()));
            int jend = Math.min(this.m_ubound, dom.getEnd().minus(this.m_domain.getStart()));
            for (int j = jstart; j < jend; ++j) {
                this.m_bT.set(j, i, true);
            }
        }
    }

    public boolean process(RegArimaModel<T> model) {
        this.clear(false);
        this.m_model = model.clone();
        return this.calc();
    }

    private void searchMax() {
        if (this.m_T == null) {
            return;
        }
        double max = 0.0;
        int imax = -1;
        double[] T2 = this.m_T.internalStorage();
        int i = 0;
        for (int c = 0; c < this.m_T.getColumnsCount(); ++c) {
            double w = this.m_ow.get(c);
            int r = 0;
            while (r < this.m_T.getRowsCount()) {
                double cur = Math.abs(T2[i]) * w;
                if (cur > max) {
                    imax = i;
                    max = cur;
                }
                ++r;
                ++i;
            }
            if (imax != -1) continue;
            return;
        }
        this.m_posmax = imax % this.m_T.getRowsCount();
        this.m_omax = imax / this.m_T.getRowsCount();
    }

    protected void setT(int pos, int outlier, double val) {
        this.m_T.set(pos, outlier, val);
    }

    protected void setCoefficient(int pos, int outlier, double val) {
        this.m_c.set(pos, outlier, val);
    }

    public double T(int pos, int outlier) {
        return this.m_T.get(pos, outlier);
    }
}

