/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima;

import ec.tstoolkit.modelling.arima.IModelController;
import ec.tstoolkit.modelling.arima.IModelEstimator;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.PreprocessingModel;

public abstract class AbstractModelController
implements IModelController {
    private IModelEstimator estimator_;
    private PreprocessingModel refmodel_;

    @Override
    public PreprocessingModel getReferenceModel() {
        return this.refmodel_;
    }

    @Override
    public void setReferenceModel(PreprocessingModel model) {
        this.refmodel_ = model;
    }

    @Override
    public IModelEstimator getEstimator() {
        return this.estimator_;
    }

    @Override
    public void setEstimator(IModelEstimator estimator) {
        this.estimator_ = estimator;
    }

    protected boolean checkMean(ModellingContext context) {
        if (!context.description.isEstimatedMean()) {
            return true;
        }
        double ser = context.estimation.getLikelihood().getBSer(0, true, context.description.getArimaComponent().getFreeParametersCount());
        return Math.abs(context.estimation.getLikelihood().getB()[0] / ser) >= 1.96;
    }

    protected boolean estimate(ModellingContext context, boolean checkmean) {
        if (!this.estimator_.estimate(context)) {
            return false;
        }
        if (checkmean && !this.checkMean(context)) {
            context.description.setMean(false);
            if (!this.estimator_.estimate(context)) {
                return false;
            }
        }
        return true;
    }

    protected void transferInformation(ModellingContext from, ModellingContext to) {
        to.description = from.description;
        to.estimation = from.estimation;
        to.information.clear();
        to.information.copy(from.information);
    }
}

