/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.ssf;

import ec.benchmarking.BaseDisaggregation;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.ssf.ISsf;

public class WeightedSsfDisaggregation<S extends ISsf>
extends BaseDisaggregation
implements ISsf {
    private S ssf_;
    private double[] w_;

    public WeightedSsfDisaggregation(int conv, double[] w, S ssf) {
        super(conv);
        this.ssf_ = ssf;
        this.w_ = w;
    }

    @Override
    public void diffuseConstraints(SubMatrix b) {
        this.ssf_.diffuseConstraints(b.extract(1, b.getRowsCount(), 0, b.getColumnsCount()));
    }

    @Override
    public void fullQ(int pos, SubMatrix qm) {
        this.ssf_.fullQ(pos, qm.extract(1, qm.getRowsCount(), 1, qm.getColumnsCount()));
    }

    public S getInternalSsf() {
        return this.ssf_;
    }

    @Override
    public int getNonStationaryDim() {
        return this.ssf_.getNonStationaryDim();
    }

    @Override
    public int getStateDim() {
        return 1 + this.ssf_.getStateDim();
    }

    @Override
    public int getTransitionResCount() {
        return this.ssf_.getTransitionResCount();
    }

    @Override
    public int getTransitionResDim() {
        return this.ssf_.getTransitionResDim();
    }

    public double[] getWeights() {
        return this.w_;
    }

    @Override
    public boolean hasR() {
        return true;
    }

    @Override
    public boolean hasTransitionRes(int pos) {
        return this.ssf_.hasTransitionRes(pos);
    }

    @Override
    public boolean hasW() {
        return this.ssf_.hasW();
    }

    @Override
    public boolean isDiffuse() {
        return this.ssf_.isDiffuse();
    }

    @Override
    public boolean isMeasurementEquationTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTransitionEquationTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTransitionResidualTimeInvariant() {
        return true;
    }

    @Override
    public boolean isValid() {
        return this.ssf_.isValid();
    }

    @Override
    public void L(int pos, DataBlock k, SubMatrix lm) {
        double w = this.weight(pos);
        SubMatrix l = lm.extract(1, lm.getRowsCount(), 1, lm.getColumnsCount());
        this.ssf_.L(pos, k.drop(1, 0), l);
        DataBlock c0 = lm.column(0);
        c0.set(0.0);
        double s = -k.get(0);
        if (pos % this.conversion != 0) {
            if ((pos + 1) % this.conversion != 0) {
                c0.set(0, 1.0);
            }
            c0.sub(k);
        }
        if ((pos + 1) % this.conversion != 0) {
            s += 1.0;
        }
        DataBlock r0 = lm.row(0).drop(1, 0);
        r0.set(0.0);
        this.ssf_.XpZd(pos, r0, s * w);
    }

    @Override
    public void Pf0(SubMatrix pf0) {
        this.ssf_.Pf0(pf0.extract(1, pf0.getRowsCount(), 1, pf0.getColumnsCount()));
    }

    @Override
    public void Pi0(SubMatrix pi0) {
        this.ssf_.Pi0(pi0.extract(1, pi0.getRowsCount(), 1, pi0.getColumnsCount()));
    }

    @Override
    public void Q(int pos, SubMatrix qm) {
        this.ssf_.Q(pos, qm);
    }

    @Override
    public void R(int pos, SubArrayOfInt rv) {
        if (this.ssf_.hasR()) {
            this.ssf_.R(pos, rv);
            for (int i = 0; i < rv.getLength(); ++i) {
                rv.add(i, 1);
            }
        } else {
            int n = this.ssf_.getStateDim();
            for (int i = 0; i < n; ++i) {
                rv.add(i, i + 1);
            }
        }
    }

    @Override
    public void T(int pos, SubMatrix tr) {
        this.ssf_.T(pos, tr.extract(1, tr.getRowsCount(), 1, tr.getColumnsCount()));
        if ((pos + 1) % this.conversion != 0) {
            DataBlock t0 = tr.row(0).drop(1, 0);
            this.ssf_.Z(pos, t0);
            t0.mul(this.weight(pos));
            if (pos % this.conversion != 0) {
                tr.set(0, 0, 1.0);
            }
        }
    }

    @Override
    public void TVT(int pos, SubMatrix vm) {
        DataBlockIterator cols = vm.columns();
        DataBlock col = cols.getData();
        do {
            this.TX(pos, col);
        } while (cols.next());
        DataBlockIterator rows = vm.rows();
        DataBlock row = rows.getData();
        do {
            this.TX(pos, row);
        } while (rows.next());
    }

    @Override
    public void TX(int pos, DataBlock x) {
        DataBlock xc = x.drop(1, 0);
        if ((pos + 1) % this.conversion != 0) {
            double s = this.ssf_.ZX(pos, xc);
            double w = this.weight(pos);
            if (pos % this.conversion == 0) {
                x.set(0, s * w);
            } else {
                x.add(0, s * w);
            }
        } else {
            x.set(0, 0.0);
        }
        this.ssf_.TX(pos, xc);
    }

    @Override
    public void VpZdZ(int pos, SubMatrix vm, double d) {
        double w = this.weight(pos);
        SubMatrix v = vm.extract(1, vm.getRowsCount(), 1, vm.getColumnsCount());
        this.ssf_.VpZdZ(pos, v, w * w * d);
        if (pos % this.conversion != 0) {
            vm.add(0, 0, d);
            this.ssf_.XpZd(pos, vm.column(0).drop(1, 0), w * d);
            this.ssf_.XpZd(pos, vm.row(0).drop(1, 0), w * d);
        }
    }

    @Override
    public void W(int pos, SubMatrix wv) {
        this.ssf_.W(pos, wv);
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        double w = this.weight(pos);
        this.ssf_.XpZd(pos, x.drop(1, 0), w * d);
        if (pos % this.conversion != 0) {
            x.add(0, d);
        }
    }

    @Override
    public void XT(int pos, DataBlock x) {
        DataBlock xc = x.drop(1, 0);
        double w = this.weight(pos);
        this.ssf_.XT(pos, xc);
        if ((pos + 1) % this.conversion != 0) {
            this.ssf_.XpZd(pos, xc, x.get(0) * w);
            if (pos % this.conversion == 0) {
                x.set(0, 0.0);
            }
        } else {
            x.set(0, 0.0);
        }
    }

    @Override
    public void Z(int pos, DataBlock z) {
        if (pos % this.conversion != 0) {
            z.set(0, 1.0);
        }
        DataBlock zc = z.drop(1, 0);
        this.ssf_.Z(pos, zc);
        zc.mul(this.weight(pos));
    }

    @Override
    public void ZM(int pos, SubMatrix m, DataBlock x) {
        if (pos % this.conversion == 0) {
            x.set(0.0);
        } else {
            x.copy(m.row(0));
        }
        double w = this.weight(pos);
        SubMatrix q = m.extract(1, m.getRowsCount(), 0, m.getColumnsCount());
        DataBlockIterator c = q.columns();
        DataBlock col = c.getData();
        do {
            x.add(c.getPosition(), w * this.ssf_.ZX(pos, col));
        } while (c.next());
    }

    @Override
    public double ZVZ(int pos, SubMatrix vm) {
        double w = this.weight(pos);
        SubMatrix v = vm.extract(1, vm.getRowsCount(), 1, vm.getColumnsCount());
        if (pos % this.conversion == 0) {
            return w * w * this.ssf_.ZVZ(pos, v);
        }
        double r = vm.get(0, 0);
        r += 2.0 * w * this.ssf_.ZX(pos, vm.row(0).drop(1, 0));
        return r += w * w * this.ssf_.ZVZ(pos, v);
    }

    @Override
    public double ZX(int pos, DataBlock x) {
        double r = pos % this.conversion == 0 ? 0.0 : x.get(0);
        return r + this.mweight(pos, this.ssf_.ZX(pos, x.drop(1, 0)));
    }

    private double mweight(int pos, double m) {
        return this.w_ == null ? m : this.w_[pos] * m;
    }

    private double mweight2(int pos, double m) {
        return this.w_ == null ? m : this.w_[pos] * this.w_[pos] * m;
    }

    private double weight(int pos) {
        return this.w_ == null ? 1.0 : this.w_[pos];
    }

    private double weight2(int pos) {
        return this.w_ == null ? 1.0 : this.w_[pos] * this.w_[pos];
    }
}

