/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.arima.estimation.AnsleyFilter;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.dstats.Normal;
import ec.tstoolkit.dstats.ProbabilityType;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.maths.matrices.Householder;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.maths.realfunctions.ProxyMinimizer;
import ec.tstoolkit.maths.realfunctions.levmar.LevenbergMarquardtMethod;
import ec.tstoolkit.modelling.IRobustStandardDeviationComputer;
import ec.tstoolkit.modelling.arima.AbstractSingleOutlierDetector;
import ec.tstoolkit.modelling.arima.ExactSingleOutlierDetector;
import ec.tstoolkit.modelling.arima.IOutliersDetectionModule;
import ec.tstoolkit.modelling.arima.IResidualsComputer;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModelEstimation;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.x13.X13Preprocessor;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.estimation.GlsSarimaMonitor;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.regression.AdditiveOutlierFactory;
import ec.tstoolkit.timeseries.regression.IOutlierFactory;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.LevelShiftFactory;
import ec.tstoolkit.timeseries.regression.SeasonalOutlierFactory;
import ec.tstoolkit.timeseries.regression.TransitoryChangeFactory;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.ArrayList;

public class OutliersDetector
implements IOutliersDetectionModule {
    private static final int MAX_OUTLIERS = 30;
    private static final int MAX_ITER = 30;
    private final GlsSarimaMonitor monitor;
    private AbstractSingleOutlierDetector<SarimaModel> sod_;
    private RegArimaModel<SarimaModel> regarima_;
    private double llcorr_;
    private IParametricMapping<SarimaModel> mapping_;
    private ModelEstimation estimation_;
    private ArrayList<IOutlierVariable> outliers_ = new ArrayList();
    private int maxiter_ = 30;
    private int m_round;
    private int selectivity_;
    private double cv_;
    private double curcv_;
    private double pc_ = 0.14286;
    private TsPeriodSelector span_;
    public static final double MINCV = 2.8;

    public double getEpsilon() {
        return this.monitor.getPrecision();
    }

    public void setEpsilon(double val) {
        this.monitor.setPrecision(val);
    }

    public void setSpan(TsPeriodSelector span) {
        this.span_ = span;
    }

    public TsPeriodSelector getSpan() {
        return this.span_;
    }

    @Override
    public ProcessingResult process(ModellingContext context) {
        try {
            this.clear();
            if (this.curcv_ == 0.0) {
                this.curcv_ = this.calcCv(context);
            }
            this.llcorr_ = context.description.getLikelihoodCorrection();
            this.mapping_ = X13Preprocessor.createDefaultMapping(context.description);
            if (context.estimation == null) {
                this.regarima_ = context.description.buildRegArima();
                if (!this.estimateModel()) {
                    return ProcessingResult.Failed;
                }
            } else {
                this.estimation_ = context.estimation;
                this.regarima_ = context.estimation.getRegArima();
            }
            TsDomain edomain = context.description.getEstimationDomain();
            this.sod_.prepare(edomain, this.span_ == null ? null : edomain.select(this.span_));
            this.sod_.exclude(context.description.getMissingValues());
            this.sod_.exclude(context.description.getOutliersPosition(true));
            this.sod_.exclude(context.description.getOutliersPosition(false));
            this.sod_.exclude(context.description.getFixedOutliersPosition());
            this.outliers_.addAll(context.description.getOutliers());
            boolean changed = this.execute();
            context.description.setOutliers(this.outliers_);
            context.estimation = this.estimation_;
            this.addInfo(context.description, context.information);
            if (changed) {
                return ProcessingResult.Changed;
            }
            return ProcessingResult.Unchanged;
        }
        catch (RuntimeException err) {
            return ProcessingResult.Failed;
        }
    }

    public OutliersDetector() {
        this.sod_ = new ExactSingleOutlierDetector<SarimaModel>(IRobustStandardDeviationComputer.mad(false), IResidualsComputer.mlComputer(), new AnsleyFilter());
        this.monitor = new GlsSarimaMonitor();
        this.monitor.setMinimizer(new ProxyMinimizer(new LevenbergMarquardtMethod()));
        this.monitor.useLogLikelihood(false);
    }

    public OutliersDetector(AbstractSingleOutlierDetector<SarimaModel> sod) {
        this.sod_ = sod;
        this.monitor = new GlsSarimaMonitor();
        this.monitor.setMinimizer(new ProxyMinimizer(new LevenbergMarquardtMethod()));
        this.monitor.useLogLikelihood(false);
    }

    private void addOutlier(IOutlierVariable o) {
        this.outliers_.add(o);
        double[] xo = new double[this.regarima_.getObsCount()];
        DataBlock XO = new DataBlock(xo);
        o.data(this.sod_.getDomain().getStart(), XO);
        this.regarima_.addX(XO);
        this.sod_.exclude(o);
    }

    public void addOutlierFactory(IOutlierFactory o) {
        this.sod_.addOutlierFactory(o);
    }

    public void clear() {
        this.outliers_.clear();
        this.regarima_ = null;
        this.estimation_ = null;
        this.llcorr_ = 0.0;
        this.mapping_ = null;
    }

    public void clearOutlierFactories() {
        this.sod_.clearOutlierFactories();
    }

    private boolean execute() {
        double max;
        boolean changed = false;
        this.m_round = 0;
        while (this.sod_.process(this.regarima_) && Math.abs(max = this.sod_.getMaxTStat()) > this.curcv_) {
            ++this.m_round;
            IOutlierVariable o = this.sod_.getMaxOutlier();
            this.addOutlier(o);
            changed = true;
            if (!this.estimateModel()) {
                this.outliers_.remove(o);
                this.estimateModel();
                break;
            }
            if (this.m_round < this.maxiter_ && this.outliers_.size() < 30) continue;
        }
        while (this.verifymodel(this.curcv_) == 0 && this.estimateModel()) {
            changed = true;
        }
        return changed;
    }

    public void setCriticalValue(double value) {
        this.cv_ = value;
    }

    public double getCritivalValue() {
        return this.cv_;
    }

    public double getPc() {
        return this.pc_;
    }

    public void setPc(double pc) {
        this.pc_ = pc;
    }

    public int getMaxIter() {
        return this.maxiter_;
    }

    public void setMaxIter(int maxiter) {
        this.maxiter_ = maxiter;
    }

    public RegArimaModel<SarimaModel> getModel() {
        return this.regarima_;
    }

    public int getOutlierFactoriesCount() {
        return this.sod_.getOutlierFactoriesCount();
    }

    public int getOutliersCount() {
        return this.outliers_.size();
    }

    private boolean estimateModel() {
        this.estimation_ = new ModelEstimation(this.regarima_, this.llcorr_);
        this.monitor.setMapping(this.mapping_);
        if (!this.estimation_.compute(this.monitor, this.mapping_.getDim())) {
            return false;
        }
        this.regarima_ = this.estimation_.getRegArima();
        return true;
    }

    public boolean isInitialized() {
        return this.regarima_ != null;
    }

    private void removeOutlier(int idx) {
        int opos = this.regarima_.getXCount() - this.outliers_.size() + idx;
        this.regarima_.removeX(opos);
        this.outliers_.remove(idx);
    }

    public void setAll() {
        this.clear();
        this.clearOutlierFactories();
        this.addOutlierFactory(new AdditiveOutlierFactory());
        LevelShiftFactory lfac = new LevelShiftFactory();
        lfac.setZeroEnded(true);
        this.addOutlierFactory(lfac);
        TransitoryChangeFactory tfac = new TransitoryChangeFactory();
        tfac.setMonthlyCoefficient(true);
        this.addOutlierFactory(tfac);
        SeasonalOutlierFactory sfac = new SeasonalOutlierFactory();
        sfac.setZeroEnded(true);
        this.addOutlierFactory(sfac);
    }

    public void setDefault() {
        this.clear();
        this.clearOutlierFactories();
        this.addOutlierFactory(new AdditiveOutlierFactory());
        LevelShiftFactory lfac = new LevelShiftFactory();
        lfac.setZeroEnded(true);
        this.addOutlierFactory(lfac);
        TransitoryChangeFactory tfac = new TransitoryChangeFactory();
        tfac.setMonthlyCoefficient(true);
        this.addOutlierFactory(tfac);
        this.curcv_ = 0.0;
    }

    private int verifymodel(double cv) {
        if (this.regarima_ == null) {
            return 1;
        }
        if (this.outliers_.isEmpty()) {
            return 1;
        }
        int imin = 0;
        double[] t = this.estimation_.getLikelihood().getTStats(false, 0);
        int nx0 = this.regarima_.getVarsCount() - this.outliers_.size();
        for (int i = 1; i < this.outliers_.size(); ++i) {
            if (!(Math.abs(t[i + nx0]) < Math.abs(t[imin + nx0]))) continue;
            imin = i;
        }
        if (Math.abs(t[nx0 + imin]) >= cv) {
            return 1;
        }
        this.removeOutlier(imin);
        return 0;
    }

    private void addInfo(ModelDescription desc, InformationSet information) {
        InformationSet subset = information.subSet("outliers");
        subset.set("count", Integer.valueOf(desc.getOutliers().size()));
    }

    @Override
    public boolean reduceSelectivity() {
        if (this.curcv_ == 0.0) {
            return false;
        }
        --this.selectivity_;
        if (this.curcv_ == 2.8) {
            return false;
        }
        this.curcv_ = Math.max(2.8, this.curcv_ * (1.0 - this.pc_));
        return true;
    }

    @Override
    public void setSelectivity(int level) {
        if (this.selectivity_ != level) {
            this.selectivity_ = level;
            this.curcv_ = 0.0;
        }
    }

    @Override
    public int getSelectivity() {
        return this.selectivity_;
    }

    private double calcCv(ModellingContext context) {
        double cv = this.cv_;
        if (cv == 0.0) {
            cv = new CriticalValueComputer().compute(context.description.getEstimationDomain().getLength());
        }
        for (int i = 0; i < -this.selectivity_; ++i) {
            cv *= 1.0 - this.pc_;
        }
        return Math.max(cv, 2.8);
    }

    public static class CriticalValueComputer
    implements IOutliersDetectionModule.ICriticalValueComputer {
        private final double eps;

        public CriticalValueComputer() {
            this.eps = 0.05;
        }

        public CriticalValueComputer(double eps) {
            this.eps = eps;
        }

        private double calcVAL(int nvals) {
            if (nvals == 1) {
                return 1.96;
            }
            double n = nvals;
            double pmod = 2.0 - Math.sqrt(1.0 + this.eps);
            double acv = Math.sqrt(2.0 * Math.log(n));
            double bcv = acv - (Math.log(Math.log(n)) + Math.log(Math.PI * 4)) / (2.0 * acv);
            double xcv = -Math.log(-0.5 * Math.log(pmod));
            return xcv / acv + bcv;
        }

        @Override
        public double compute(int nvals) {
            int i;
            Normal normal = new Normal();
            if (nvals == 1) {
                return normal.getProbabilityInverse(this.eps / 2.0, ProbabilityType.Upper);
            }
            double n = nvals;
            double[] y = new double[3];
            int[] x = new int[]{2, 100, 200};
            Matrix X = new Matrix(3, 3);
            for (i = 0; i < 3; ++i) {
                X.set(i, 0, 1.0);
                X.set(i, 2, Math.sqrt(2.0 * Math.log(x[i])));
                X.set(i, 1, (Math.log(Math.log(x[i])) + Math.log(Math.PI * 4)) / (2.0 * X.get(i, 2)));
            }
            y[0] = normal.getProbabilityInverse((1.0 + Math.sqrt(1.0 - this.eps)) / 2.0, ProbabilityType.Lower);
            for (i = 1; i < 3; ++i) {
                y[i] = this.calcVAL(x[i]);
            }
            Householder qr = new Householder(false);
            qr.decompose(X);
            double[] b = qr.solve(y);
            double acv = Math.sqrt(2.0 * Math.log(n));
            double bcv = (Math.log(Math.log(n)) + Math.log(Math.PI * 4)) / (2.0 * acv);
            return b[0] + b[1] * bcv + b[2] * acv;
        }
    }
}

