/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.arima.estimation.ArmaKF;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.modelling.arima.IPreprocessingModule;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.tramo.TramoProcessor;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.sarima.SarmaSpecification;
import ec.tstoolkit.sarima.estimation.HannanRissanen;
import java.util.Arrays;

public class ArmaModule
implements IPreprocessingModule {
    private HRBic[] m_hrs;
    private boolean m_bforced = false;
    private final int m_nmod;
    private static final int NMOD = 5;
    private boolean acceptwn = false;
    private static final String ARMA = "Arma identification";

    static int comespa(int freq, int n, int inic, int d, int bd, boolean seas) {
        for (int i = inic; i > 0; --i) {
            if (!ArmaModule.checkespa(freq, n, i, d, bd, seas)) continue;
            return i;
        }
        return 0;
    }

    static boolean checkespa(int freq, int nz, int inic, int d, int bd, boolean seas) {
        SarimaSpecification spec = ArmaModule.checkmaxspec(freq, inic, d, bd, seas);
        if (TramoProcessor.autlar(nz, spec) < 0) {
            return false;
        }
        int n = nz - spec.getP() - spec.getFrequency() * spec.getBP();
        spec.setP(0);
        spec.setBP(0);
        return TramoProcessor.autlar(n, spec) >= 0;
    }

    static SarimaSpecification calcmaxspec(int freq, int inic, int d, int bd, boolean seas) {
        SarimaSpecification spec = new SarimaSpecification(freq);
        spec.setD(d);
        if (seas) {
            spec.setBD(bd);
        }
        switch (inic) {
            case 1: {
                spec.setP(1);
                spec.setQ(1);
                if (!seas) break;
                spec.setBP(1);
                spec.setBQ(1);
                break;
            }
            case 2: {
                spec.setP(2);
                spec.setQ(2);
                if (!seas) break;
                spec.setBP(1);
                spec.setBQ(1);
                break;
            }
            case 3: {
                spec.setP(3);
                spec.setQ(3);
                if (!seas) break;
                spec.setBP(1);
                spec.setBQ(1);
                break;
            }
            case 4: {
                spec.setP(3);
                spec.setQ(3);
                spec.setBP(2);
                spec.setBQ(2);
            }
        }
        return spec;
    }

    static SarimaSpecification checkmaxspec(int freq, int inic, int d, int bd, boolean seas) {
        SarimaSpecification spec = new SarimaSpecification(freq);
        spec.setD(d);
        if (seas) {
            spec.setBD(bd);
        }
        switch (inic) {
            case 1: {
                spec.setP(1);
                spec.setQ(1);
                if (!seas) break;
                if (bd == 0) {
                    spec.setBP(1);
                }
                spec.setBQ(1);
                break;
            }
            case 2: {
                spec.setP(2);
                spec.setQ(2);
                if (!seas) break;
                if (bd == 0) {
                    spec.setBP(1);
                }
                spec.setBQ(1);
                break;
            }
            case 3: {
                spec.setP(3);
                spec.setQ(3);
                if (!seas) break;
                if (bd == 0) {
                    spec.setBP(1);
                }
                spec.setBQ(1);
                break;
            }
            case 4: {
                spec.setP(3);
                spec.setQ(3);
                if (!seas) break;
                spec.setBP(2);
                spec.setBQ(2);
            }
        }
        return spec;
    }

    @Override
    public ProcessingResult process(ModellingContext context) {
        int m;
        SarimaSpecification curspec = context.description.getSpecification();
        switch (curspec.getFrequency()) {
            case 2: {
                m = 1;
                break;
            }
            case 3: {
                m = 2;
                break;
            }
            default: {
                m = 3;
            }
        }
        int inic = ArmaModule.comespa(curspec.getFrequency(), context.description.getEstimationDomain().getLength(), m, curspec.getD(), curspec.getBD(), context.hasseas);
        if (inic == 0) {
            curspec.airline(context.hasseas);
            context.description.setSpecification(curspec);
            context.estimation = null;
            return ProcessingResult.Changed;
        }
        SarimaSpecification maxspec = ArmaModule.calcmaxspec(context.description.getFrequency(), inic, curspec.getD(), curspec.getBD(), context.hasseas);
        DataBlock res = context.description.getOlsResiduals();
        HannanRissanen hr = this.tramo(res, maxspec.doStationary(), maxspec.getD(), maxspec.getBD(), context.hasseas);
        for (int i = 0; i < this.m_hrs.length; ++i) {
            this.addModelInfo(context, this.m_hrs[i]);
        }
        if (hr == null) {
            context.description.setAirline(context.hasseas);
            context.estimation = null;
            return ProcessingResult.Failed;
        }
        SarmaSpecification rsltSpec = hr.getSpec();
        if (rsltSpec.equals((Object)curspec.doStationary())) {
            return ProcessingResult.Unchanged;
        }
        curspec.copy(rsltSpec);
        context.description.setSpecification(curspec);
        context.estimation = null;
        return ProcessingResult.Changed;
    }

    public ArmaModule() {
        this.m_nmod = 5;
    }

    public ArmaModule(int nmod) {
        this.m_nmod = nmod;
    }

    public void clear() {
        this.m_hrs = null;
        this.m_bforced = false;
    }

    public void setAcceptingWhiteNoise(boolean wn) {
        this.acceptwn = wn;
    }

    public boolean isAcceptingWhiteNoise() {
        return this.acceptwn;
    }

    public int getCount() {
        return this.m_hrs == null ? 0 : this.m_hrs.length;
    }

    public HRBic[] getPreferedModels() {
        return this.m_hrs;
    }

    public HannanRissanen HR(int idx) {
        return this.m_hrs[idx].getHR();
    }

    public boolean isMA1Forced() {
        return this.m_bforced;
    }

    private void merge(HRBic[] mods) {
        if (this.m_hrs == null) {
            return;
        }
        int gmod = mods.length;
        int nmax = this.getCount();
        if (nmax > gmod) {
            nmax = gmod;
        }
        int icur = 0;
        block0: for (int i = 0; i < nmax && icur < gmod; ++i) {
            HannanRissanen hrcur = this.m_hrs[i].getHR();
            double bic = this.m_hrs[i].getBIC();
            for (int j = icur; j < gmod; ++j) {
                if (mods[j] == null) {
                    mods[j] = this.m_hrs[i];
                    icur = j + 1;
                    continue block0;
                }
                if (mods[j].getHR().getSpec().equals((Object)hrcur.getSpec())) {
                    icur = j + 1;
                    continue block0;
                }
                if (!(mods[j].getBIC() > bic)) continue;
                for (int k = gmod - 1; k > j; --k) {
                    mods[k] = mods[k - 1];
                }
                mods[j] = this.m_hrs[i];
                icur = j + 1;
                continue block0;
            }
        }
    }

    public HannanRissanen select(IReadDataBlock data, int d, int bd) {
        int idmax;
        for (idmax = this.m_nmod; this.m_hrs[idmax - 1] == null || this.m_hrs[idmax - 1].getHR() == null && idmax > 0; --idmax) {
        }
        if (idmax == 0) {
            return null;
        }
        if (idmax == 1) {
            return this.m_hrs[0].getHR();
        }
        SarmaSpecification spec = this.m_hrs[0].getHR().getSpec();
        int nr1 = spec.getP() + spec.getQ();
        int ns1 = spec.getBP() + spec.getBQ();
        int nrr1 = Math.abs(spec.getP() + d - spec.getQ());
        int nss1 = Math.abs(spec.getBP() + bd - spec.getBQ());
        double bmax = this.m_hrs[idmax - 1].getBIC() - this.m_hrs[0].getBIC();
        bmax = bmax < 0.003 ? 0.0625 : (bmax < 0.03 ? 0.25 : 1.0);
        double vc11 = 0.01 * bmax;
        double vc2 = 0.0025 * bmax;
        double vc22 = 0.0075 * bmax;
        int idpref = 0;
        int icmod = 0;
        for (int i = 1; i < idmax; ++i) {
            SarmaSpecification cur = this.m_hrs[i].getHR().getSpec();
            int nr2 = cur.getP() + cur.getQ();
            int ns2 = cur.getBP() + cur.getBQ();
            int nrr2 = Math.abs(cur.getP() + d - cur.getQ());
            int nss2 = Math.abs(cur.getBP() + bd - cur.getBQ());
            double dbic = this.m_hrs[i].getBIC() - this.m_hrs[idpref].getBIC();
            if (!((nrr2 < nrr1 || nss2 < nss1) && nr1 == nr2 && ns1 == ns2 && dbic <= vc11 || nrr2 < nrr1 && nr2 <= nr1 && ns2 == ns1 && dbic <= vc2 && cur.getP() > 0 && cur.getQ() > 0 || (nrr2 == 0 && nrr2 < nrr1 && d > 0 || nss2 == 0 && nss2 < nss1 && bd > 0) && nr1 == nr2 && ns1 == ns2 && dbic <= vc11 || nrr2 == 0 && nss2 == 0 && dbic < vc2 || nr2 > nr1 && nrr2 == 0 && ns2 == ns1 && dbic < vc2 || i == 1 && nr1 == 0 && nr2 == 1 && ns2 == ns1 && dbic < vc2 || ns2 > ns1 && nss2 == 0 && nr2 == nr1 && dbic < vc2 || nr2 < nr1 && nr2 > 0 && ns2 == ns1 && dbic < vc2 || cur.getP() < spec.getP() && cur.getQ() == spec.getQ() && nr2 > 0 && ns2 == ns1 && dbic < vc22 || ns2 < ns1 && ns2 > 0 && nr2 == nr1 && nss2 == 0 && dbic < vc2) && (ns2 >= ns1 || ns2 <= 0 || nr2 != nr1 || !(dbic < vc2))) continue;
            ++icmod;
            double dc = this.m_hrs[i].getBIC() - this.m_hrs[0].getBIC();
            vc11 -= dc;
            vc2 -= dc;
            vc22 -= dc;
            nr1 = nr2;
            ns1 = ns2;
            nrr1 = nrr2;
            nss1 = nss2;
            idpref = i;
            spec = cur.clone();
        }
        if (spec.getParametersCount() == 0 && idpref < this.m_nmod - 1) {
            return this.m_hrs[idpref + 1].getHR();
        }
        return this.m_hrs[idpref].getHR();
    }

    public int sort(IReadDataBlock data, SarmaSpecification maxspec) {
        int nspecs = (maxspec.getP() + 1) * (maxspec.getQ() + 1) * (maxspec.getBP() + 1) * (maxspec.getBQ() + 1);
        SarmaSpecification[] specs = new SarmaSpecification[nspecs];
        int i = 0;
        for (int p = 0; p <= maxspec.getP(); ++p) {
            for (int q = 0; q <= maxspec.getQ(); ++q) {
                for (int bp = 0; bp <= maxspec.getBP(); ++bp) {
                    for (int bq = 0; bq <= maxspec.getBQ(); ++bq) {
                        SarmaSpecification spec = new SarmaSpecification();
                        spec.setFrequency(maxspec.getFrequency());
                        spec.setP(p);
                        spec.setQ(q);
                        spec.setBP(bp);
                        spec.setBQ(bq);
                        specs[i++] = spec;
                    }
                }
            }
        }
        return this.sort(data, specs);
    }

    public int sort(IReadDataBlock data, SarmaSpecification[] specs) {
        int i;
        this.m_hrs = null;
        HRBic[] hrs = new HRBic[specs.length];
        int n = 0;
        for (i = 0; i < specs.length; ++i) {
            SarimaModel m;
            HannanRissanen hr = new HannanRissanen();
            if (!hr.process(data, specs[i]) || (m = hr.getModel()).adjustSpecification() || !m.isStable(true)) continue;
            HRBic hrbic = new HRBic(hr);
            hrs[n++] = hrbic;
        }
        if (n == 0) {
            return 0;
        }
        this.m_hrs = new HRBic[n];
        for (i = 0; i < n; ++i) {
            this.m_hrs[i] = hrs[i];
        }
        Arrays.sort(this.m_hrs);
        return n;
    }

    private SarmaSpecification getPreferredSpecification() {
        int idx;
        if (this.m_hrs.length == 1) {
            return this.m_hrs[0].m_hr.getSpec().clone();
        }
        for (idx = 0; idx < this.m_hrs.length && this.m_hrs[idx].m_hr.getSpec().getParametersCount() == 0; ++idx) {
        }
        return this.m_hrs[idx].m_hr.getSpec().clone();
    }

    public HannanRissanen tramo(IReadDataBlock data, SarmaSpecification maxspec, int d, int bd, boolean seas) {
        SarmaSpecification cur;
        int nmax;
        int i;
        this.clear();
        int gpr = maxspec.getP();
        int gqr = maxspec.getQ();
        int gps = maxspec.getBP();
        int gqs = maxspec.getBQ();
        SarmaSpecification[] specs = new SarmaSpecification[(gps + 1) * (gqs + 1)];
        SarmaSpecification spec = new SarmaSpecification();
        this.m_hrs = new HRBic[this.m_nmod];
        spec.setFrequency(maxspec.getFrequency());
        spec.setP(3);
        spec.setQ(0);
        if (seas) {
            i = 0;
            for (int bp = 0; bp <= gps; ++bp) {
                for (int bq = 0; bq <= gqs; ++bq) {
                    spec.setBP(bp);
                    spec.setBQ(bq);
                    specs[i++] = spec.clone();
                }
            }
            ArmaModule step0 = new ArmaModule();
            nmax = step0.sort(data, specs);
            if (0 == nmax) {
                for (i = 0; i < specs.length; ++i) {
                    specs[i].setP(1);
                    nmax = step0.sort(data, specs);
                }
                if (0 == nmax) {
                    return null;
                }
            }
            cur = step0.getPreferredSpecification();
            if (spec.getP() <= maxspec.getP()) {
                step0.merge(this.m_hrs);
            }
        } else {
            cur = spec.clone();
        }
        specs = new SarmaSpecification[(gpr + 1) * (gqr + 1)];
        i = 0;
        for (int p = 0; p <= gpr; ++p) {
            for (int q = 0; q <= gqr; ++q) {
                cur.setP(p);
                cur.setQ(q);
                specs[i++] = cur.clone();
            }
        }
        ArmaModule step1 = new ArmaModule();
        nmax = step1.sort(data, specs);
        if (0 == nmax) {
            return null;
        }
        cur = step1.getPreferredSpecification();
        step1.merge(this.m_hrs);
        if (seas) {
            specs = new SarmaSpecification[(gps + 1) * (gqs + 1)];
            int i2 = 0;
            for (int bp = 0; bp <= gps; ++bp) {
                for (int bq = 0; bq <= gqs; ++bq) {
                    cur.setBP(bp);
                    cur.setBQ(bq);
                    specs[i2++] = cur.clone();
                }
            }
            ArmaModule step2 = new ArmaModule();
            if (0 == step2.sort(data, specs)) {
                return null;
            }
            step2.merge(this.m_hrs);
        }
        if (!seas) {
            if (this.m_hrs[1] != null && this.m_hrs[0].getHR().getSpec().getParametersCount() == 0 && !this.acceptwn) {
                return this.m_hrs[1].getHR();
            }
            return this.m_hrs[0].getHR();
        }
        return this.select(data, d, bd);
    }

    private void addModelInfo(ModellingContext context, HRBic hr) {
    }

    public static class HRBic
    implements Comparable<HRBic> {
        private final HannanRissanen m_hr;
        private final double m_bic;

        public HRBic(HannanRissanen hr) {
            this.m_hr = hr;
            ArmaKF fkf = new ArmaKF(hr.getModel());
            this.m_bic = fkf.fastProcessing(hr.getData(), hr.getSpec().getParametersCount());
        }

        @Override
        public int compareTo(HRBic o) {
            return Double.compare(this.m_bic, o.m_bic);
        }

        public double getBIC() {
            return this.m_bic;
        }

        public HannanRissanen getHR() {
            return this.m_hr;
        }
    }
}

