/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.realfunctions.minpack;

import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.realfunctions.ISsqFunction;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionInstance;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionMinimizer;
import ec.tstoolkit.maths.realfunctions.minpack.ILmHook;
import ec.tstoolkit.maths.realfunctions.minpack.LevenbergMarquardtEstimator;
import ec.tstoolkit.maths.realfunctions.minpack.SsqEstimationProblem;

public class LevenbergMarquardtMinimizer
implements ISsqFunctionMinimizer {
    private LevenbergMarquardtEstimator m_estimator = new LevenbergMarquardtEstimator();
    private SsqEstimationProblem m_problem;

    public void setHook(ILmHook hook) {
        this.m_estimator.setHook(hook);
    }

    @Override
    public ISsqFunctionMinimizer exemplar() {
        return new LevenbergMarquardtMinimizer();
    }

    @Override
    public double getConvergenceCriterion() {
        return this.m_estimator.getCostRelativeTolerance();
    }

    @Override
    public Matrix getCurvature() {
        try {
            return this.m_estimator.curvature(this.m_problem);
        }
        catch (Exception err) {
            return null;
        }
    }

    @Override
    public double[] getGradient() {
        return this.m_problem.getGradient();
    }

    @Override
    public int getIterCount() {
        return this.m_estimator.getIterCount();
    }

    @Override
    public int getMaxIter() {
        return this.m_estimator.getMaxIter();
    }

    @Override
    public ISsqFunctionInstance getResult() {
        return this.m_problem.getResult();
    }

    @Override
    public double getObjective() {
        return this.m_problem.getResult() == null ? Double.NaN : this.m_problem.getResult().getSsqE();
    }

    public boolean minimize(ISsqFunction fn, IReadDataBlock start) {
        this.m_problem = new SsqEstimationProblem(fn, start);
        try {
            this.m_estimator.estimate(this.m_problem);
            return this.m_estimator.getIterCount() < this.m_estimator.getMaxIter();
        }
        catch (RuntimeException err) {
            return false;
        }
    }

    @Override
    public boolean minimize(ISsqFunction fn, ISsqFunctionInstance start) {
        this.m_problem = new SsqEstimationProblem(fn, start);
        try {
            this.m_estimator.estimate(this.m_problem);
            return this.m_estimator.getIterCount() < this.m_estimator.getMaxIter();
        }
        catch (RuntimeException err) {
            return false;
        }
    }

    @Override
    public void setConvergenceCriterion(double value) {
        this.m_estimator.setCostRelativeTolerance(value);
    }

    @Override
    public void setMaxIter(int n) {
        this.m_estimator.setMaxIter(n);
    }
}

