/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.jdr.sa;

import demetra.algorithm.IProcResults;
import demetra.information.InformationMapping;
import ec.satoolkit.DecompositionMode;
import ec.satoolkit.ISaResults;
import ec.satoolkit.ISeriesDecomposition;
import ec.satoolkit.diagnostics.CombinedSeasonalityTest;
import ec.satoolkit.diagnostics.FTest;
import ec.satoolkit.diagnostics.KruskalWallisTest;
import ec.satoolkit.diagnostics.StationaryVarianceDecomposition;
import ec.satoolkit.x11.DefaultSeasonalFilteringStrategy;
import ec.satoolkit.x11.DefaultTrendFilteringStrategy;
import ec.satoolkit.x11.FilterFactory;
import ec.satoolkit.x11.FilteredMeanEndPoints;
import ec.satoolkit.x11.IEndPointsProcessor;
import ec.satoolkit.x11.MsrTable;
import ec.satoolkit.x11.SeriesEvolution;
import ec.satoolkit.x11.TrendCycleFilterFactory;
import ec.satoolkit.x11.X11Results;
import ec.tstoolkit.algorithm.ProcessingInformation;
import ec.tstoolkit.data.AutoCorrelations;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.eco.Ols;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.StatisticalTest;
import ec.tstoolkit.jdr.tests.CombinedSeasonalityTestInfo;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.modelling.arima.JointRegressionTest;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.diagnostics.OneStepAheadForecastingTest;
import ec.tstoolkit.modelling.arima.tramo.SeasonalityTests;
import ec.tstoolkit.modelling.arima.tramo.SpectralPeaks;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import ec.tstoolkit.timeseries.regression.GregorianCalendarVariables;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SaDiagnostics
implements IProcResults {
    static final InformationMapping<SaDiagnostics> MAPPING = new InformationMapping<SaDiagnostics>(SaDiagnostics.class);
    private final PreprocessingModel regarima;
    private final ISaResults decomposition;
    private final ISeriesDecomposition finals;
    private final boolean mul;
    private final TsData lin;
    private final TsData res;
    private final TsData sa;
    private final TsData irr;
    private final TsData si;
    private final TsData s;
    private final TsData t;
    private SeasonalityTests ytests;
    private SeasonalityTests rtests;
    private SeasonalityTests satests;
    private SeasonalityTests itests;
    private CombinedSeasonalityTest seasSI;
    private CombinedSeasonalityTest seasSa;
    private CombinedSeasonalityTest seasI;
    private CombinedSeasonalityTest seasRes;
    private CombinedSeasonalityTest seasSI3;
    private CombinedSeasonalityTest seasSa3;
    private CombinedSeasonalityTest seasI3;
    private CombinedSeasonalityTest seasRes3;
    private OneStepAheadForecastingTest outOfSampleTest;
    private MsrTable msr;
    private StationaryVarianceDecomposition varDecomposition;
    private static final double FLEN = 1.5;
    public static final String SEAS_LIN_QS = "seas-lin-qs";
    public static final String SEAS_LIN_F = "seas-lin-f";
    public static final String SEAS_LIN_FRIEDMAN = "seas-lin-friedman";
    public static final String SEAS_LIN_KW = "seas-lin-kw";
    public static final String SEAS_LIN_PERIODOGRAM = "seas-lin-periodogram";
    public static final String SEAS_LIN_SP = "seas-lin-spectralpeaks";
    public static final String SEAS_SI_COMBINED = "seas-si-combined";
    public static final String SEAS_SI_EVOLUTIVE = "seas-si-evolutive";
    public static final String SEAS_SI_STABLE = "seas-si-stable";
    public static final String SEAS_RES_QS = "seas-res-qs";
    public static final String SEAS_RES_F = "seas-res-f";
    public static final String SEAS_RES_FRIEDMAN = "seas-res-friedman";
    public static final String SEAS_RES_KW = "seas-res-kw";
    public static final String SEAS_RES_PERIODOGRAM = "seas-res-periodogram";
    public static final String SEAS_RES_COMBINED = "seas-res-combined";
    public static final String SEAS_RES_COMBINED3 = "seas-res-combined3";
    public static final String SEAS_RES_EVOLUTIVE = "seas-res-evolutive";
    public static final String SEAS_RES_STABLE = "seas-res-stable";
    public static final String SEAS_RES_SP = "seas-res-spectralpeaks";
    public static final String SEAS_SA_QS = "seas-sa-qs";
    public static final String SEAS_SA_F = "seas-sa-f";
    public static final String SEAS_SA_FRIEDMAN = "seas-sa-friedman";
    public static final String SEAS_SA_KW = "seas-sa-kw";
    public static final String SEAS_SA_PERIODOGRAM = "seas-sa-periodogram";
    public static final String SEAS_SA_COMBINED = "seas-sa-combined";
    public static final String SEAS_SA_COMBINED3 = "seas-sa-combined3";
    public static final String SEAS_SA_STABLE = "seas-sa-stable";
    public static final String SEAS_SA_EVOLUTIVE = "seas-sa-evolutive";
    public static final String SEAS_SA_SP = "seas-sa-spectralpeaks";
    public static final String SEAS_SA_AC1 = "seas-sa-ac1";
    public static final String SEAS_I_QS = "seas-i-qs";
    public static final String SEAS_I_F = "seas-i-f";
    public static final String SEAS_I_FRIEDMAN = "seas-i-friedman";
    public static final String SEAS_I_KW = "seas-i-kw";
    public static final String SEAS_I_PERIODOGRAM = "seas-i-periodogram";
    public static final String SEAS_I_COMBINED = "seas-i-combined";
    public static final String SEAS_I_COMBINED3 = "seas-i-combined3";
    public static final String SEAS_I_STABLE = "seas-i-stable";
    public static final String SEAS_I_EVOLUTIVE = "seas-i-evolutive";
    public static final String SEAS_I_SP = "seas-i-spectralpeaks";
    public static final String FCAST_INSAMPLE_MEAN = "fcast-insample-mean";
    public static final String FCAST_OUTSAMPLE_MEAN = "fcast-outsample-mean";
    public static final String FCAST_OUTSAMPLE_VARIANCE = "fcast-outsample-variance";
    public static final String LOG_STAT = "logstat";
    public static final String LEVEL_STAT = "levelstat";
    public static final String TD_RES_ALL = "td-res-all";
    public static final String TD_RES_LAST = "td-res-last";
    public static final String TD_I_ALL = "td-i-all";
    public static final String TD_I_LAST = "td-i-last";
    public static final String TD_SA_ALL = "td-sa-all";
    public static final String TD_SA_LAST = "td-sa-last";
    public static final String IC_RATIO = "ic-ratio";
    public static final String IC_RATIO_HENDERSON = "ic-ratio-henderson";
    public static final String MSR_GLOBAL = "msr-global";
    public static final String MSR = "msr";

    public static InformationMapping<SaDiagnostics> getMapping() {
        return MAPPING;
    }

    @Override
    public boolean contains(String id) {
        return MAPPING.contains(id);
    }

    @Override
    public Map<String, Class> getDictionary() {
        LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
        MAPPING.fillDictionary(null, dic, true);
        return dic;
    }

    @Override
    public <T> T getData(String id, Class<T> tclass) {
        return MAPPING.getData(this, id, tclass);
    }

    public static SaDiagnostics of(PreprocessingModel regarima, ISaResults decomposition, ISeriesDecomposition finals) {
        if (decomposition == null || finals == null) {
            return null;
        }
        return new SaDiagnostics(regarima, decomposition, finals);
    }

    private SaDiagnostics(PreprocessingModel regarima, ISaResults decomposition, ISeriesDecomposition finals) {
        this.regarima = regarima;
        this.decomposition = decomposition;
        this.finals = finals;
        this.sa = (TsData)decomposition.getData("sa_cmp", TsData.class);
        this.t = (TsData)decomposition.getData("t_cmp", TsData.class);
        this.s = (TsData)decomposition.getData("s_cmp", TsData.class);
        this.irr = (TsData)decomposition.getData("i_cmp", TsData.class);
        this.mul = decomposition.getSeriesDecomposition().getMode().isMultiplicative();
        if (regarima == null) {
            this.lin = (TsData)decomposition.getData("y_cmp", TsData.class);
            this.res = null;
        } else {
            this.lin = regarima.linearizedSeries();
            this.res = regarima.getFullResiduals();
        }
        this.si = decomposition instanceof X11Results ? (TsData)((X11Results)decomposition).getData(InformationSet.concatenate((String[])new String[]{"d-tables", "d8"}), TsData.class) : (this.mul ? TsData.multiply((TsData)this.s, (TsData)this.irr) : TsData.add((TsData)this.s, (TsData)this.irr));
    }

    private StationaryVarianceDecomposition varDecomposition() {
        if (this.varDecomposition == null) {
            try {
                TsData O = this.regarima == null ? (TsData)this.regarima.getData("yc", TsData.class) : (TsData)this.finals.getData("y", TsData.class);
                TsData Cal = this.regarima == null ? null : (TsData)this.regarima.getData("cal", TsData.class);
                TsData D = this.regarima == null ? null : (TsData)this.regarima.getData("det", TsData.class);
                TsData P = this.mul ? TsData.divide((TsData)D, (TsData)Cal) : TsData.subtract((TsData)D, (TsData)Cal);
                this.varDecomposition = new StationaryVarianceDecomposition();
                this.varDecomposition.process(O, this.t, this.s, this.irr, Cal, P, this.mul);
            }
            catch (Exception err) {
                return null;
            }
        }
        return this.varDecomposition;
    }

    private SeasonalityTests resTests() {
        if (this.res == null) {
            return null;
        }
        if (this.rtests == null) {
            this.rtests = SeasonalityTests.seasonalityTest((TsData)this.res, (int)0, (boolean)false, (boolean)true);
        }
        return this.rtests;
    }

    private SeasonalityTests yTests() {
        if (this.ytests == null) {
            this.ytests = SeasonalityTests.seasonalityTest((TsData)this.lin, (int)1, (boolean)true, (boolean)true);
        }
        return this.ytests;
    }

    private SeasonalityTests saTests() {
        if (this.satests == null) {
            this.satests = SeasonalityTests.seasonalityTest((TsData)(this.mul ? this.sa.log() : this.sa), (int)1, (boolean)true, (boolean)true);
        }
        return this.satests;
    }

    private SeasonalityTests irrTests() {
        if (this.itests == null) {
            this.itests = SeasonalityTests.seasonalityTest((TsData)(this.mul ? this.irr.log() : this.irr), (int)0, (boolean)true, (boolean)true);
        }
        return this.itests;
    }

    private CombinedSeasonalityTest csiTest(boolean last) {
        if (last) {
            if (this.seasSI3 == null) {
                int freq = this.si.getFrequency().intValue();
                TsPeriodSelector sel = new TsPeriodSelector();
                sel.last(freq * 3);
                this.seasSI3 = new CombinedSeasonalityTest(this.si.select(sel), this.mul);
            }
            return this.seasSI3;
        }
        if (this.seasSI == null) {
            this.seasSI = new CombinedSeasonalityTest(this.si, this.mul);
        }
        return this.seasSI;
    }

    private TsData dsa() {
        int freq = this.sa.getFrequency().intValue();
        return this.sa.delta(Math.max(1, freq / 4));
    }

    private CombinedSeasonalityTest csaTest(boolean last) {
        if (last) {
            if (this.seasSa3 == null) {
                int freq = this.sa.getFrequency().intValue();
                TsData s = this.sa.delta(Math.max(1, freq / 4));
                TsPeriodSelector sel = new TsPeriodSelector();
                sel.last(freq * 3);
                this.seasSa3 = new CombinedSeasonalityTest(s.select(sel), this.mul);
            }
            return this.seasSa3;
        }
        if (this.seasSa == null) {
            int freq = this.sa.getFrequency().intValue();
            TsData s = this.sa.delta(Math.max(1, freq / 4));
            this.seasSa = new CombinedSeasonalityTest(s, this.mul);
        }
        return this.seasSa;
    }

    private CombinedSeasonalityTest cresTest(boolean last) {
        if (this.res == null) {
            return null;
        }
        int freq = this.res.getFrequency().intValue();
        if (this.res.getLength() < 3 * freq) {
            return null;
        }
        if (last) {
            if (this.seasRes3 == null) {
                TsPeriodSelector sel = new TsPeriodSelector();
                sel.last(freq * 3);
                this.seasRes3 = new CombinedSeasonalityTest(this.res.select(sel), false);
            }
            return this.seasRes3;
        }
        if (this.seasRes == null) {
            this.seasRes = new CombinedSeasonalityTest(this.res, false);
        }
        return this.seasRes;
    }

    private CombinedSeasonalityTest ciTest(boolean last) {
        if (last) {
            if (this.seasI3 == null) {
                int freq = this.irr.getFrequency().intValue();
                TsPeriodSelector sel = new TsPeriodSelector();
                sel.last(freq * 3);
                this.seasI3 = new CombinedSeasonalityTest(this.irr.select(sel), this.mul);
            }
            return this.seasI3;
        }
        if (this.seasI == null) {
            this.seasI = new CombinedSeasonalityTest(this.irr, this.mul);
        }
        return this.seasI;
    }

    private OneStepAheadForecastingTest forecastingTest() {
        if (this.regarima == null) {
            return null;
        }
        if (this.outOfSampleTest == null) {
            try {
                OneStepAheadForecastingTest os;
                int ifreq = this.regarima.description.getFrequency();
                int nback = (int)(1.5 * (double)ifreq);
                if (nback < 5) {
                    nback = 5;
                }
                if (!(os = new OneStepAheadForecastingTest(nback)).test(this.regarima.estimation.getRegArima())) {
                    return null;
                }
                this.outOfSampleTest = os;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.outOfSampleTest;
    }

    private static ec.tstoolkit.stats.StatisticalTest tdAr(TsData s) {
        try {
            int i;
            RegModel reg = new RegModel();
            DataBlock y = new DataBlock((IReadDataBlock)s);
            reg.setY(y.drop(1, 0));
            GregorianCalendarVariables tdvars = GregorianCalendarVariables.getDefault((TradingDaysType)TradingDaysType.TradingDays);
            int ntd = tdvars.getDim();
            TsDomain edomain = s.getDomain().drop(1, 0);
            ArrayList<DataBlock> bvars = new ArrayList<DataBlock>(ntd);
            for (i = 0; i < ntd; ++i) {
                bvars.add(new DataBlock(edomain.getLength()));
            }
            tdvars.data(edomain, bvars);
            reg.addX(y.drop(0, 1));
            for (i = 0; i < ntd; ++i) {
                DataBlock cur = (DataBlock)bvars.get(i);
                reg.addX(cur);
            }
            Ols ols = new Ols();
            reg.setMeanCorrection(true);
            if (!ols.process(reg)) {
                return null;
            }
            JointRegressionTest test = new JointRegressionTest(0.01);
            test.accept(ols.getLikelihood(), 0, 2, ntd, null);
            return test.getTest();
        }
        catch (Exception err) {
            return null;
        }
    }

    private static ec.tstoolkit.stats.StatisticalTest td(TsData s) {
        try {
            int i;
            RegModel reg = new RegModel();
            DataBlock y = new DataBlock((IReadDataBlock)s);
            y.add(-y.average());
            reg.setY(y);
            GregorianCalendarVariables tdvars = GregorianCalendarVariables.getDefault((TradingDaysType)TradingDaysType.TradingDays);
            int ntd = tdvars.getDim();
            TsDomain edomain = s.getDomain();
            ArrayList<DataBlock> bvars = new ArrayList<DataBlock>(ntd);
            for (i = 0; i < ntd; ++i) {
                bvars.add(new DataBlock(edomain.getLength()));
            }
            tdvars.data(edomain, bvars);
            for (i = 0; i < ntd; ++i) {
                DataBlock cur = (DataBlock)bvars.get(i);
                reg.addX(cur);
            }
            Ols ols = new Ols();
            if (!ols.process(reg)) {
                return null;
            }
            JointRegressionTest test = new JointRegressionTest(0.01);
            test.accept(ols.getLikelihood(), 0, 0, ntd, null);
            return test.getTest();
        }
        catch (Exception err) {
            return null;
        }
    }

    private MsrTable msr() {
        if (this.msr == null && this.s != null) {
            if (this.decomposition instanceof X11Results) {
                TsData s2;
                TsData d9;
                DecompositionMode mode = this.decomposition.getSeriesDecomposition().getMode();
                SymmetricFilter f7 = FilterFactory.makeSymmetricFilter((int)7);
                DefaultSeasonalFilteringStrategy fseas = new DefaultSeasonalFilteringStrategy(f7, (IEndPointsProcessor)new FilteredMeanEndPoints(f7));
                TsData d1 = (TsData)this.decomposition.getData("d-tables.d1", TsData.class);
                TsData d7 = (TsData)this.decomposition.getData("d-tables.d7", TsData.class);
                switch (mode) {
                    case Multiplicative: 
                    case PseudoAdditive: {
                        d9 = TsData.divide((TsData)d1, (TsData)d7);
                        break;
                    }
                    case LogAdditive: {
                        d9 = TsData.divide((TsData)d1, (TsData)d7).log();
                        break;
                    }
                    default: {
                        d9 = TsData.subtract((TsData)d1, (TsData)d7);
                    }
                }
                TsData s1 = fseas.process(d9, null);
                switch (mode) {
                    case Multiplicative: {
                        s2 = TsData.divide((TsData)d9, (TsData)s1);
                        break;
                    }
                    case PseudoAdditive: {
                        s2 = d9.minus(s1).plus(1.0);
                        break;
                    }
                    default: {
                        s2 = TsData.subtract((TsData)d9, (TsData)s1);
                    }
                }
                return MsrTable.create((TsData)s1, (TsData)s2, (mode == DecompositionMode.Multiplicative || mode == DecompositionMode.PseudoAdditive ? 1 : 0) != 0);
            }
            this.msr = MsrTable.create((TsData)this.s, (TsData)this.irr, (boolean)this.mul);
        }
        return this.msr;
    }

    public List<ProcessingInformation> getProcessingInformation() {
        return Collections.EMPTY_LIST;
    }

    double[] allVariances() {
        StationaryVarianceDecomposition vd = this.varDecomposition();
        if (vd == null) {
            return null;
        }
        return new double[]{vd.getVarC(), vd.getVarS(), vd.getVarI(), vd.getVarTD(), vd.getVarP(), vd.getVarTotal()};
    }

    static {
        MAPPING.set("qs", StatisticalTest.class, source -> {
            ec.tstoolkit.stats.StatisticalTest qs = source.saTests().getQs();
            if (qs == null) {
                return null;
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)qs);
        });
        MAPPING.set("ftest", StatisticalTest.class, source -> {
            FTest ftest = new FTest();
            if (ftest.test(source.sa)) {
                return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)ftest.getFTest());
            }
            return null;
        });
        MAPPING.set("qs.on.i", StatisticalTest.class, source -> {
            ec.tstoolkit.stats.StatisticalTest qs = source.irrTests().getQs();
            if (qs == null) {
                return null;
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)qs);
        });
        MAPPING.set("ftest.on.i", StatisticalTest.class, source -> {
            FTest ftest = new FTest();
            if (ftest.test(source.irr)) {
                return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)ftest.getFTest());
            }
            return null;
        });
        MAPPING.delegate("combined.all", CombinedSeasonalityTestInfo.getMapping(), source -> source.csiTest(false));
        MAPPING.delegate("combined.end", CombinedSeasonalityTestInfo.getMapping(), source -> source.csiTest(true));
        MAPPING.delegate("combined.residual.all", CombinedSeasonalityTestInfo.getMapping(), source -> source.csaTest(false));
        MAPPING.delegate("combined.residual.end", CombinedSeasonalityTestInfo.getMapping(), source -> source.csaTest(true));
        MAPPING.set("residual.all", StatisticalTest.class, source -> StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)source.csaTest(false).getStableSeasonality()));
        MAPPING.set("residual.end", StatisticalTest.class, source -> StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)source.csaTest(true).getStableSeasonality()));
        MAPPING.set("residualtd", StatisticalTest.class, source -> {
            ec.tstoolkit.stats.StatisticalTest test;
            TsData s = source.sa;
            if (source.mul) {
                s = s.log();
            }
            if ((test = SaDiagnostics.tdAr(s)) == null) {
                return null;
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)test);
        });
        MAPPING.set("residualtd.on.i", StatisticalTest.class, source -> {
            ec.tstoolkit.stats.StatisticalTest test;
            TsData s = source.irr;
            if (source.mul) {
                s = s.log();
            }
            if ((test = SaDiagnostics.tdAr(s)) == null) {
                return null;
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)test);
        });
        MAPPING.set("variancedecomposition", double[].class, source -> source.allVariances());
        MAPPING.set(LOG_STAT, Double.class, source -> {
            if (source.regarima == null) {
                return null;
            }
            return (Double)source.regarima.getData(InformationSet.concatenate((String[])new String[]{"transformation", "log"}), Double.class);
        });
        MAPPING.set(LEVEL_STAT, Double.class, source -> {
            if (source.regarima == null) {
                return null;
            }
            return (Double)source.regarima.getData(InformationSet.concatenate((String[])new String[]{"transformation", "level"}), Double.class);
        });
        MAPPING.set(FCAST_INSAMPLE_MEAN, StatisticalTest.class, source -> {
            OneStepAheadForecastingTest ftest = source.forecastingTest();
            if (ftest == null) {
                return null;
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)ftest.inSampleMeanTest());
        });
        MAPPING.set(FCAST_OUTSAMPLE_MEAN, StatisticalTest.class, source -> {
            OneStepAheadForecastingTest ftest = source.forecastingTest();
            if (ftest == null) {
                return null;
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)ftest.outOfSampleMeanTest());
        });
        MAPPING.set(FCAST_OUTSAMPLE_VARIANCE, StatisticalTest.class, source -> {
            OneStepAheadForecastingTest ftest = source.forecastingTest();
            if (ftest == null) {
                return null;
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)ftest.mseTest());
        });
        MAPPING.set(SEAS_LIN_F, StatisticalTest.class, source -> {
            FTest ftest = new FTest();
            if (ftest.test(source.lin)) {
                return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)ftest.getFTest());
            }
            return null;
        });
        MAPPING.set(SEAS_LIN_QS, StatisticalTest.class, source -> {
            SeasonalityTests ytests = source.yTests();
            if (ytests == null) {
                return null;
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)ytests.getQs());
        });
        MAPPING.set(SEAS_LIN_KW, StatisticalTest.class, source -> {
            KruskalWallisTest kw = new KruskalWallisTest(source.lin);
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)kw);
        });
        MAPPING.set(SEAS_LIN_FRIEDMAN, StatisticalTest.class, source -> {
            SeasonalityTests ytests = source.yTests();
            if (ytests == null) {
                return null;
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)ytests.getNonParametricTest());
        });
        MAPPING.set(SEAS_LIN_PERIODOGRAM, StatisticalTest.class, source -> {
            SeasonalityTests ytests = source.yTests();
            if (ytests == null) {
                return null;
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)ytests.getPeriodogramTest());
        });
        MAPPING.set(SEAS_LIN_SP, String.class, source -> {
            SeasonalityTests ytests = source.yTests();
            if (ytests == null) {
                return null;
            }
            SpectralPeaks[] spectralPeaks = ytests.getSpectralPeaks();
            if (spectralPeaks == null) {
                return null;
            }
            return SpectralPeaks.format((SpectralPeaks[])spectralPeaks);
        });
        MAPPING.set(SEAS_SI_COMBINED, String.class, source -> {
            CombinedSeasonalityTest sitest = source.csiTest(false);
            if (sitest == null) {
                return null;
            }
            return sitest.getSummary().name();
        });
        MAPPING.set(SEAS_SI_EVOLUTIVE, StatisticalTest.class, source -> {
            CombinedSeasonalityTest sitest = source.csiTest(false);
            if (sitest == null) {
                return null;
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)sitest.getEvolutiveSeasonality());
        });
        MAPPING.set(SEAS_SI_STABLE, StatisticalTest.class, source -> {
            CombinedSeasonalityTest sitest = source.csiTest(false);
            if (sitest == null) {
                return null;
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)sitest.getStableSeasonality());
        });
        MAPPING.set(SEAS_RES_F, StatisticalTest.class, source -> {
            if (source.res == null) {
                return null;
            }
            FTest ftest = new FTest();
            if (ftest.test(source.res)) {
                return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)ftest.getFTest());
            }
            return null;
        });
        MAPPING.set(SEAS_RES_QS, StatisticalTest.class, source -> {
            SeasonalityTests rtests = source.resTests();
            if (rtests == null) {
                return null;
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)rtests.getQs());
        });
        MAPPING.set(SEAS_RES_KW, StatisticalTest.class, source -> {
            if (source.res == null) {
                return null;
            }
            KruskalWallisTest kw = new KruskalWallisTest(source.res);
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)kw);
        });
        MAPPING.set(SEAS_RES_FRIEDMAN, StatisticalTest.class, source -> {
            SeasonalityTests rtests = source.resTests();
            if (rtests == null) {
                return null;
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)rtests.getNonParametricTest());
        });
        MAPPING.set(SEAS_RES_PERIODOGRAM, StatisticalTest.class, source -> {
            SeasonalityTests rtests = source.resTests();
            if (rtests == null) {
                return null;
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)rtests.getPeriodogramTest());
        });
        MAPPING.set(SEAS_RES_SP, String.class, source -> {
            SeasonalityTests rtests = source.resTests();
            if (rtests == null) {
                return null;
            }
            return SpectralPeaks.format((SpectralPeaks[])rtests.getSpectralPeaks());
        });
        MAPPING.set(SEAS_RES_COMBINED, String.class, source -> {
            CombinedSeasonalityTest rtest = source.cresTest(false);
            if (rtest == null) {
                return null;
            }
            return rtest.getSummary().name();
        });
        MAPPING.set(SEAS_RES_COMBINED3, String.class, source -> {
            CombinedSeasonalityTest rtest = source.cresTest(true);
            if (rtest == null) {
                return null;
            }
            return rtest.getSummary().name();
        });
        MAPPING.set(SEAS_RES_EVOLUTIVE, StatisticalTest.class, source -> {
            CombinedSeasonalityTest rtest = source.cresTest(false);
            if (rtest == null) {
                return null;
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)rtest.getEvolutiveSeasonality());
        });
        MAPPING.set(SEAS_RES_STABLE, StatisticalTest.class, source -> {
            CombinedSeasonalityTest rtest = source.cresTest(false);
            if (rtest == null) {
                return null;
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)rtest.getStableSeasonality());
        });
        MAPPING.set(SEAS_I_F, StatisticalTest.class, source -> {
            FTest ftest = new FTest();
            if (ftest.test(source.irr)) {
                return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)ftest.getFTest());
            }
            return null;
        });
        MAPPING.set(SEAS_I_QS, StatisticalTest.class, source -> {
            SeasonalityTests itests = source.irrTests();
            if (itests == null) {
                return null;
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)itests.getQs());
        });
        MAPPING.set(SEAS_I_KW, StatisticalTest.class, source -> {
            KruskalWallisTest kw = new KruskalWallisTest(source.irr);
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)kw);
        });
        MAPPING.set(SEAS_I_PERIODOGRAM, StatisticalTest.class, source -> {
            SeasonalityTests itests = source.irrTests();
            if (itests == null) {
                return null;
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)itests.getPeriodogramTest());
        });
        MAPPING.set(SEAS_I_SP, String.class, source -> {
            SeasonalityTests itests = source.irrTests();
            if (itests == null) {
                return null;
            }
            return SpectralPeaks.format((SpectralPeaks[])itests.getSpectralPeaks());
        });
        MAPPING.set(SEAS_I_COMBINED, String.class, source -> {
            CombinedSeasonalityTest itest = source.ciTest(false);
            if (itest == null) {
                return null;
            }
            return itest.getSummary().name();
        });
        MAPPING.set(SEAS_I_COMBINED3, String.class, source -> {
            CombinedSeasonalityTest itest = source.ciTest(true);
            if (itest == null) {
                return null;
            }
            return itest.getSummary().name();
        });
        MAPPING.set(SEAS_I_EVOLUTIVE, StatisticalTest.class, source -> {
            CombinedSeasonalityTest itest = source.ciTest(false);
            if (itest == null) {
                return null;
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)itest.getEvolutiveSeasonality());
        });
        MAPPING.set(SEAS_I_STABLE, StatisticalTest.class, source -> {
            CombinedSeasonalityTest itest = source.ciTest(false);
            if (itest == null) {
                return null;
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)itest.getStableSeasonality());
        });
        MAPPING.set(SEAS_SA_F, StatisticalTest.class, source -> {
            FTest ftest = new FTest();
            if (ftest.test(source.sa)) {
                return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)ftest.getFTest());
            }
            return null;
        });
        MAPPING.set(SEAS_SA_QS, StatisticalTest.class, source -> {
            SeasonalityTests satests = source.saTests();
            if (satests == null) {
                return null;
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)satests.getQs());
        });
        MAPPING.set(SEAS_SA_KW, StatisticalTest.class, source -> {
            KruskalWallisTest kw = new KruskalWallisTest(source.sa);
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)kw);
        });
        MAPPING.set(SEAS_SA_FRIEDMAN, StatisticalTest.class, source -> {
            SeasonalityTests satests = source.saTests();
            if (satests == null) {
                return null;
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)satests.getNonParametricTest());
        });
        MAPPING.set(SEAS_SA_PERIODOGRAM, StatisticalTest.class, source -> {
            SeasonalityTests satests = source.saTests();
            if (satests == null) {
                return null;
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)satests.getPeriodogramTest());
        });
        MAPPING.set(SEAS_SA_SP, String.class, source -> {
            SeasonalityTests satests = source.saTests();
            if (satests == null) {
                return null;
            }
            return SpectralPeaks.format((SpectralPeaks[])satests.getSpectralPeaks());
        });
        MAPPING.set(SEAS_SA_COMBINED, String.class, source -> {
            CombinedSeasonalityTest satest = source.csaTest(false);
            if (satest == null) {
                return null;
            }
            return satest.getSummary().name();
        });
        MAPPING.set(SEAS_SA_COMBINED3, String.class, source -> {
            CombinedSeasonalityTest satest = source.csaTest(true);
            if (satest == null) {
                return null;
            }
            return satest.getSummary().name();
        });
        MAPPING.set(SEAS_SA_EVOLUTIVE, StatisticalTest.class, source -> {
            CombinedSeasonalityTest satest = source.csaTest(false);
            if (satest == null) {
                return null;
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)satest.getEvolutiveSeasonality());
        });
        MAPPING.set(SEAS_SA_STABLE, StatisticalTest.class, source -> {
            CombinedSeasonalityTest satest = source.csaTest(false);
            if (satest == null) {
                return null;
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)satest.getStableSeasonality());
        });
        MAPPING.set(SEAS_SA_AC1, Double.class, source -> {
            TsData dsa = source.sa.delta(1);
            AutoCorrelations ac = new AutoCorrelations((IReadDataBlock)dsa);
            return ac.autoCorrelation(1);
        });
        MAPPING.set(TD_SA_ALL, StatisticalTest.class, source -> {
            TsData s = source.sa;
            if (source.mul) {
                s = s.log();
            }
            ec.tstoolkit.stats.StatisticalTest test = SaDiagnostics.tdAr(s);
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)test);
        });
        MAPPING.set(TD_SA_LAST, StatisticalTest.class, source -> {
            TsData s = source.sa;
            if (source.mul) {
                s = s.log();
            }
            int ifreq = s.getFrequency().intValue();
            s = s.drop(Math.max(0, s.getLength() - ifreq * 8 - 1), 0);
            ec.tstoolkit.stats.StatisticalTest test = SaDiagnostics.tdAr(s);
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)test);
        });
        MAPPING.set(TD_I_ALL, StatisticalTest.class, source -> {
            TsData s = source.irr;
            if (source.mul) {
                s = s.log();
            }
            ec.tstoolkit.stats.StatisticalTest test = SaDiagnostics.tdAr(s);
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)test);
        });
        MAPPING.set(TD_I_LAST, StatisticalTest.class, source -> {
            TsData s = source.irr;
            if (source.mul) {
                s = s.log();
            }
            int ifreq = s.getFrequency().intValue();
            s = s.drop(Math.max(0, s.getLength() - ifreq * 8 - 1), 0);
            ec.tstoolkit.stats.StatisticalTest test = SaDiagnostics.tdAr(s);
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)test);
        });
        MAPPING.set(TD_RES_ALL, StatisticalTest.class, source -> {
            TsData s = source.res;
            if (s == null) {
                return null;
            }
            ec.tstoolkit.stats.StatisticalTest test = SaDiagnostics.td(s);
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)test);
        });
        MAPPING.set(TD_RES_LAST, StatisticalTest.class, source -> {
            TsData s = source.res;
            if (s == null) {
                return null;
            }
            int ifreq = s.getFrequency().intValue();
            s = s.drop(Math.max(0, s.getLength() - ifreq * 8 - 1), 0);
            ec.tstoolkit.stats.StatisticalTest test = SaDiagnostics.td(s);
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)test);
        });
        MAPPING.set(IC_RATIO_HENDERSON, Double.class, source -> {
            TsData sa = source.sa;
            int freq = sa.getFrequency().intValue();
            int filterLength = freq + 1;
            SymmetricFilter trendFilter = TrendCycleFilterFactory.makeHendersonFilter((int)filterLength);
            DefaultTrendFilteringStrategy strategy = new DefaultTrendFilteringStrategy(trendFilter, null, filterLength + " terms Henderson moving average");
            TsData sc = strategy.process(sa, sa.getDomain());
            TsData si = source.mul ? TsData.divide((TsData)sa, (TsData)sc) : TsData.subtract((TsData)sa, (TsData)sc);
            double gc = SeriesEvolution.calcAbsMeanVariations((TsData)sc, null, (int)1, (boolean)source.mul, null);
            double gi = SeriesEvolution.calcAbsMeanVariations((TsData)si, null, (int)1, (boolean)source.mul, null);
            return (double)(12 / freq) * gi / gc;
        });
        MAPPING.set(IC_RATIO, Double.class, source -> {
            TsData sa = source.sa;
            int freq = sa.getFrequency().intValue();
            TsData sc = source.t;
            TsData si = source.mul ? TsData.divide((TsData)sa, (TsData)sc) : TsData.subtract((TsData)sa, (TsData)sc);
            double gc = SeriesEvolution.calcAbsMeanVariations((TsData)sc, null, (int)1, (boolean)source.mul, null);
            double gi = SeriesEvolution.calcAbsMeanVariations((TsData)si, null, (int)1, (boolean)source.mul, null);
            return (double)(12 / freq) * gi / gc;
        });
        MAPPING.set(MSR_GLOBAL, Double.class, source -> {
            MsrTable msr = source.msr();
            if (msr == null) {
                return null;
            }
            return msr.getGlobalMsr();
        });
        MAPPING.setArray(MSR, 1, 12, Double.class, (source, i) -> {
            MsrTable msr = source.msr();
            if (msr == null) {
                return null;
            }
            return i <= 0 || i > msr.getCount() ? null : Double.valueOf(msr.getRMS(i - 1));
        });
    }
}

