/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.simplets;

import ec.tstoolkit.OperationType;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.timeseries.simplets.ITsDataTransformation;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;

public class DataTransformation
implements ITsDataTransformation {
    public final OperationType op;
    private TsData m_tsdata;

    public DataTransformation(TsData tsdata, OperationType mode) {
        this.m_tsdata = tsdata.clone();
        this.op = mode;
    }

    @Override
    public ITsDataTransformation converse() {
        OperationType mode = OperationType.None;
        switch (this.op) {
            case Diff: {
                mode = OperationType.Sum;
                break;
            }
            case Sum: {
                mode = OperationType.Diff;
                break;
            }
            case Ratio: {
                mode = OperationType.Product;
                break;
            }
            case Product: {
                mode = OperationType.Ratio;
            }
        }
        return new DataTransformation(this.m_tsdata, mode);
    }

    public TsData getTSData() {
        return this.m_tsdata;
    }

    @Override
    public boolean transform(TsData data, ITsDataTransformation.LogJacobian ljacobian) {
        TsDomain domain = this.m_tsdata.getDomain();
        TsDomain common = data.getDomain().intersection(domain);
        int istart = common.getStart().minus(data.getStart());
        int jstart = common.getStart().minus(domain.getStart());
        int iend = istart + common.getLength();
        int jend = jstart + common.getLength();
        DataBlock s = new DataBlock(this.m_tsdata.internalStorage(), istart, iend, 1);
        IReadDataBlock extract = this.m_tsdata.rextract(jstart, common.getLength());
        switch (this.op) {
            case Diff: {
                s.apply(extract, (x, y) -> x - y);
                break;
            }
            case Product: {
                s.apply(extract, (x, y) -> x * y);
                break;
            }
            case Sum: {
                s.apply(extract, (x, y) -> x + y);
                break;
            }
            case Ratio: {
                s.apply(extract, (x, y) -> x / y);
                break;
            }
            default: {
                return false;
            }
        }
        if (ljacobian != null && (this.op == OperationType.Product || this.op == OperationType.Ratio)) {
            if (ljacobian.start > istart) {
                jstart += ljacobian.start - istart;
                istart = ljacobian.start;
            }
            if (ljacobian.end < iend) {
                jend -= iend - ljacobian.end;
            }
            double l = 0.0;
            for (int j = jstart; j < jend; ++j) {
                l += Math.log(s.get(j));
            }
            ljacobian.value = this.op == OperationType.Product ? (ljacobian.value += l) : (ljacobian.value -= l);
        }
        return true;
    }
}

