/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.simplets;

import ec.tstoolkit.arima.ArimaModelBuilder;
import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.data.Values;
import ec.tstoolkit.random.IRandomNumberGenerator;
import ec.tstoolkit.random.JdkRNG;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaModelBuilder;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsObservation;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class TsData
implements Cloneable,
Iterable<TsObservation>,
IReadDataBlock {
    private static final IRandomNumberGenerator RNG = JdkRNG.newRandom();
    private TsPeriod start;
    private double[] vals;

    public static TsData add(double d, TsData ts) {
        return ts.plus(d);
    }

    public static TsData add(TsData tsl, TsData tsr) {
        if (tsr == null) {
            return tsl;
        }
        if (tsl == null) {
            return tsr;
        }
        return TsData.computeOnIntersection(tsl, tsr, (a, b) -> a + b);
    }

    public static TsData divide(double d, TsData ts) {
        TsData s = ts.clone();
        if (d != 0.0) {
            s.apply(a -> d / a);
        } else {
            s.set(() -> 0.0);
        }
        return s;
    }

    public static TsData divide(TsData tsl, TsData tsr) {
        if (tsr == null) {
            return tsl;
        }
        if (tsl == null) {
            return tsr.inv();
        }
        return TsData.computeOnIntersection(tsl, tsr, (a, b) -> a / b);
    }

    public static TsData multiply(double d, TsData ts) {
        return ts.times(d);
    }

    public static TsData multiply(TsData tsl, TsData tsr) {
        if (tsr == null) {
            return tsl;
        }
        if (tsl == null) {
            return tsr;
        }
        return TsData.computeOnIntersection(tsl, tsr, (a, b) -> a * b);
    }

    public static TsData subtract(double d, TsData ts) {
        return ts.plus(-d);
    }

    public static TsData subtract(TsData tsl, TsData tsr) {
        if (tsr == null) {
            return tsl;
        }
        if (tsl == null) {
            return tsr.chs();
        }
        return TsData.computeOnIntersection(tsl, tsr, (a, b) -> a - b);
    }

    public static TsData random(TsFrequency freq) {
        int beg = RNG.nextInt(240);
        int count = RNG.nextInt(600);
        TsData ts = new TsData(freq, beg, count);
        double cur = RNG.nextDouble() + 100.0;
        for (int i = 0; i < ts.getLength(); ++i) {
            cur = cur + RNG.nextDouble() - 0.5;
            ts.set(i, cur);
        }
        return ts;
    }

    public static TsData random(TsFrequency freq, int seed) {
        Random rnd = new Random(seed);
        int beg = rnd.nextInt(240);
        int count = rnd.nextInt(600);
        TsData ts = new TsData(freq, beg, count);
        double cur = rnd.nextDouble() + 100.0;
        for (int i = 0; i < ts.getLength(); ++i) {
            cur = cur + rnd.nextDouble() - 0.5;
            ts.set(i, cur);
        }
        return ts;
    }

    public void randomAirline() {
        SarimaModelBuilder sb = new SarimaModelBuilder();
        SarimaModel airline = sb.createAirlineModel(this.getFrequency().intValue(), -0.6, -0.8);
        airline = sb.randomize(airline, 0.2);
        this.vals = new ArimaModelBuilder().generate(airline, this.vals.length);
    }

    public double distance(TsData s) {
        TsData del = this.minus(s);
        int n = del.getObsCount();
        double ssq = del.ssq();
        return Math.sqrt(ssq / (double)n);
    }

    public TsData(TsDomain dom) {
        this.start = dom.getStart();
        this.vals = new double[dom.getLength()];
        Arrays.fill(this.vals, Double.NaN);
    }

    public TsData(TsDomain dom, double val) {
        this.start = dom.getStart();
        this.vals = new double[dom.getLength()];
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = val;
        }
    }

    TsData(TsFrequency freq, int beg, int count) {
        this.start = new TsPeriod(freq, beg);
        this.vals = new double[count];
    }

    public TsData(TsFrequency freq, int firstyear, int firstperiod, double[] data, boolean copydata) {
        this.start = new TsPeriod(freq, firstyear, firstperiod);
        this.vals = copydata ? (double[])data.clone() : data;
    }

    public TsData(TsFrequency freq, int firstyear, int firstperiod, int count) {
        this.start = new TsPeriod(freq, firstyear, firstperiod);
        this.vals = new double[count];
    }

    public TsData(TsPeriod start, double[] data, boolean copydata) {
        this.start = start.clone();
        this.vals = copydata ? (double[])data.clone() : data;
    }

    public TsData(TsPeriod start, int count) {
        this.start = start.clone();
        this.vals = new double[count];
    }

    public TsData(TsPeriod start, IReadDataBlock vals) {
        this.start = start;
        this.vals = new double[vals.getLength()];
        vals.copyTo(this.vals, 0);
    }

    @Override
    public void copyTo(double[] buffer, int start) {
        System.arraycopy(this.vals, 0, buffer, start, this.vals.length);
    }

    @Override
    public IReadDataBlock rextract(int start, int length) {
        return new ReadDataBlock(this.vals, start, length);
    }

    public TsData abs() {
        return this.transformFinite(x -> Math.abs(x));
    }

    public TsData changeFrequency(TsFrequency newfreq, TsAggregationType conversion, boolean complete) {
        int nfreq;
        int freq = this.start.getFrequency().intValue();
        if (freq % (nfreq = newfreq.intValue()) != 0) {
            return null;
        }
        if (freq == nfreq) {
            return this.clone();
        }
        int nconv = freq / nfreq;
        int c = this.getLength();
        int z0 = 0;
        int beg = this.start.id();
        int nbeg = beg / nconv;
        int n0 = nconv;
        int n1 = nconv;
        if (beg % nconv != 0) {
            if (complete) {
                if (beg > 0) {
                    ++nbeg;
                    z0 = nconv - beg % nconv;
                } else {
                    z0 = -beg % nconv;
                }
            } else {
                if (beg < 0) {
                    --nbeg;
                }
                n0 = (nbeg + 1) * nconv - beg;
            }
        }
        int end = beg + c;
        int nend = end / nconv;
        if (end % nconv != 0) {
            if (complete) {
                if (end < 0) {
                    --nend;
                }
            } else {
                if (end > 0) {
                    ++nend;
                }
                n1 = end - (nend - 1) * nconv;
            }
        }
        int n = nend - nbeg;
        TsData tmp = new TsData(newfreq, nbeg, n);
        if (n > 0) {
            int j = z0;
            for (int i = 0; i < n; ++i) {
                int nmax = nconv;
                if (i == 0) {
                    nmax = n0;
                } else if (i == n - 1) {
                    nmax = n1;
                }
                double d = 0.0;
                int ncur = 0;
                int k = 0;
                while (k < nmax) {
                    double dcur = this.vals[j];
                    if (Double.isFinite(dcur)) {
                        switch (conversion) {
                            case Last: {
                                d = dcur;
                                break;
                            }
                            case First: {
                                if (ncur != 0) break;
                                d = dcur;
                                break;
                            }
                            case Min: {
                                if (ncur != 0 && !(dcur < d)) break;
                                d = dcur;
                                break;
                            }
                            case Max: {
                                if (ncur != 0 && !(dcur > d)) break;
                                d = dcur;
                                break;
                            }
                            default: {
                                d += dcur;
                            }
                        }
                        ++ncur;
                    }
                    ++k;
                    ++j;
                }
                if (ncur != nconv && (complete || ncur == 0)) continue;
                if (conversion == TsAggregationType.Average) {
                    d /= (double)ncur;
                }
                tmp.vals[i] = d;
            }
        }
        return tmp;
    }

    public TsData chs() {
        return this.transformFinite(x -> -x);
    }

    public TsData cleanExtremities() {
        int nf;
        int n = this.vals.length;
        int nm = this.getMissingValuesCount();
        if (n == nm) {
            return this.drop(0, n);
        }
        int nl = 0;
        for (nf = 0; nf < n && !Double.isFinite(this.vals[nf]); ++nf) {
        }
        while (nl < n && !Double.isFinite(this.vals[n - nl - 1])) {
            ++nl;
        }
        return this.drop(nf, nl);
    }

    public TsData clone() {
        try {
            TsData data = (TsData)super.clone();
            data.start = this.start.clone();
            data.vals = (double[])this.vals.clone();
            return data;
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    public TsData delta(int lag) {
        return this.autoTransform(lag, (x1, x0) -> x1 - x0);
    }

    public TsData delta(int lag, int power) {
        if (power == 0) {
            return this.clone();
        }
        if (power < 0 || lag < 1) {
            return null;
        }
        if (power == 1) {
            return this.delta(lag);
        }
        TsData tmp = this;
        for (int i = 0; i < power; ++i) {
            tmp = tmp.delta(lag);
        }
        return tmp;
    }

    public TsData div(double d) {
        if (d == 1.0) {
            return this.clone();
        }
        if (d == -1.0) {
            return this.chs();
        }
        if (d == 0.0) {
            return new TsData(new TsDomain(this.start, this.vals.length), Double.NaN);
        }
        return this.transformFinite(x -> x / d);
    }

    public TsData div(TsData ts) {
        return TsData.divide(this, ts);
    }

    public TsData drop(int nfirst, int nlast) {
        int s0;
        int t0;
        TsPeriod s = this.getStart();
        s.move(nfirst);
        int n = this.vals.length - nfirst - nlast;
        if (n < 0) {
            n = 0;
        }
        TsData nts = new TsData(s, n);
        if (n == 0) {
            return nts;
        }
        int nc = n;
        if (nfirst < 0) {
            nc += nfirst;
            t0 = -nfirst;
            s0 = 0;
            Arrays.fill(nts.vals, 0, -nfirst, Double.NaN);
        } else {
            s0 = nfirst;
            t0 = 0;
        }
        if (nlast < 0) {
            nc += nlast;
            Arrays.fill(nts.vals, nts.vals.length + nlast, nts.vals.length, Double.NaN);
        }
        if (nc > 0) {
            System.arraycopy(this.vals, s0, nts.vals, t0, nc);
        }
        return nts;
    }

    public TsData fullYears() {
        int pos = this.start.getPosition();
        int beg = pos > 0 ? this.start.getFrequency().intValue() - pos : 0;
        return this.drop(beg, this.getEnd().getPosition());
    }

    public TsData exp() {
        return this.transformFinite(x -> Math.exp(x));
    }

    public TsData round(int ndec) {
        return this.transformFinite(x -> IReadDataBlock.round(x, ndec));
    }

    public TsData extend(int nbefore, int nafter) {
        return this.drop(-nbefore, -nafter);
    }

    public TsData extendTo(Day lastday) {
        TsPeriod s = new TsPeriod(this.start.getFrequency(), lastday);
        if (!lastday.equals((Object)s.lastday())) {
            s.move(-1);
        }
        int n = s.minus(this.start) + 1;
        return this.extend(0, n - this.vals.length);
    }

    public TsData fittoDomain(TsDomain dom) {
        TsFrequency freq = this.start.getFrequency();
        if (dom.getFrequency() != freq) {
            return null;
        }
        int firstid = dom.firstid();
        int n = dom.getLength();
        int beg = this.start.id();
        int count = this.vals.length;
        return this.extend(beg - firstid, firstid + n - beg - count);
    }

    @Override
    public boolean isMissing(int idx) {
        return !Double.isFinite(this.vals[idx]);
    }

    public void setMissing(int idx) {
        this.vals[idx] = Double.NaN;
    }

    @Override
    public double get(int idx) {
        return this.vals[idx];
    }

    public TsDomain getDomain() {
        return new TsDomain(this.start, this.vals.length);
    }

    @Deprecated
    public Values getValues() {
        return new Values(this.vals, false);
    }

    public TsPeriod getEnd() {
        return this.start.plus(this.vals.length);
    }

    public TsFrequency getFrequency() {
        return this.start.getFrequency();
    }

    public TsPeriod getLastPeriod() {
        return this.start.plus(this.vals.length - 1);
    }

    @Override
    public int getLength() {
        return this.vals.length;
    }

    public int getObsCount() {
        return this.count(x -> Double.isFinite(x));
    }

    public int getMissingValuesCount() {
        return this.count(x -> !Double.isFinite(x));
    }

    public boolean hasMissingValues() {
        return !this.check(x -> Double.isFinite(x));
    }

    public TsPeriod getStart() {
        return this.start.clone();
    }

    public TsData index(TsPeriod refperiod, double refvalue) {
        int n;
        Day d0 = refperiod.firstday();
        Day d1 = refperiod.lastday();
        TsDomain dom = this.getDomain();
        int i0 = dom.search(d0);
        int i1 = dom.search(d1);
        if (i0 < 0) {
            i0 = -1 - i0;
        }
        if (i1 < 0) {
            i1 = -i1;
        }
        if (i1 >= (n = dom.getLength())) {
            i1 = n - 1;
        }
        if (i0 > i1) {
            return null;
        }
        double s = 0.0;
        n = 0;
        for (int i = i0; i <= i1; ++i) {
            double d = this.vals[i];
            if (!Double.isFinite(d)) continue;
            s += d;
            ++n;
        }
        if (s == 0.0) {
            return null;
        }
        return this.times(refvalue * (double)n / s);
    }

    public TsData inv() {
        return this.transformFinite(x -> x == 0.0 ? Double.NaN : 1.0 / x);
    }

    public boolean isEmpty() {
        return this.vals.length == 0;
    }

    @Override
    public Iterator<TsObservation> iterator() {
        return new TsIterator(this);
    }

    public Stream<TsObservation> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public TsData lag(int nperiods) {
        TsPeriod s = this.getStart();
        s.move(-nperiods);
        return new TsData(s, this.vals, true);
    }

    public TsData lead(int nperiods) {
        TsPeriod s = this.getStart();
        s.move(nperiods);
        return new TsData(s, this.vals, true);
    }

    public TsData log() {
        return this.transformFinite(x -> Math.log(x));
    }

    public TsData log(double b) {
        double c = Math.log(b);
        return this.transformFinite(x -> Math.log(x) / c);
    }

    public TsData sqrt() {
        return this.transformFinite(x -> Math.sqrt(x));
    }

    public TsData minus(double d) {
        if (d == 0.0) {
            return this.clone();
        }
        return this.transformFinite(x -> x - d);
    }

    public TsData minus(TsData ts) {
        return TsData.subtract(this, ts);
    }

    public TsData movingAverage(double[] weights, boolean bcentred, boolean bnormalized) {
        double[] w = (double[])weights.clone();
        int nw = w.length;
        if (nw < 2 || bcentred && nw % 2 == 0) {
            return null;
        }
        if (bnormalized) {
            int i;
            double s = 0.0;
            for (i = 0; i < nw; ++i) {
                s += w[i];
            }
            if (s == 0.0) {
                return null;
            }
            i = 0;
            while (i < nw) {
                int n = i++;
                w[n] = w[n] / s;
            }
        }
        TsDomain dout = null;
        TsDomain dom = this.getDomain();
        if (bcentred) {
            int nw2 = (nw - 1) / 2;
            dout = dom.drop(nw - 1 - nw2, nw2);
        } else {
            dout = dom.drop(nw - 1, 0);
        }
        TsData rslt = new TsData(dout);
        int n = dout.getLength();
        if (n == 0) {
            return rslt;
        }
        for (int i = 0; i < n; ++i) {
            int j;
            double wval = 0.0;
            for (j = 0; j < nw; ++j) {
                double tmp = this.vals[i + j];
                if (!Double.isFinite(tmp)) continue;
                wval += w[j] * tmp;
            }
            if (j != nw) continue;
            rslt.vals[i] = wval;
        }
        return rslt;
    }

    public TsData movingMedian(int nperiods, boolean bcentred) {
        if (nperiods < 2 || bcentred && nperiods % 2 == 0) {
            return null;
        }
        int np2 = (nperiods - 1) / 2;
        TsDomain dout = null;
        TsDomain dom = this.getDomain();
        dout = bcentred ? dom.drop(nperiods - 1 - np2, np2) : dom.drop(nperiods - 1, 0);
        TsData rslt = new TsData(dout);
        int n = dout.getLength();
        if (n == 0) {
            return rslt;
        }
        double[] tmp = new double[nperiods];
        boolean bPair = nperiods % 2 == 0;
        for (int i = 0; i < n; ++i) {
            boolean bmissing = false;
            for (int j = 0; j < nperiods; ++j) {
                double x = this.vals[i + j];
                if (!Double.isFinite(x)) {
                    bmissing = true;
                    break;
                }
                tmp[j] = x;
            }
            if (bmissing) continue;
            Arrays.sort(tmp);
            rslt.vals[i] = bPair ? (tmp[np2] + tmp[np2 + 1]) / 2.0 : tmp[np2];
        }
        return rslt;
    }

    public TsData pctVariation(int lag) {
        return this.autoTransform(lag, (x1, x0) -> (x1 / x0 - 1.0) * 100.0);
    }

    public TsData plus(double d) {
        return this.transformFinite(x -> x + d);
    }

    public TsData plus(TsData ts) {
        return TsData.add(this, ts);
    }

    public TsData pow(double e) {
        if (e == 1.0) {
            return this.clone();
        }
        if (e == 2.0) {
            return this.transformFinite(x -> x * x);
        }
        return this.transformFinite(x -> Math.pow(x, e));
    }

    public TsData select(TsPeriodSelector ps) {
        if (ps == null) {
            return this.clone();
        }
        TsDomain domain = this.getDomain().select(ps);
        TsData rslt = new TsData(domain);
        int diff = domain.firstid() - this.start.id();
        System.arraycopy(this.vals, diff, rslt.vals, 0, domain.getLength());
        return rslt;
    }

    public void set(int idx, double value) {
        this.vals[idx] = value;
    }

    public TsData times(double d) {
        if (d == 0.0) {
            return new TsData(this.start, this.vals.length);
        }
        TsData s = this.clone();
        if (d == 1.0) {
            return s;
        }
        s.applyOnFinite(x -> x * d);
        return s;
    }

    public TsData times(TsData ts) {
        return TsData.multiply(this, ts);
    }

    public TsData update(TsData ts) {
        TsDomain rdom;
        if (ts == null) {
            return this.clone();
        }
        TsDomain dom = this.getDomain();
        TsDomain uDomain = dom.union(rdom = ts.getDomain());
        if (uDomain == null) {
            return null;
        }
        int rn = rdom.getLength();
        int r0 = rdom.firstid();
        int u0 = uDomain.firstid();
        TsData rslt = this.fittoDomain(uDomain);
        int d0 = r0 - u0;
        System.arraycopy(ts.vals, 0, rslt.vals, d0, rn);
        return rslt;
    }

    public static TsData concatenate(TsData l, TsData r) {
        if (l == null) {
            return r;
        }
        if (r == null) {
            return l;
        }
        return l.update(r);
    }

    public void removeMean() {
        DescriptiveStatistics stats = new DescriptiveStatistics(this.vals);
        double m = stats.getAverage();
        this.applyOnFinite(x -> x - m);
    }

    public void normalize() {
        DescriptiveStatistics stats = new DescriptiveStatistics(this.vals);
        double m = stats.getAverage();
        double e = stats.getStdev();
        this.applyOnFinite(x -> (x - m) / e);
    }

    public double get(TsPeriod period) {
        int pos = period.minus(this.start);
        return pos < 0 || pos >= this.vals.length ? Double.NaN : this.vals[pos];
    }

    public void set(TsPeriod period, double value) {
        int pos = period.minus(this.start);
        this.vals[pos] = value;
    }

    public double[] internalStorage() {
        return this.vals;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (TsObservation obs : this) {
            builder.append(obs.getPeriod()).append('\t').append(obs.getValue());
            builder.append(System.lineSeparator());
        }
        return builder.toString();
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + (this.start != null ? this.start.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof TsData && this.equals((TsData)obj);
    }

    public boolean equals(TsData other) {
        if (!this.start.equals(other.start)) {
            return false;
        }
        return Arrays.equals(this.vals, other.vals);
    }

    @Override
    public double computeRecursively(double initial, DoubleBinaryOperator fn) {
        double cur = initial;
        for (int i = 0; i < this.vals.length; ++i) {
            cur = fn.applyAsDouble(cur, this.vals[i]);
        }
        return cur;
    }

    public void apply(DoubleUnaryOperator fn) {
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = fn.applyAsDouble(this.vals[i]);
        }
    }

    public void applyIf(DoublePredicate pred, DoubleUnaryOperator fn) {
        for (int i = 0; i < this.vals.length; ++i) {
            double cur = this.vals[i];
            if (!pred.test(cur)) continue;
            this.vals[i] = fn.applyAsDouble(cur);
        }
    }

    public void applyOnFinite(DoubleUnaryOperator fn) {
        this.applyIf(x -> Double.isFinite(x), fn);
    }

    public void applyRecursively(double initial, DoubleBinaryOperator fn) {
        double cur = initial;
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = cur = fn.applyAsDouble(cur, this.vals[i]);
        }
    }

    @Override
    public boolean check(DoublePredicate pred) {
        for (int i = 0; i < this.vals.length; ++i) {
            if (pred.test(this.vals[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int count(DoublePredicate pred) {
        int n = 0;
        for (int i = 0; i < this.vals.length; ++i) {
            if (!pred.test(this.vals[i])) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int first(DoublePredicate pred) {
        for (int i = 0; i < this.vals.length; ++i) {
            if (!pred.test(this.vals[i])) continue;
            return i;
        }
        return this.vals.length;
    }

    @Override
    public int last(DoublePredicate pred) {
        for (int i = 0; i < this.vals.length; ++i) {
            if (!pred.test(this.vals[i])) continue;
            return i;
        }
        return -1;
    }

    public TsData transform(DoubleUnaryOperator fn) {
        TsData ns = new TsData(this.start, this.vals.length);
        for (int i = 0; i < this.vals.length; ++i) {
            ns.vals[i] = fn.applyAsDouble(this.vals[i]);
        }
        return ns;
    }

    public TsData transformFinite(DoubleUnaryOperator fn) {
        TsData ns = new TsData(this.start, this.vals.length);
        for (int i = 0; i < this.vals.length; ++i) {
            double cur = this.vals[i];
            ns.vals[i] = Double.isFinite(cur) ? fn.applyAsDouble(cur) : Double.NaN;
        }
        return ns;
    }

    public TsData autoTransform(int lag, DoubleBinaryOperator fn) {
        int n = this.vals.length - lag;
        if (n <= 0) {
            return null;
        }
        TsData ns = new TsData(this.start.plus(lag), n);
        for (int i = 0; i < n; ++i) {
            double d0 = this.vals[i];
            double d1 = this.vals[i + lag];
            ns.vals[i] = Double.isFinite(d0) && Double.isFinite(d1) ? fn.applyAsDouble(d1, d0) : Double.NaN;
        }
        return ns;
    }

    public void apply(IReadDataBlock x, DoubleBinaryOperator fn) {
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = fn.applyAsDouble(this.vals[i], x.get(i));
        }
    }

    public void applyOnFinite(IReadDataBlock x, DoubleBinaryOperator fn) {
        for (int i = 0; i < this.vals.length; ++i) {
            double cur = this.vals[i];
            if (!Double.isFinite(cur)) continue;
            this.vals[i] = fn.applyAsDouble(cur, x.get(i));
        }
    }

    public void set(DoubleSupplier fn) {
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = fn.getAsDouble();
        }
    }

    public void setIf(DoublePredicate pred, DoubleSupplier fn) {
        for (int i = 0; i < this.vals.length; ++i) {
            if (!pred.test(this.vals[i])) continue;
            this.vals[i] = fn.getAsDouble();
        }
    }

    public void set(IntToDoubleFunction fn) {
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = fn.applyAsDouble(i);
        }
    }

    public void set(IReadDataBlock x, DoubleUnaryOperator fn) {
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = fn.applyAsDouble(x.get(i));
        }
    }

    public void set(IReadDataBlock x, IReadDataBlock y, DoubleBinaryOperator fn) {
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = fn.applyAsDouble(x.get(i), y.get(i));
        }
    }

    public static TsData computeOnIntersection(TsData tsl, TsData tsr, DoubleBinaryOperator fn) {
        TsDomain rDomain = tsr.getDomain();
        TsDomain lDomain = tsl.getDomain();
        TsDomain iDomain = lDomain.intersection(rDomain);
        if (iDomain == null) {
            return null;
        }
        int ni = iDomain.getLength();
        TsData rslt = new TsData(iDomain);
        if (ni == 0) {
            return rslt;
        }
        int rbeg = rDomain.firstid();
        int lbeg = tsl.start.id();
        int ibeg = iDomain.firstid();
        int li = ibeg - lbeg;
        int ri = ibeg - rbeg;
        rslt.set(tsl.rextract(li, ni), tsr.rextract(ri, ni), (a, b) -> {
            if (Double.isFinite(a) && Double.isFinite(b)) {
                return fn.applyAsDouble(a, b);
            }
            return Double.NaN;
        });
        return rslt;
    }

    private static final class TsIterator
    implements Iterator<TsObservation> {
        private final double[] m_vals;
        private final TsPeriod m_start;
        private int m_cur = -1;

        TsIterator(TsData ts) {
            this.m_start = ts.start;
            this.m_vals = ts.vals;
        }

        @Override
        public boolean hasNext() {
            if (this.m_cur >= this.m_vals.length) {
                return false;
            }
            for (int i = this.m_cur + 1; i < this.m_vals.length; ++i) {
                if (!Double.isFinite(this.m_vals[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public TsObservation next() {
            ++this.m_cur;
            this.searchNext();
            return new TsObservation(this.m_start.plus(this.m_cur), this.m_vals[this.m_cur]);
        }

        private void searchNext() {
            while (this.m_cur < this.m_vals.length && !Double.isFinite(this.m_vals[this.m_cur])) {
                ++this.m_cur;
            }
        }
    }
}

