/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.diagnostics;

import ec.tstoolkit.arima.estimation.IRegArimaProcessor;
import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.dstats.F;
import ec.tstoolkit.dstats.TestType;
import ec.tstoolkit.modelling.arima.diagnostics.IOneStepAheadForecastingTest;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.estimation.GlsSarimaMonitor;
import ec.tstoolkit.stats.MeanTest;
import ec.tstoolkit.stats.StatisticalTest;

public abstract class AbstractOneStepAheadForecastingTest
implements IOneStepAheadForecastingTest {
    private IRegArimaProcessor<SarimaModel> processor_ = new GlsSarimaMonitor();
    private final int nback_;
    private DataBlock res_;
    private double min_;
    private double mout_;
    private double vin_;
    private double vout_;
    private boolean mean_;

    protected AbstractOneStepAheadForecastingTest(int nback) {
        this.nback_ = nback;
    }

    public IRegArimaProcessor<SarimaModel> getProcessor() {
        return this.processor_;
    }

    @Override
    public int getOutOfSampleLength() {
        return this.nback_;
    }

    @Override
    public int getInSampleLength() {
        return this.res_.getLength() - this.nback_;
    }

    public void setProcessor(IRegArimaProcessor<SarimaModel> processor) {
        this.processor_ = processor;
    }

    @Override
    public boolean test(RegArimaModel<SarimaModel> regarima) {
        try {
            RegArimaModel<SarimaModel> model = this.linearize(regarima);
            this.res_ = this.computeResiduals(model);
            if (this.res_ == null) {
                return false;
            }
        }
        catch (Exception err) {
            return false;
        }
        int n = this.res_.getLength();
        if (n <= this.nback_ + 2) {
            return false;
        }
        DataBlock in = this.res_.drop(0, this.nback_);
        DataBlock out = this.res_.range(in.getLength(), n);
        int nsample = this.mean_ ? in.getLength() - 1 : in.getLength();
        this.min_ = in.sum() / (double)in.getLength();
        this.vin_ = in.ssq() / (double)nsample;
        this.mout_ = out.sum() / (double)this.nback_;
        this.vout_ = out.ssq() / (double)this.nback_;
        return true;
    }

    @Override
    public MeanTest outOfSampleMeanTest() {
        int n = this.res_.getLength();
        DataBlock in = this.res_.drop(0, this.nback_);
        DataBlock out = this.res_.range(in.getLength(), n);
        MeanTest test = new MeanTest();
        int nsample = this.mean_ ? in.getLength() - 1 : in.getLength();
        test.sampleMean(out, 0.0, Math.sqrt(in.ssq() / (double)nsample), nsample, TestType.TwoSided);
        return test;
    }

    @Override
    public IReadDataBlock getInSampleResiduals() {
        return this.res_.drop(0, this.nback_);
    }

    @Override
    public double getInSampleME() {
        return this.min_;
    }

    @Override
    public double getOutOfSampleME() {
        return this.mout_;
    }

    @Override
    public double getInSampleMSE() {
        return this.vin_;
    }

    @Override
    public double getOutOfSampleMSE() {
        return this.vout_;
    }

    @Override
    public IReadDataBlock getOutOfSampleResiduals() {
        int n = this.res_.getLength();
        return this.res_.range(n - this.nback_, n);
    }

    @Override
    public StatisticalTest mseTest() {
        int n = this.res_.getLength();
        int nin = n - this.nback_;
        if (this.mean_) {
            --nin;
        }
        F f = new F();
        f.setDFNum(this.nback_);
        f.setDFDenom(nin);
        return new StatisticalTest(f, this.vout_ / this.vin_, TestType.Upper, false);
    }

    @Override
    public MeanTest inSampleMeanTest() {
        DataBlock in = this.res_.drop(0, this.nback_);
        MeanTest test = new MeanTest();
        int nsample = this.mean_ ? in.getLength() - 1 : in.getLength();
        test.sampleMean(in, 0.0, Math.sqrt(in.ssq() / (double)nsample), nsample, TestType.TwoSided);
        return test;
    }

    private RegArimaModel<SarimaModel> linearize(RegArimaModel<SarimaModel> regarima) {
        if (regarima.getVarsCount() == 0) {
            return regarima;
        }
        DataBlock z = regarima.getY().deepClone();
        double[] b = regarima.computeLikelihood().getB();
        if (b != null) {
            int i;
            int start = regarima.isMeanCorrection() ? 1 : 0;
            int[] missings = regarima.getMissings();
            if (missings != null) {
                for (i = 0; i < missings.length; ++i) {
                    z.add(missings[i], -b[start + i]);
                }
                start += missings.length;
            }
            if (b != null) {
                for (i = start; i < b.length; ++i) {
                    z.addAY(-b[i], regarima.X(i - start));
                }
            }
        }
        this.mean_ = regarima.isMeanCorrection();
        RegArimaModel<SarimaModel> lmodel = new RegArimaModel<SarimaModel>();
        lmodel.setY(z);
        lmodel.setArima(regarima.getArima());
        lmodel.setMeanCorrection(this.mean_);
        return lmodel;
    }

    protected RegArimaEstimation<SarimaModel> inSampleEstimate(RegArimaModel<SarimaModel> regarima) {
        if (regarima.getObsCount() <= this.nback_) {
            return null;
        }
        RegArimaModel<SarimaModel> model = new RegArimaModel<SarimaModel>();
        model.setMeanCorrection(regarima.isMeanCorrection());
        model.setY(regarima.getY().drop(0, this.nback_));
        model.setArima(regarima.getArima());
        return this.processor_.optimize(model);
    }

    protected abstract DataBlock computeResiduals(RegArimaModel<SarimaModel> var1);
}

