/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.ssf.ISsf;

public abstract class AbstractTimeVaryingRegSsf
implements ISsf {
    private final int m_mr;
    private final int m_r;
    private final SubMatrix m_X;
    private final ISsf m_ssf;
    private final DataBlock m_tmp;

    protected abstract void fullRegNoise(int var1, SubMatrix var2);

    protected abstract int getRegNoiseDim();

    protected abstract boolean isRegNoiseTimeInvariant();

    protected abstract void regNoise(int var1, SubMatrix var2);

    protected abstract void wRegNoise(int var1, SubMatrix var2);

    public AbstractTimeVaryingRegSsf(ISsf ssf, SubMatrix X) {
        this.m_ssf = ssf;
        this.m_X = X;
        this.m_mr = ssf.getStateDim();
        this.m_r = this.m_mr + X.getColumnsCount();
        this.m_tmp = new DataBlock(this.m_r);
    }

    public ISsf getCoreSsf() {
        return this.m_ssf;
    }

    @Override
    public void diffuseConstraints(SubMatrix b) {
        int nd = this.m_ssf.getNonStationaryDim();
        if (nd > 0) {
            this.m_ssf.diffuseConstraints(b.extract(0, this.m_mr, 0, nd));
        }
        b.extract(this.m_mr, this.m_r, nd, nd + this.m_X.getColumnsCount()).diagonal().set(1.0);
    }

    @Override
    public void fullQ(int pos, SubMatrix qm) {
        this.m_ssf.fullQ(pos, qm.extract(0, this.m_mr, 0, this.m_mr));
        this.fullRegNoise(pos, qm.extract(this.m_mr, this.m_r, this.m_mr, this.m_r));
    }

    public int getFinalPosition() {
        return this.m_X.getRowsCount();
    }

    @Override
    public int getNonStationaryDim() {
        return this.m_ssf.getNonStationaryDim() + this.m_X.getColumnsCount();
    }

    @Override
    public int getStateDim() {
        return this.m_r;
    }

    @Override
    public int getTransitionResCount() {
        return this.m_ssf.getTransitionResCount() + this.m_X.getColumnsCount();
    }

    @Override
    public int getTransitionResDim() {
        return this.m_ssf.getTransitionResDim() + this.getRegNoiseDim();
    }

    public SubMatrix getX() {
        return this.m_X;
    }

    @Override
    public boolean hasR() {
        return this.m_ssf.hasR();
    }

    @Override
    public boolean hasTransitionRes(int pos) {
        return true;
    }

    @Override
    public boolean hasW() {
        return this.m_ssf.hasW() || this.m_X.getColumnsCount() > this.getRegNoiseDim();
    }

    @Override
    public boolean isDiffuse() {
        return true;
    }

    @Override
    public boolean isMeasurementEquationTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTransitionEquationTimeInvariant() {
        return this.m_ssf.isTransitionEquationTimeInvariant() && this.isRegNoiseTimeInvariant();
    }

    @Override
    public boolean isTransitionResidualTimeInvariant() {
        return this.m_ssf.isTransitionResidualTimeInvariant() && this.isRegNoiseTimeInvariant();
    }

    @Override
    public boolean isValid() {
        return this.m_ssf.isValid();
    }

    @Override
    public void L(int pos, DataBlock k, SubMatrix lm) {
        this.T(pos, lm);
        this.m_tmp.set(0.0);
        this.Z(pos, this.m_tmp);
        DataBlockIterator cols = lm.columns();
        DataBlock col = cols.getData();
        do {
            double w;
            if ((w = this.m_tmp.get(cols.getPosition())) == 0.0) continue;
            col.addAY(-w, k);
        } while (cols.next());
    }

    @Override
    public void Pf0(SubMatrix pf0) {
        this.m_ssf.Pf0(pf0.extract(0, this.m_mr, 0, this.m_mr));
    }

    @Override
    public void Pi0(SubMatrix pi0) {
        this.m_ssf.Pi0(pi0.extract(0, this.m_mr, 0, this.m_mr));
        pi0.extract(this.m_mr, this.m_r, this.m_mr, this.m_r).diagonal().set(1.0);
    }

    @Override
    public void Q(int pos, SubMatrix qm) {
        int r = this.m_ssf.getTransitionResDim();
        int rd = this.getRegNoiseDim();
        this.m_ssf.Q(pos, qm.extract(0, r, 0, r));
        this.regNoise(pos, qm.extract(r, r + rd, r, r + rd));
    }

    @Override
    public void R(int pos, SubArrayOfInt rv) {
        if (this.m_ssf.hasR()) {
            int r = this.m_ssf.getTransitionResCount();
            this.m_ssf.R(pos, rv.range(0, r));
            for (int i = this.m_mr; i < this.m_r; ++i) {
                rv.set(r++, i);
            }
        }
    }

    @Override
    public void T(int pos, SubMatrix tr) {
        this.m_ssf.T(pos, tr.extract(0, this.m_mr, 0, this.m_mr));
        tr.extract(this.m_mr, this.m_r, this.m_mr, this.m_r).diagonal().set(1.0);
    }

    @Override
    public void TVT(int pos, SubMatrix vm) {
        this.m_ssf.TVT(pos, vm.extract(0, this.m_mr, 0, this.m_mr));
        SubMatrix v01 = vm.extract(0, this.m_mr, this.m_mr, this.m_r);
        SubMatrix v10 = vm.extract(this.m_mr, this.m_r, 0, this.m_mr);
        DataBlockIterator cols = v01.columns();
        DataBlockIterator rows = v10.rows();
        DataBlock col = cols.getData();
        DataBlock row = rows.getData();
        do {
            this.m_ssf.TX(pos, col);
            row.copy(col);
        } while (cols.next() && rows.next());
    }

    @Override
    public void TX(int pos, DataBlock x) {
        this.m_ssf.TX(pos, x.range(0, this.m_mr));
    }

    @Override
    public void VpZdZ(int pos, SubMatrix vm, double d) {
        this.m_tmp.set(0.0);
        this.Z(pos, this.m_tmp);
        DataBlockIterator cols = vm.columns();
        DataBlock col = cols.getData();
        do {
            double w;
            if ((w = d * this.m_tmp.get(cols.getPosition())) == 0.0) continue;
            col.addAY(w, this.m_tmp);
        } while (cols.next());
    }

    @Override
    public void W(int pos, SubMatrix wv) {
        int mr = this.m_ssf.getTransitionResCount();
        int mc = this.m_ssf.getTransitionResDim();
        int xr = this.m_X.getColumnsCount();
        int xc = this.getRegNoiseDim();
        if (mc < mr) {
            this.m_ssf.W(pos, wv.extract(0, mr, 0, mc));
        }
        if (xr < xc) {
            this.wRegNoise(pos, wv.extract(mr, mr + xr, mc, mc + xc));
        } else {
            wv.subDiagonal(mc - mr).drop(mc, 0).set(1.0);
        }
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        DataBlock xm = x.range(0, this.m_mr);
        this.m_ssf.XpZd(pos, xm, d);
        DataBlock xx = x.range(this.m_mr, this.m_r);
        DataBlock X = this.m_X.row(pos);
        xx.addAY(d, X);
    }

    @Override
    public void XT(int pos, DataBlock x) {
        this.m_ssf.XT(pos, x.range(0, this.m_mr));
    }

    @Override
    public void Z(int pos, DataBlock x) {
        this.m_ssf.Z(pos, x.range(0, this.m_mr));
        x.range(this.m_mr, this.m_r).copy(this.m_X.row(pos));
    }

    @Override
    public void ZM(int pos, SubMatrix m, DataBlock x) {
        DataBlockIterator cols = m.columns();
        DataBlock col = cols.getData();
        for (int i = 0; i < m.getColumnsCount(); ++i) {
            x.set(i, this.ZX(pos, col));
            cols.next();
        }
    }

    @Override
    public double ZVZ(int pos, SubMatrix vm) {
        double v00 = this.m_ssf.ZVZ(pos, vm.extract(0, this.m_mr, 0, this.m_mr));
        double v11 = SymmetricMatrix.quadraticForm(vm.extract(this.m_mr, this.m_r, this.m_mr, this.m_r), this.m_X.row(pos));
        DataBlock tmp = this.m_tmp.range(this.m_mr, this.m_r);
        this.m_ssf.ZM(pos, vm.extract(0, this.m_mr, this.m_mr, this.m_r), tmp);
        double v01 = tmp.dot(this.m_X.row(pos));
        return v00 + 2.0 * v01 + v11;
    }

    @Override
    public double ZX(int pos, DataBlock x) {
        return this.m_ssf.ZX(pos, x.range(0, this.m_mr)) + x.range(this.m_mr, this.m_r).dot(this.m_X.row(pos));
    }
}

