/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.sarima.estimation;

import ec.tstoolkit.BaseException;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.eco.Ols;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.sarima.SarmaSpecification;
import ec.tstoolkit.sarima.estimation.HannanRissanen;
import ec.tstoolkit.sarima.estimation.IarimaInitializer;
import ec.tstoolkit.sarima.estimation.SarimaMapping;

public class SarimaFixedInitializer
implements IarimaInitializer {
    private boolean m_failhr;
    private boolean[] fixedItems;
    private double[] parameters;

    public SarimaFixedInitializer(double[] params, boolean[] fixed) {
        this.parameters = params;
        this.fixedItems = fixed;
    }

    public SarimaFixedInitializer(SarimaSpecification spec, IReadDataBlock parameters, boolean[] fixed) {
        this.parameters = new double[parameters.getLength()];
        parameters.copyTo(this.parameters, 0);
        this.fixedItems = fixed;
    }

    public boolean getfailHR() {
        return this.m_failhr;
    }

    @Override
    public SarimaModel initialize(RegArimaModel<SarimaModel> regs) {
        try {
            SarimaModel sarima = regs.getArima();
            if (sarima.getParametersCount() == 0) {
                return sarima;
            }
            SarimaSpecification spec = sarima.getSpecification();
            HannanRissanen hr = new HannanRissanen();
            SarmaSpecification dspec = spec.doStationary();
            DataBlock dy = null;
            if (regs.getDModel().getVarsCount() > 0) {
                Ols ols = new Ols();
                if (!ols.process(regs.getDModel())) {
                    return null;
                }
                dy = ols.getResiduals();
            } else {
                dy = regs.getDModel().getY();
            }
            if (!hr.process(dy, dspec) && this.m_failhr) {
                return null;
            }
            SarimaModel m = hr.getModel();
            if (!m.isStable(true) && this.m_failhr) {
                return null;
            }
            DataBlock tmp = new DataBlock(m.getParameters());
            int i = 0;
            while (++i <= 5) {
                for (int j = 0; j < this.parameters.length; ++j) {
                    if (!this.fixedItems[j]) continue;
                    tmp.set(j, this.parameters[j]);
                }
                m.setParameters(tmp);
                if (SarimaMapping.stabilize(m)) continue;
            }
            if (i > 5) {
                return null;
            }
            return m;
        }
        catch (BaseException ex) {
            return null;
        }
    }

    public void setFailHR(boolean value) {
        this.m_failhr = value;
    }
}

