/*
 * Decompiled with CFR 0.152.
 */
package demetra.xml.sa.tramoseats;

import demetra.xml.sa.tramoseats.IXmlTramoSeatsSpec;
import ec.satoolkit.tramoseats.TramoSeatsSpecification;
import ec.tstoolkit.modelling.arima.tramo.CalendarSpec;
import ec.tstoolkit.modelling.arima.tramo.EasterSpec;
import ec.tstoolkit.modelling.arima.tramo.RegressionSpec;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="easterSpecType")
public class XmlEaster
implements IXmlTramoSeatsSpec {
    static final String NAME = "easterSpecType";
    @XmlElement
    public Integer duration = 6;
    @XmlAttribute
    public Boolean pretest;

    public boolean isDurationSpecified() {
        return this.duration != null;
    }

    public boolean isPretestSpecified() {
        return this.pretest != null;
    }

    public static XmlEaster create(CalendarSpec spec) {
        if (!spec.getEaster().isUsed()) {
            return null;
        }
        XmlEaster easter = new XmlEaster();
        easter.duration = spec.getEaster().getDuration();
        if (spec.getEaster().isTest()) {
            easter.pretest = true;
        }
        return easter;
    }

    @Override
    public void copyTo(TramoSeatsSpecification spec) {
        RegressionSpec reg = spec.getTramoSpecification().getRegression();
        if (reg == null) {
            reg = new RegressionSpec();
            spec.getTramoSpecification().setRegression(reg);
        }
        CalendarSpec cspec = reg.getCalendar();
        EasterSpec easter = cspec.getEaster();
        if (this.isPretestSpecified()) {
            easter.setTest(this.pretest.booleanValue());
        }
        if (this.isDurationSpecified()) {
            easter.setDuration(this.duration.intValue());
        }
    }
}

