/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.realfunctions;

import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.realfunctions.IFunction;
import ec.tstoolkit.maths.realfunctions.IFunctionInstance;
import ec.tstoolkit.maths.realfunctions.IFunctionMinimizer;
import ec.tstoolkit.maths.realfunctions.ISsqFunction;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionInstance;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionMinimizer;

public class ProxyMinimizer
implements IFunctionMinimizer {
    private ISsqFunctionMinimizer m_min;

    public ProxyMinimizer(ISsqFunctionMinimizer min) {
        this.m_min = min;
    }

    public ISsqFunctionMinimizer getCore() {
        return this.m_min;
    }

    @Override
    public IFunctionMinimizer exemplar() {
        return new ProxyMinimizer(this.m_min.exemplar());
    }

    @Override
    public double getConvergenceCriterion() {
        return this.m_min.getConvergenceCriterion();
    }

    @Override
    public Matrix getCurvature() {
        return this.m_min.getCurvature();
    }

    @Override
    public double[] getGradient() {
        return this.m_min.getGradient();
    }

    @Override
    public double getObjective() {
        return this.m_min.getObjective();
    }

    @Override
    public int getIterCount() {
        return this.m_min.getIterCount();
    }

    @Override
    public int getMaxIter() {
        return this.m_min.getMaxIter();
    }

    @Override
    public IFunctionInstance getResult() {
        return (IFunctionInstance)((Object)this.m_min.getResult());
    }

    @Override
    public boolean minimize(IFunction function, IFunctionInstance start) {
        ISsqFunction fn = (ISsqFunction)((Object)function);
        ISsqFunctionInstance s = fn.ssqEvaluate(start.getParameters());
        return this.m_min.minimize(fn, s);
    }

    @Override
    public void setConvergenceCriterion(double value) {
        this.m_min.setConvergenceCriterion(value);
    }

    @Override
    public void setMaxIter(int n) {
        this.m_min.setMaxIter(n);
    }
}

