/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling;

import ec.tstoolkit.modelling.ComponentInformation;
import ec.tstoolkit.modelling.ComponentType;

public class SeriesInfo
implements Comparable<SeriesInfo> {
    public final String name;
    public final ComponentType component;
    public final ComponentInformation info;
    public final boolean isSystem;
    public String description;
    public String comment;
    public static final String F_SUFFIX = "_f";
    public static final String E_SUFFIX = "_e";
    public static final String EF_SUFFIX = "_ef";
    public static final String B_SUFFIX = "_b";

    public SeriesInfo(String name, ComponentType type) {
        this.name = name;
        this.component = type;
        this.description = null;
        this.info = ComponentInformation.Value;
        this.isSystem = false;
    }

    public SeriesInfo(String name, String desc) {
        this.name = name;
        this.component = ComponentType.Undefined;
        this.description = desc;
        this.info = ComponentInformation.Value;
        this.isSystem = false;
    }

    public SeriesInfo(String name, String desc, ComponentType type) {
        this.name = name;
        this.component = type;
        this.description = desc;
        this.info = ComponentInformation.Value;
        this.isSystem = false;
    }

    SeriesInfo(String name, String desc, ComponentType type, boolean system) {
        this.name = name;
        this.component = type;
        this.description = desc;
        this.info = ComponentInformation.Value;
        this.isSystem = system;
    }

    public SeriesInfo(String name, String description, ComponentType type, ComponentInformation info) {
        this.name = name;
        this.component = type;
        this.description = description;
        this.info = info;
        this.isSystem = false;
    }

    SeriesInfo(String name, String description, ComponentType type, ComponentInformation info, boolean system) {
        this.name = name;
        this.component = type;
        this.description = description;
        this.info = info;
        this.isSystem = system;
    }

    @Override
    public int compareTo(SeriesInfo o) {
        if (this == o) {
            return 0;
        }
        int cmp = this.name.compareTo(o.name);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.component.compareTo(o.component);
        if (cmp != 0) {
            return cmp;
        }
        return this.info.compareTo(o.info);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.description != null && this.description.length() > 0) {
            builder.append(this.description);
        } else {
            builder.append(this.name);
        }
        if (this.info == ComponentInformation.Value || this.info == ComponentInformation.Undefined) {
            return builder.toString();
        }
        builder.append(" (");
        if (this.info == ComponentInformation.Forecast) {
            builder.append("forecasts)");
        } else if (this.info == ComponentInformation.Stdev) {
            builder.append("std error)");
        } else if (this.info == ComponentInformation.StdevForecast) {
            builder.append("forecast errors)");
        }
        return builder.toString();
    }

    public String getCode() {
        if (this.info == ComponentInformation.Undefined || this.info == ComponentInformation.Value) {
            return this.name;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.name);
        switch (this.info) {
            case Forecast: {
                builder.append(F_SUFFIX);
                break;
            }
            case Stdev: {
                builder.append(E_SUFFIX);
                break;
            }
            case StdevForecast: {
                builder.append(EF_SUFFIX);
            }
        }
        return builder.toString();
    }

    public static SeriesInfo split(String code) {
        int len = code.length();
        if (SeriesInfo.hasSuffix(code, F_SUFFIX)) {
            return new SeriesInfo(code.substring(0, len - 2), null, ComponentType.Undefined, ComponentInformation.Forecast);
        }
        if (SeriesInfo.hasSuffix(code, E_SUFFIX)) {
            return new SeriesInfo(code.substring(0, len - 2), null, ComponentType.Undefined, ComponentInformation.Stdev);
        }
        if (SeriesInfo.hasSuffix(code, EF_SUFFIX)) {
            return new SeriesInfo(code.substring(0, len - 3), null, ComponentType.Undefined, ComponentInformation.StdevForecast);
        }
        return new SeriesInfo(code, ComponentType.Undefined);
    }

    private static boolean hasSuffix(String s, String suffix) {
        int slen;
        int len = s.length();
        if (len <= (slen = suffix.length())) {
            return false;
        }
        int i = len - slen;
        for (int j = 0; j < slen; ++j) {
            if (s.charAt(i) != suffix.charAt(j)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

