/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.linearfilters;

import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.Simplifying;
import ec.tstoolkit.maths.linearfilters.AbstractFiniteFilter;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.polynomials.IRootsSolver;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.PolynomialException;
import ec.tstoolkit.maths.polynomials.UnitRootSelector;
import ec.tstoolkit.maths.polynomials.UnitRootsSolver;

public class ForeFilter
extends AbstractFiniteFilter {
    public static final ForeFilter ZERO = new ForeFilter(Polynomial.ZERO);
    public static final ForeFilter ONE = new ForeFilter(Polynomial.ONE);
    private final Polynomial m_p;

    public static ForeFilter add(double d, ForeFilter l) {
        Polynomial p = l.m_p.plus(d);
        return new ForeFilter(p);
    }

    public static ForeFilter multiply(double d, ForeFilter l) {
        Polynomial p = l.m_p.times(d);
        return new ForeFilter(p);
    }

    public ForeFilter(double[] w) {
        this.m_p = Polynomial.of(w).adjustDegree();
    }

    public ForeFilter(Polynomial p) {
        this.m_p = p.adjustDegree();
    }

    public ForeFilter divide(ForeFilter r) {
        Polynomial.Division div = Polynomial.divide(this.m_p, r.m_p);
        if (!div.getRemainder().isZero()) {
            throw new PolynomialException("p_err_div");
        }
        return new ForeFilter(div.getQuotient());
    }

    public double get(int idx) {
        return this.m_p.get(idx);
    }

    public Polynomial getPolynomial() {
        return this.m_p;
    }

    public int getDegree() {
        return this.m_p.getDegree();
    }

    @Override
    public int getLength() {
        return this.m_p.getDegree() + 1;
    }

    @Override
    public int getLowerBound() {
        return 0;
    }

    @Override
    public int getUpperBound() {
        return this.m_p.getDegree();
    }

    @Override
    public double getWeight(int pos) {
        return this.m_p.get(pos);
    }

    @Override
    public double[] getWeights() {
        return this.m_p.getCoefficients();
    }

    public boolean isIdentity() {
        return this.m_p.isIdentity();
    }

    public boolean isNull() {
        return this.m_p.isZero();
    }

    public ForeFilter minus(double d) {
        Polynomial p = this.m_p.minus(d);
        return new ForeFilter(p);
    }

    public ForeFilter minus(ForeFilter r) {
        Polynomial p = this.m_p.minus(r.m_p);
        return new ForeFilter(p);
    }

    @Override
    public BackFilter mirror() {
        return new BackFilter(this.m_p);
    }

    public ForeFilter negate() {
        Polynomial p = this.m_p.negate();
        return new ForeFilter(p);
    }

    public ForeFilter normalize() {
        double r = this.m_p.get(0);
        if (r == 0.0 || r == 1.0) {
            return this;
        }
        return new ForeFilter(this.m_p.times(1.0 / r));
    }

    public ForeFilter plus(double d) {
        Polynomial p = this.m_p.plus(d);
        return new ForeFilter(p);
    }

    public ForeFilter plus(ForeFilter r) {
        Polynomial p = this.m_p.plus(r.m_p);
        return new ForeFilter(p);
    }

    public Complex[] roots() {
        return this.m_p.roots();
    }

    public Complex[] roots(IRootsSolver searcher) {
        return this.m_p.roots(searcher);
    }

    public ForeFilter times(double d) {
        Polynomial p = this.m_p.times(d);
        return new ForeFilter(p);
    }

    public ForeFilter times(ForeFilter r) {
        Polynomial p = this.m_p.times(r.m_p);
        return new ForeFilter(p);
    }

    public String toString() {
        return this.m_p.toString('B', true);
    }

    public static class StationaryTransformation {
        public ForeFilter unitRoots;
        public ForeFilter stationaryFilter;
        private int freq;

        public StationaryTransformation() {
            this.freq = 0;
        }

        public StationaryTransformation(int freq) {
            this.freq = freq;
        }

        public boolean transform(ForeFilter f) {
            UnitRootsSolver urs = this.freq == 0 ? new UnitRootsSolver() : new UnitRootsSolver(this.freq);
            urs.factorize(f.m_p);
            this.unitRoots = new ForeFilter(urs.getUnitRoots().toPolynomial());
            if (this.unitRoots.getDegree() == 0) {
                this.stationaryFilter = f;
                return false;
            }
            this.stationaryFilter = new ForeFilter(urs.remainder());
            return true;
        }
    }

    public static class SimplifyingTool
    extends Simplifying<ForeFilter> {
        private final boolean m_sur;

        public SimplifyingTool(boolean simplifyUR) {
            this.m_sur = simplifyUR;
        }

        @Override
        public boolean simplify(ForeFilter left, ForeFilter right) {
            this.clear();
            if (left.getLength() == 1 || right.getLength() == 1) {
                return false;
            }
            Polynomial lp = left.m_p;
            Polynomial rp = right.m_p;
            double l0 = lp.get(0);
            double r0 = rp.get(0);
            Polynomial.SimplifyingTool psimp = new Polynomial.SimplifyingTool();
            if (psimp.simplify(lp, rp)) {
                lp = (Polynomial)psimp.getLeft();
                rp = (Polynomial)psimp.getRight();
                lp = lp.times(l0 / lp.get(0));
                rp = rp.times(r0 / rp.get(0));
                Polynomial p = (Polynomial)psimp.getCommon();
                p = p.divide(p.get(0));
                if (this.m_sur || p.getDegree() == 0) {
                    this.m_common = new ForeFilter(p);
                    this.m_left = new ForeFilter(lp);
                    this.m_right = new ForeFilter(rp);
                    return true;
                }
                UnitRootSelector ursel = new UnitRootSelector();
                if (ursel.select(p)) {
                    Polynomial pnur = ursel.getOutofSelection();
                    Polynomial pur = ursel.getSelection();
                    pur = pur.divide(pur.get(0));
                    pnur = pnur.divide(pnur.get(0));
                    this.m_common = new ForeFilter(pnur);
                    this.m_left = new ForeFilter(lp.times(pur));
                    this.m_right = new ForeFilter(rp.times(pur));
                    return true;
                }
                this.m_common = new ForeFilter(p);
                this.m_left = new ForeFilter(lp);
                this.m_right = new ForeFilter(rp);
                return true;
            }
            return false;
        }
    }
}

