/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.YesNoCancelDialog;
import ij.io.SaveDialog;
import ij.macro.FunctionFinder;
import ij.macro.Interpreter;
import ij.macro.MacroConstants;
import ij.macro.MacroRunner;
import ij.macro.Program;
import ij.plugin.MacroInstaller;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.text.TextWindow;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.PrintGraphics;
import java.awt.PrintJob;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Locale;
import java.util.Properties;

public class Editor
extends PlugInFrame
implements ActionListener,
ItemListener,
TextListener,
ClipboardOwner,
MacroConstants {
    public static String JavaScriptIncludes = "importPackage(Packages.ij);importPackage(Packages.ij.gui);importPackage(Packages.ij.process);importPackage(Packages.ij.measure);importPackage(Packages.ij.util);importPackage(Packages.ij.plugin);importPackage(Packages.ij.io);importPackage(Packages.ij.plugin.filter);importPackage(Packages.ij.plugin.frame);importPackage(java.lang);importPackage(java.awt);importPackage(java.awt.image);importPackage(java.awt.geom);importPackage(java.util);importPackage(java.io);function print(s) {IJ.log(s);};";
    public static String JS_NOT_FOUND = "JavaScript.jar was not found in the plugins\nfolder. It can be downloaded from:\n \nhttp://imagej.nih.gov/ij/download/tools/JavaScript.jar";
    public static final int MAX_SIZE = 28000;
    public static final int XINC = 10;
    public static final int YINC = 18;
    public static final int MONOSPACED = 1;
    public static final int MENU_BAR = 2;
    public static final int MACROS_MENU_ITEMS = 8;
    static final String FONT_SIZE = "editor.font.size";
    static final String FONT_MONO = "editor.font.mono";
    static final String CASE_SENSITIVE = "editor.case-sensitive";
    private TextArea ta;
    private String path;
    private boolean changes;
    private static String searchString = "";
    private static boolean caseSensitive = Prefs.get("editor.case-sensitive", true);
    private static int lineNumber = 1;
    private static int xoffset;
    private static int yoffset;
    private static int nWindows;
    private Menu fileMenu;
    private Menu editMenu;
    private Properties p = new Properties();
    private int[] macroStarts;
    private String[] macroNames;
    private MenuBar mb;
    private Menu macrosMenu;
    private int nMacros;
    private Program pgm;
    private int eventCount;
    private String shortcutsInUse;
    private int inUseCount;
    private MacroInstaller installer;
    private static String defaultDir;
    private boolean dontShowWindow;
    private int[] sizes = new int[]{9, 10, 11, 12, 13, 14, 16, 18, 20, 24, 36, 48, 60, 72};
    private int fontSize = (int)Prefs.get("editor.font.size", 5.0);
    private CheckboxMenuItem monospaced;
    private static boolean wholeWords;
    private boolean isMacroWindow;
    private int debugStart;
    private int debugEnd;
    private static TextWindow debugWindow;
    private boolean step;
    private int previousLine;
    private static Editor instance;
    private int runToLine;
    private boolean fixedLineEndings;

    public Editor() {
        this(16, 60, 0, 2);
    }

    public Editor(int n, int n2, int n3, int n4) {
        super("Editor");
        WindowManager.addWindow(this);
        this.addMenuBar(n4);
        this.ta = new TextArea(n, n2);
        this.ta.addTextListener(this);
        if (IJ.isLinux()) {
            this.ta.setBackground(Color.white);
        }
        this.addKeyListener(IJ.getInstance());
        this.add(this.ta);
        this.pack();
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 >= this.sizes.length) {
            n3 = this.sizes.length - 1;
        }
        this.setFont();
        this.positionWindow();
    }

    void addMenuBar(int n) {
        this.mb = new MenuBar();
        if (Menus.getFontSize() != 0) {
            // empty if block
        }
        this.mb.setFont(Menus.getFont());
        Menu menu = new Menu("File");
        menu.add(new MenuItem("New...", new MenuShortcut(78, true)));
        menu.add(new MenuItem("Open...", new MenuShortcut(79)));
        menu.add(new MenuItem("Save", new MenuShortcut(83)));
        menu.add(new MenuItem("Save As..."));
        menu.add(new MenuItem("Print...", new MenuShortcut(80)));
        menu.addActionListener(this);
        this.fileMenu = menu;
        this.mb.add(menu);
        menu = new Menu("Edit");
        String string = IJ.isMacintosh() ? "  Cmd " : "  Ctrl+";
        MenuItem menuItem = new MenuItem("Undo" + string + "Z");
        menuItem.setEnabled(false);
        menu.add(menuItem);
        menu.addSeparator();
        boolean bl = IJ.isWindows() && (System.getProperty("java.version").indexOf("1.1.8") >= 0 || System.getProperty("java.version").indexOf("1.5.") >= 0);
        menuItem = bl ? new MenuItem("Cut  Ctrl+X") : new MenuItem("Cut", new MenuShortcut(88));
        menu.add(menuItem);
        menuItem = bl ? new MenuItem("Copy  Ctrl+C") : new MenuItem("Copy", new MenuShortcut(67));
        menu.add(menuItem);
        menuItem = bl ? new MenuItem("Paste  Ctrl+V") : new MenuItem("Paste", new MenuShortcut(86));
        menu.add(menuItem);
        menu.addSeparator();
        menu.add(new MenuItem("Find...", new MenuShortcut(70)));
        menu.add(new MenuItem("Find Next", new MenuShortcut(71)));
        menu.add(new MenuItem("Go to Line...", new MenuShortcut(76)));
        menu.addSeparator();
        menu.add(new MenuItem("Select All", new MenuShortcut(65)));
        menu.add(new MenuItem("Zap Gremlins"));
        menu.add(new MenuItem("Copy to Image Info"));
        menu.addActionListener(this);
        this.mb.add(menu);
        this.editMenu = menu;
        if ((n & 2) != 0) {
            this.setMenuBar(this.mb);
        }
        menu = new Menu("Font");
        menu.add(new MenuItem("Make Text Smaller", new MenuShortcut(78)));
        menu.add(new MenuItem("Make Text Larger", new MenuShortcut(77)));
        menu.addSeparator();
        this.monospaced = new CheckboxMenuItem("Monospaced Font", Prefs.get(FONT_MONO, false));
        if ((n & 1) != 0) {
            this.monospaced.setState(true);
        }
        this.monospaced.addItemListener(this);
        menu.add(this.monospaced);
        menu.add(new MenuItem("Save Settings"));
        menu.addActionListener(this);
        this.mb.add(menu);
    }

    public void positionWindow() {
        Dimension dimension = IJ.getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.width == 0) {
            return;
        }
        int n = dimension.width / 2 - dimension2.width / 2;
        int n2 = (dimension.height - dimension2.height) / 4;
        if (n2 < 0) {
            n2 = 0;
        }
        if (nWindows <= 0 || xoffset > 80) {
            xoffset = 0;
            yoffset = 0;
        }
        this.setLocation(n + xoffset, n2 + yoffset);
        xoffset += 10;
        yoffset += 18;
        ++nWindows;
    }

    void setWindowTitle(String string) {
        Menus.updateWindowMenuItem(this.getTitle(), string);
        this.setTitle(string);
    }

    public void create(String string, String string2) {
        boolean bl;
        if (string2 != null && string2.length() > 0) {
            this.fixedLineEndings = true;
        }
        this.ta.append(string2);
        if (IJ.isMacOSX()) {
            IJ.wait(25);
        }
        this.ta.setCaretPosition(0);
        this.setWindowTitle(string);
        boolean bl2 = bl = string.endsWith(".txt") || string.endsWith(".ijm");
        if (bl || string.endsWith(".js") || string.indexOf(".") == -1) {
            this.macrosMenu = new Menu("Macros");
            this.macrosMenu.add(new MenuItem("Run Macro", new MenuShortcut(82)));
            this.macrosMenu.add(new MenuItem("Evaluate Line", new MenuShortcut(89)));
            this.macrosMenu.add(new MenuItem("Abort Macro"));
            this.macrosMenu.add(new MenuItem("Install Macros", new MenuShortcut(73)));
            this.macrosMenu.add(new MenuItem("Function Finder...", new MenuShortcut(70, true)));
            this.macrosMenu.addSeparator();
            this.macrosMenu.add(new MenuItem("Evaluate JavaScript", new MenuShortcut(74, false)));
            this.macrosMenu.addSeparator();
            this.macrosMenu.addActionListener(this);
            this.mb.add(this.macrosMenu);
            if (!string.endsWith(".js")) {
                Menu menu = new Menu("Debug");
                menu.add(new MenuItem("Debug Macro", new MenuShortcut(68)));
                menu.add(new MenuItem("Step", new MenuShortcut(69)));
                menu.add(new MenuItem("Trace", new MenuShortcut(84)));
                menu.add(new MenuItem("Fast Trace", new MenuShortcut(84, true)));
                menu.add(new MenuItem("Run"));
                menu.add(new MenuItem("Run to Insertion Point"));
                menu.add(new MenuItem("Abort"));
                menu.addActionListener(this);
                this.mb.add(menu);
            }
            if (bl && string2.indexOf("macro ") != -1) {
                this.installMacros(string2, false);
            }
        } else {
            this.fileMenu.addSeparator();
            this.fileMenu.add(new MenuItem("Compile and Run", new MenuShortcut(82)));
        }
        if (IJ.getInstance() != null && !this.dontShowWindow) {
            this.show();
        }
        if (this.dontShowWindow) {
            this.dispose();
            this.dontShowWindow = false;
        }
        WindowManager.setWindow(this);
        this.changes = false;
    }

    public void createMacro(String string, String string2) {
        this.create(string, string2);
    }

    void installMacros(String string, boolean bl) {
        String string2 = Interpreter.getAdditionalFunctions();
        if (string2 != null && string != null) {
            string = !string.endsWith("\n") && !string2.startsWith("\n") ? string + "\n" + string2 : string + string2;
        }
        this.installer = new MacroInstaller();
        this.installer.setFileName(this.getTitle());
        int n = this.installer.install(string, this.macrosMenu);
        if (bl || n > 0) {
            this.installer.install(null);
        }
        this.dontShowWindow = this.installer.isAutoRunAndHide();
    }

    public void open(String string, String string2) {
        this.path = string + string2;
        File file = new File(this.path);
        try {
            String string3;
            StringBuffer stringBuffer = new StringBuffer(5000);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string3 + "\n");
            }
            bufferedReader.close();
            this.create(string2, new String(stringBuffer));
            this.changes = false;
        }
        catch (Exception exception) {
            IJ.handleException(exception);
            return;
        }
    }

    public String getText() {
        if (this.ta == null) {
            return "";
        }
        return this.ta.getText();
    }

    public TextArea getTextArea() {
        return this.ta;
    }

    public void display(String string, String string2) {
        this.ta.selectAll();
        this.ta.replaceRange(string2, this.ta.getSelectionStart(), this.ta.getSelectionEnd());
        this.ta.setCaretPosition(0);
        this.setWindowTitle(string);
        this.changes = false;
        if (IJ.getInstance() != null) {
            this.show();
        }
        WindowManager.setWindow(this);
    }

    void save() {
        if (this.path == null) {
            this.saveAs();
            return;
        }
        File file = new File(this.path);
        if (file.exists() && !file.canWrite()) {
            IJ.showMessage("Editor", "Unable to save because file is write-protected. \n \n" + this.path);
            return;
        }
        String string = this.ta.getText();
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new CharArrayReader(cArray));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.path));
            while ((string2 = bufferedReader.readLine()) != null) {
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
            IJ.showStatus(string.length() + " chars saved to " + this.path);
            this.changes = false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void compileAndRun() {
        if (this.path == null) {
            this.saveAs();
        }
        if (this.path != null) {
            this.save();
            IJ.runPlugIn("ij.plugin.Compiler", this.path);
        }
    }

    final void runMacro(boolean bl) {
        int n;
        if (this.getTitle().endsWith(".js")) {
            this.evaluateJavaScript();
            return;
        }
        int n2 = this.ta.getSelectionStart();
        String string = n2 == (n = this.ta.getSelectionEnd()) ? this.ta.getText() : this.ta.getSelectedText();
        new MacroRunner(string, bl ? this : null);
    }

    void evaluateJavaScript() {
        int n;
        int n2;
        String string;
        if (!this.getTitle().endsWith(".js")) {
            this.setTitle(SaveDialog.setExtension(this.getTitle(), ".js"));
        }
        if ((string = (n2 = this.ta.getSelectionStart()) == (n = this.ta.getSelectionEnd()) ? this.ta.getText() : this.ta.getSelectedText()).equals("")) {
            return;
        }
        string = Editor.getJSPrefix("") + string;
        if (IJ.isJava16() && (!IJ.isMacOSX() || IJ.is64Bit())) {
            IJ.runPlugIn("JavaScriptEvaluator", string);
        } else {
            Object object = IJ.runPlugIn("JavaScript", string);
            if (object == null) {
                IJ.error(JS_NOT_FOUND);
            }
        }
    }

    void evaluateLine() {
        int n = this.ta.getSelectionStart();
        int n2 = this.ta.getSelectionEnd();
        if (n2 > n) {
            this.runMacro(false);
            return;
        }
        String string = this.ta.getText();
        while (n > 0) {
            if (string.charAt(--n) != '\n') continue;
            ++n;
            break;
        }
        while (n2 < string.length() - 1 && string.charAt(++n2) != '\n') {
        }
        this.ta.setSelectionStart(n);
        this.ta.setSelectionEnd(n2);
        this.runMacro(false);
    }

    void print() {
        PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob(this, "Cool Stuff", this.p);
        if (printJob != null) {
            Graphics graphics = printJob.getGraphics();
            if (graphics != null) {
                String string = this.ta.getText();
                this.printString(printJob, graphics, string);
                graphics.dispose();
            }
            printJob.end();
        }
    }

    void printString(PrintJob printJob, Graphics graphics, String string) {
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        int n4 = 30;
        int n5 = 30;
        int n6 = 30;
        if (!(graphics instanceof PrintGraphics)) {
            throw new IllegalArgumentException("Graphics contextt not PrintGraphics");
        }
        if (IJ.isMacintosh()) {
            n4 = 0;
            n5 = 0;
            n6 = 0;
        }
        StringReader stringReader = new StringReader(string);
        LineNumberReader lineNumberReader = new LineNumberReader(stringReader);
        int n7 = printJob.getPageDimension().height - n6;
        Font font = new Font(this.getFontName(), 0, 10);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n8 = fontMetrics.getHeight();
        int n9 = fontMetrics.getDescent();
        int n10 = n4;
        try {
            String string2;
            do {
                if ((string2 = lineNumberReader.readLine()) == null) continue;
                string2 = this.detabLine(string2);
                if (n10 + n8 > n7) {
                    ++n;
                    n2 = 0;
                    graphics.dispose();
                    graphics = printJob.getGraphics();
                    if (graphics != null) {
                        graphics.setFont(font);
                    }
                    n10 = n4;
                }
                n10 += n8;
                if (graphics == null) continue;
                graphics.drawString(string2, n5, n10 - n9);
                ++n2;
                ++n3;
            } while (string2 != null);
        }
        catch (EOFException eOFException) {
        }
        catch (Throwable throwable) {
            IJ.handleException(throwable);
        }
    }

    String detabLine(String string) {
        if (string.indexOf(9) < 0) {
            return string;
        }
        int n = 4;
        StringBuffer stringBuffer = new StringBuffer((int)((double)string.length() * 1.25));
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\t') {
                for (int j = 0; j < n; ++j) {
                    stringBuffer.append(' ');
                }
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    boolean copy() {
        String string = this.ta.getSelectedText();
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        if (clipboard != null) {
            StringSelection stringSelection = new StringSelection(string);
            clipboard.setContents(stringSelection, this);
            return true;
        }
        return false;
    }

    void cut() {
        if (this.copy()) {
            int n = this.ta.getSelectionStart();
            int n2 = this.ta.getSelectionEnd();
            this.ta.replaceRange("", n, n2);
            if (IJ.isMacOSX()) {
                this.ta.setCaretPosition(n);
            }
        }
    }

    void paste() {
        String string = this.ta.getSelectedText();
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(string);
        try {
            string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception exception) {
            string = exception.toString();
        }
        if (!this.fixedLineEndings && IJ.isWindows()) {
            this.fixLineEndings();
        }
        this.fixedLineEndings = true;
        int n = this.ta.getSelectionStart();
        int n2 = this.ta.getSelectionEnd();
        this.ta.replaceRange(string, n, n2);
        if (IJ.isMacOSX()) {
            this.ta.setCaretPosition(n + string.length());
        }
    }

    void copyToInfo() {
        int n;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.noImage();
            return;
        }
        int n2 = this.ta.getSelectionStart();
        String string = n2 == (n = this.ta.getSelectionEnd()) ? this.ta.getText() : this.ta.getSelectedText();
        imagePlus.setProperty("Info", string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        String string = actionEvent.getActionCommand();
        int n = actionEvent.getModifiers();
        boolean bl2 = bl = (n & 8) != 0;
        if (IJ.debugMode) {
            IJ.log("actionPerformed: " + actionEvent);
        }
        if ("Save".equals(string)) {
            this.save();
        } else if ("Compile and Run".equals(string)) {
            this.compileAndRun();
        } else if ("Run Macro".equals(string)) {
            if (bl) {
                this.enableDebugging();
                this.runMacro(true);
            } else {
                this.runMacro(false);
            }
        } else if ("Debug Macro".equals(string)) {
            this.enableDebugging();
            this.runMacro(true);
        } else if ("Step".equals(string)) {
            this.setDebugMode(1);
        } else if ("Trace".equals(string)) {
            this.setDebugMode(2);
        } else if ("Fast Trace".equals(string)) {
            this.setDebugMode(3);
        } else if ("Run".equals(string)) {
            this.setDebugMode(4);
        } else if ("Run to Insertion Point".equals(string)) {
            this.runToInsertionPoint();
        } else if ("Abort".equals(string) || "Abort Macro".equals(string)) {
            Interpreter.abort();
            IJ.beep();
        } else if ("Evaluate Line".equals(string)) {
            this.evaluateLine();
        } else if ("Install Macros".equals(string)) {
            this.installMacros(this.ta.getText(), true);
        } else if ("Function Finder...".equals(string)) {
            new FunctionFinder();
        } else if ("Evaluate JavaScript".equals(string)) {
            this.evaluateJavaScript();
        } else if ("Print...".equals(string)) {
            this.print();
        } else if (string.equals("Paste")) {
            this.paste();
        } else if (string.equals("Copy")) {
            this.copy();
        } else if (string.equals("Cut")) {
            this.cut();
        } else if ("Save As...".equals(string)) {
            this.saveAs();
        } else if ("Select All".equals(string)) {
            this.selectAll();
        } else if ("Find...".equals(string)) {
            this.find(null);
        } else if ("Find Next".equals(string)) {
            this.find(searchString);
        } else if ("Go to Line...".equals(string)) {
            this.gotoLine();
        } else if ("Zap Gremlins".equals(string)) {
            this.zapGremlins();
        } else if ("Make Text Larger".equals(string)) {
            this.changeFontSize(true);
        } else if ("Make Text Smaller".equals(string)) {
            this.changeFontSize(false);
        } else if ("Save Settings".equals(string)) {
            this.saveSettings();
        } else if ("New...".equals(string)) {
            IJ.run("Text Window");
        } else if ("Open...".equals(string)) {
            IJ.open();
        } else if (string.equals("Copy to Image Info")) {
            this.copyToInfo();
        } else if (bl) {
            this.enableDebugging();
            this.installer.runMacro(string, this);
        } else {
            this.installer.runMacro(string, null);
        }
    }

    final void runToInsertionPoint() {
        Interpreter interpreter = Interpreter.getInstance();
        if (interpreter == null) {
            IJ.beep();
        } else {
            this.runToLine = this.getCurrentLine();
            this.setDebugMode(5);
        }
    }

    final int getCurrentLine() {
        int n = this.ta.getCaretPosition();
        int n2 = 0;
        String string = this.ta.getText();
        if (IJ.isWindows() && !IJ.isVista()) {
            string = string.replaceAll("\r\n", "\n");
        }
        char[] cArray = new char[string.length()];
        cArray = string.toCharArray();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = cArray.length;
        for (int i = 0; i < n6; ++i) {
            if (cArray[i] != '\n') continue;
            ++n3;
            n4 = n5;
            n5 = i;
            if (n < n4 || n >= n5) continue;
            n2 = n3;
            break;
        }
        if (n2 == 0 && n > n5) {
            n2 = n3;
        }
        return n2;
    }

    final void enableDebugging() {
        this.step = true;
        Interpreter interpreter = Interpreter.getInstance();
        if (interpreter != null && interpreter.getEditor() == this) {
            interpreter.abort();
            IJ.wait(100);
        }
        int n = this.ta.getSelectionStart();
        int n2 = this.ta.getSelectionEnd();
        if (n == this.debugStart && n2 == this.debugEnd) {
            this.ta.select(n, n);
        }
    }

    final void setDebugMode(int n) {
        this.step = true;
        Interpreter interpreter = Interpreter.getInstance();
        if (interpreter != null) {
            interpreter.setEditor(this);
            interpreter.setDebugMode(n);
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        if (this.isMacroWindow) {
            return;
        }
        ++this.eventCount;
        if (this.eventCount > 2 || !IJ.isMacOSX() && this.eventCount > 1) {
            this.changes = true;
        }
        if (IJ.isMacOSX()) {
            this.ta.setCaretPosition(this.ta.getCaretPosition());
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        CheckboxMenuItem checkboxMenuItem = (CheckboxMenuItem)itemEvent.getSource();
        this.setFont();
    }

    public void windowActivated(WindowEvent windowEvent) {
        WindowManager.setWindow(this);
        instance = this;
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.close();
    }

    public void close() {
        boolean bl = true;
        ImageJ imageJ = IJ.getInstance();
        if (!this.getTitle().equals("Errors") && this.changes && !IJ.isMacro() && imageJ != null && !imageJ.quitting()) {
            String string = "Save changes to \"" + this.getTitle() + "\"?";
            YesNoCancelDialog yesNoCancelDialog = new YesNoCancelDialog((Frame)this, "Editor", string);
            if (yesNoCancelDialog.cancelPressed()) {
                bl = false;
            } else if (yesNoCancelDialog.yesPressed()) {
                this.save();
            }
        }
        if (bl) {
            this.setVisible(false);
            this.dispose();
            WindowManager.removeWindow(this);
            --nWindows;
            instance = null;
        }
    }

    public void saveAs() {
        String string = this.getTitle();
        if (string.indexOf(".") == -1) {
            string = string + ".txt";
        }
        if (defaultDir == null) {
            defaultDir = string.endsWith(".txt") || string.endsWith(".ijm") ? Menus.getMacrosPath() : Menus.getPlugInsPath();
        }
        SaveDialog saveDialog = new SaveDialog("Save As...", defaultDir, string, null);
        String string2 = saveDialog.getFileName();
        String string3 = saveDialog.getDirectory();
        if (string2 != null) {
            if (string2.endsWith(".java")) {
                this.updateClassName(string, string2);
            }
            this.path = string3 + string2;
            this.save();
            this.changes = false;
            this.setWindowTitle(string2);
            if (Recorder.record) {
                Recorder.record("saveAs", "Text", this.path);
            }
        }
    }

    public void updateClassName(String string, String string2) {
        if (string2.indexOf("_") < 0) {
            IJ.showMessage("Plugin Editor", "Plugins without an underscore in their name will not\nbe automatically installed when ImageJ is restarted.");
        }
        if (string.equals(string2) || !string.endsWith(".java") || !string2.endsWith(".java")) {
            return;
        }
        string = string.substring(0, string.length() - 5);
        string2 = string2.substring(0, string2.length() - 5);
        String string3 = this.ta.getText();
        int n = string3.indexOf("public class " + string);
        if (n < 0) {
            return;
        }
        String string4 = string3.substring(0, n + 13) + string2 + string3.substring(n + 13 + string.length(), string3.length());
        this.ta.setText(string4);
    }

    void find(String object) {
        String[] stringArray;
        Object object2;
        if (object == null) {
            object2 = new GenericDialog("Find", this);
            ((GenericDialog)object2).addStringField("Find: ", searchString, 20);
            stringArray = new String[]{"Case Sensitive", "Whole Words"};
            boolean[] blArray = new boolean[]{caseSensitive, wholeWords};
            ((GenericDialog)object2).addCheckboxGroup(1, 2, stringArray, blArray);
            ((GenericDialog)object2).showDialog();
            if (((GenericDialog)object2).wasCanceled()) {
                return;
            }
            object = ((GenericDialog)object2).getNextString();
            caseSensitive = ((GenericDialog)object2).getNextBoolean();
            wholeWords = ((GenericDialog)object2).getNextBoolean();
            Prefs.set(CASE_SENSITIVE, caseSensitive);
        }
        if (object.equals("")) {
            return;
        }
        object2 = this.ta.getText();
        stringArray = object;
        if (!caseSensitive) {
            object2 = ((String)object2).toLowerCase(Locale.US);
            object = object.toLowerCase(Locale.US);
        }
        int n = -1;
        if (wholeWords) {
            int n2 = this.ta.getCaretPosition() + 1;
            while ((n = ((String)object2).indexOf((String)object, n2)) != -1 && !this.isWholeWordMatch((String)object2, (String)object, n)) {
                n2 = n + 1;
                if (n2 < ((String)object2).length() - 1) continue;
                n = -1;
                break;
            }
        } else {
            n = ((String)object2).indexOf((String)object, this.ta.getCaretPosition() + 1);
        }
        searchString = stringArray;
        if (n < 0) {
            IJ.beep();
            return;
        }
        this.ta.setSelectionStart(n);
        this.ta.setSelectionEnd(n + object.length());
    }

    boolean isWholeWordMatch(String string, String string2, int n) {
        char c;
        char c2 = c = n == 0 ? (char)' ' : string.charAt(n - 1);
        if (Character.isLetterOrDigit(c) || c == '_') {
            return false;
        }
        char c3 = c = n + string2.length() >= string.length() ? (char)' ' : string.charAt(n + string2.length());
        return !Character.isLetterOrDigit(c) && c != 95;
    }

    void gotoLine() {
        GenericDialog genericDialog = new GenericDialog("Go to Line", this);
        genericDialog.addNumericField("Go to line number: ", lineNumber, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        int n = (int)genericDialog.getNextNumber();
        if (n < 1) {
            return;
        }
        String string = this.ta.getText();
        char[] cArray = new char[string.length()];
        cArray = string.toCharArray();
        int n2 = 1;
        int n3 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\n') {
                ++n2;
            }
            if (n2 != n) continue;
            n3 = i + 1;
            break;
        }
        this.ta.setCaretPosition(n3);
        lineNumber = n;
    }

    void zapGremlins() {
        String string = this.ta.getText();
        char[] cArray = new char[string.length()];
        cArray = string.toCharArray();
        int n = 0;
        boolean bl = false;
        char c = '\u0000';
        for (int i = 0; i < cArray.length; ++i) {
            char c2 = cArray[i];
            if (!(bl || c2 != '\"' && c2 != '\'')) {
                bl = true;
                c = c2;
            } else if (bl && (c2 == c || c2 == '\n')) {
                bl = false;
            }
            if (bl || c2 == '\n' || c2 == '\t' || c2 >= ' ' && c2 <= '\u007f') continue;
            ++n;
            cArray[i] = 32;
        }
        if (n > 0) {
            string = new String(cArray);
            this.ta.setText(string);
        }
        if (n > 0) {
            IJ.showMessage("Zap Gremlins", n + " invalid characters converted to spaces");
        } else {
            IJ.showMessage("Zap Gremlins", "No invalid characters found");
        }
    }

    void selectAll() {
        this.ta.selectAll();
    }

    void changeFontSize(boolean bl) {
        int n = this.fontSize++;
        if (bl) {
            if (this.fontSize == this.sizes.length) {
                this.fontSize = this.sizes.length - 1;
            }
        } else {
            --this.fontSize;
            if (this.fontSize < 0) {
                this.fontSize = 0;
            }
        }
        IJ.showStatus(this.sizes[this.fontSize] + " point");
        this.setFont();
    }

    void saveSettings() {
        Prefs.set(FONT_SIZE, this.fontSize);
        Prefs.set(FONT_MONO, this.monospaced.getState());
        IJ.showStatus("Font settings saved (size=" + this.sizes[this.fontSize] + ", monospaced=" + this.monospaced.getState() + ")");
    }

    void setFont() {
        this.ta.setFont(new Font(this.getFontName(), 0, this.sizes[this.fontSize]));
    }

    String getFontName() {
        return this.monospaced.getState() ? "Monospaced" : "SansSerif";
    }

    public void setFont(Font font) {
        this.ta.setFont(font);
    }

    public void append(String string) {
        this.ta.append(string);
    }

    public void setIsMacroWindow(boolean bl) {
        this.isMacroWindow = bl;
    }

    public static void setDefaultDirectory(String string) {
        defaultDir = string;
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public int debug(Interpreter interpreter, int n) {
        int n2;
        int n3;
        if (IJ.debugMode) {
            IJ.log("debug: " + interpreter.getLineNumber() + "  " + n + "  " + interpreter);
        }
        if (n == 4) {
            return 0;
        }
        if (!this.isVisible()) {
            interpreter.abortMacro();
            return 0;
        }
        if (!this.isActive()) {
            this.toFront();
        }
        if ((n3 = interpreter.getLineNumber()) == this.previousLine) {
            this.previousLine = 0;
            return 0;
        }
        this.previousLine = n3;
        if (n == 5) {
            if (n3 == this.runToLine) {
                n = 1;
                interpreter.setDebugMode(n);
            } else {
                return 0;
            }
        }
        String string = this.ta.getText();
        if (IJ.isWindows() && !IJ.isVista()) {
            string = string.replaceAll("\r\n", "\n");
        }
        char[] cArray = new char[string.length()];
        cArray = string.toCharArray();
        int n4 = 1;
        this.debugStart = 0;
        this.debugEnd = n2 = cArray.length;
        for (int i = 0; i < n2; ++i) {
            if (cArray[i] == '\n') {
                ++n4;
            }
            if (n4 == n3 && this.debugStart == 0) {
                this.debugStart = i + 1;
                continue;
            }
            if (n4 != n3 + 1) continue;
            this.debugEnd = i;
            break;
        }
        if (this.debugStart == 1) {
            this.debugStart = 0;
        }
        if ((this.debugStart == 0 || this.debugStart == n2) && this.debugEnd == n2) {
            return 0;
        }
        this.ta.select(this.debugStart, this.debugEnd);
        if (debugWindow != null && !debugWindow.isShowing()) {
            interpreter.setEditor(null);
            debugWindow = null;
        } else {
            debugWindow = interpreter.updateDebugWindow(interpreter.getVariables(), debugWindow);
        }
        if (n == 1) {
            this.step = false;
            while (!this.step && !interpreter.done() && this.isVisible()) {
                IJ.wait(5);
            }
        } else if (n == 3) {
            IJ.wait(5);
        } else {
            IJ.wait(150);
        }
        return 0;
    }

    public static Editor getInstance() {
        return instance;
    }

    public static String getJSPrefix(String string) {
        return JavaScriptIncludes + "function getArgument() {return \"" + string + "\";};";
    }

    public void fixLineEndings() {
        String string = this.ta.getText();
        string = string.replaceAll("\r\n", "\n");
        string = string.replaceAll("\r", "\n");
        this.ta.setText(string);
    }
}

