/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public class Zoom
implements PlugIn {
    public void run(String string) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.noImage();
            return;
        }
        ImageCanvas imageCanvas = imagePlus.getCanvas();
        if (imageCanvas == null) {
            return;
        }
        Point point = imageCanvas.getCursorLoc();
        if (!imageCanvas.cursorOverImage()) {
            point.x = imagePlus.getWidth() / 2;
            point.y = imagePlus.getHeight() / 2;
        }
        int n = imageCanvas.screenX(point.x);
        int n2 = imageCanvas.screenY(point.y);
        if (string.equals("in")) {
            imageCanvas.zoomIn(n, n2);
            if (imageCanvas.getMagnification() <= 1.0) {
                imagePlus.repaintWindow();
            }
        } else if (string.equals("out")) {
            imageCanvas.zoomOut(n, n2);
            if (imageCanvas.getMagnification() < 1.0) {
                imagePlus.repaintWindow();
            }
        } else if (string.equals("orig")) {
            imageCanvas.unzoom();
        } else if (string.equals("100%")) {
            imageCanvas.zoom100Percent();
        } else if (string.equals("to")) {
            this.zoomToSelection(imagePlus, imageCanvas);
        } else if (string.equals("set")) {
            this.setZoom(imagePlus, imageCanvas);
        } else if (string.equals("max")) {
            ImageWindow imageWindow = imagePlus.getWindow();
            imageWindow.setBounds(imageWindow.getMaximumBounds());
            imageWindow.maximize();
        }
    }

    void zoomToSelection(ImagePlus imagePlus, ImageCanvas imageCanvas) {
        Roi roi = imagePlus.getRoi();
        imageCanvas.unzoom();
        if (roi == null) {
            return;
        }
        Rectangle rectangle = imagePlus.getWindow().getBounds();
        Rectangle rectangle2 = roi.getBounds();
        double d = imageCanvas.getMagnification();
        int n = (int)((double)rectangle.width - d * (double)imagePlus.getWidth());
        int n2 = (int)((double)rectangle.height - d * (double)imagePlus.getHeight());
        int n3 = rectangle2.x + rectangle2.width / 2;
        int n4 = rectangle2.y + rectangle2.height / 2;
        d = ImageCanvas.getHigherZoomLevel(d);
        while ((double)rectangle2.width * d < (double)(rectangle.width - n) && (double)rectangle2.height * d < (double)(rectangle.height - n2)) {
            imageCanvas.zoomIn(imageCanvas.screenX(n3), imageCanvas.screenY(n4));
            double d2 = imageCanvas.getMagnification();
            if (d2 == 32.0) break;
            d = ImageCanvas.getHigherZoomLevel(d2);
            rectangle = imagePlus.getWindow().getBounds();
        }
    }

    void setZoom(ImagePlus imagePlus, ImageCanvas imageCanvas) {
        ImageWindow imageWindow = imagePlus.getWindow();
        GenericDialog genericDialog = new GenericDialog("Set Zoom");
        genericDialog.addNumericField("Zoom (%): ", imageCanvas.getMagnification() * 200.0, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        double d = genericDialog.getNextNumber() / 100.0;
        if (d <= 0.0) {
            d = 1.0;
        }
        imageWindow.getCanvas().setMagnification(d);
        double d2 = (double)imagePlus.getWidth() * d;
        double d3 = (double)imagePlus.getHeight() * d;
        Dimension dimension = IJ.getScreenSize();
        if (d2 > (double)(dimension.width - 20)) {
            d2 = dimension.width - 20;
        }
        if (d3 > (double)(dimension.height - 50)) {
            d3 = dimension.height - 50;
        }
        imageCanvas.setSourceRect(new Rectangle(0, 0, (int)(d2 / d), (int)(d3 / d)));
        imageCanvas.setDrawingSize((int)d2, (int)d3);
        imageWindow.pack();
        imageCanvas.repaint();
    }
}

