/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Toolbar;
import ij.measure.Measurements;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import java.awt.Color;

public class Thresholder
implements PlugIn,
Measurements {
    private double minThreshold;
    private double maxThreshold;
    boolean autoThreshold;
    boolean skipDialog;
    static boolean fill1 = true;
    static boolean fill2 = true;
    static boolean useBW = true;
    static boolean useLocal = true;
    boolean convertToMask;

    public void run(String string) {
        this.convertToMask = string.equals("mask");
        this.skipDialog = string.equals("skip") || this.convertToMask;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.noImage();
            return;
        }
        if (imagePlus.getStackSize() == 1) {
            Undo.setup(4, imagePlus);
            this.applyThreshold(imagePlus);
            Undo.setup(5, imagePlus);
        } else {
            this.convertStack(imagePlus);
        }
    }

    void convertStack(ImagePlus imagePlus) {
        if (imagePlus.getProcessor().getMinThreshold() != -808080.0) {
            useLocal = false;
        }
        GenericDialog genericDialog = new GenericDialog("Convert to Mask");
        genericDialog.addMessage("Convert all images in stack to binary?");
        genericDialog.addCheckbox("Calculate Threshold for Each Image", useLocal);
        genericDialog.addCheckbox("Black Background", Prefs.blackBackground);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        useLocal = genericDialog.getNextBoolean();
        Prefs.blackBackground = genericDialog.getNextBoolean();
        Undo.reset();
        if (useLocal) {
            this.convertStackToBinary(imagePlus);
        } else {
            this.applyThreshold(imagePlus);
        }
    }

    void applyThreshold(ImagePlus imagePlus) {
        imagePlus.killRoi();
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        imageProcessor.resetBinaryThreshold();
        int n = imagePlus.getType();
        if (n == 1 || n == 2) {
            this.applyShortOrFloatThreshold(imagePlus);
            return;
        }
        if (!imagePlus.lock()) {
            return;
        }
        double d = imageProcessor.getMinThreshold();
        double d2 = imageProcessor.getMaxThreshold();
        this.autoThreshold = d == -808080.0;
        boolean bl = true;
        if (this.skipDialog) {
            bl = true;
            fill2 = true;
            fill1 = true;
        } else if (!this.autoThreshold) {
            GenericDialog genericDialog = new GenericDialog("Make Binary");
            genericDialog.addCheckbox("Thresholded pixels to foreground color", fill1);
            genericDialog.addCheckbox("Remaining pixels to background color", fill2);
            genericDialog.addMessage("");
            genericDialog.addCheckbox("Black foreground, white background", useBW);
            genericDialog.showDialog();
            if (genericDialog.wasCanceled()) {
                imagePlus.unlock();
                return;
            }
            fill1 = genericDialog.getNextBoolean();
            fill2 = genericDialog.getNextBoolean();
            useBW = bl = genericDialog.getNextBoolean();
        } else {
            fill2 = true;
            fill1 = true;
            this.convertToMask = true;
        }
        if (n != 0) {
            this.convertToByte(imagePlus);
        }
        imageProcessor = imagePlus.getProcessor();
        if (this.autoThreshold) {
            this.autoThreshold(imageProcessor);
        } else {
            if (Recorder.record && !Recorder.scriptMode() && (!IJ.isMacro() || Recorder.recordInMacros)) {
                Recorder.record("setThreshold", (int)d, (int)d2);
            }
            this.minThreshold = d;
            this.maxThreshold = d2;
        }
        if (this.convertToMask && imageProcessor.isColorLut()) {
            imageProcessor.setColorModel(imageProcessor.getDefaultColorModel());
        }
        imageProcessor.resetThreshold();
        int n2 = imageProcessor.getPixel(0, 0);
        if (bl) {
            imageProcessor.setColor(Color.black);
        } else {
            imageProcessor.setColor(Toolbar.getForegroundColor());
        }
        imageProcessor.drawPixel(0, 0);
        int n3 = imageProcessor.getPixel(0, 0);
        if (bl) {
            imageProcessor.setColor(Color.white);
        } else {
            imageProcessor.setColor(Toolbar.getBackgroundColor());
        }
        imageProcessor.drawPixel(0, 0);
        int n4 = imageProcessor.getPixel(0, 0);
        imageProcessor.setColor(Toolbar.getForegroundColor());
        imageProcessor.putPixel(0, 0, n2);
        int[] nArray = new int[256];
        for (int i = 0; i < 256; ++i) {
            nArray[i] = (double)i >= this.minThreshold && (double)i <= this.maxThreshold ? (int)((byte)(fill1 ? n3 : (byte)i)) : (int)((byte)(fill2 ? n4 : (byte)i));
        }
        if (imagePlus.getStackSize() > 1) {
            new StackProcessor(imagePlus.getStack(), imageProcessor).applyTable(nArray);
        } else {
            imageProcessor.applyTable(nArray);
        }
        if (this.convertToMask) {
            if (!imagePlus.isInvertedLut()) {
                this.setInvertedLut(imagePlus);
                n3 = 255 - n3;
                n4 = 255 - n4;
            }
            if (Prefs.blackBackground) {
                imageProcessor.invertLut();
            }
        }
        if (fill1 && fill2 && (n3 == 0 && n4 == 255 || n3 == 255 && n4 == 0)) {
            imagePlus.getProcessor().setThreshold(n3, n3, 2);
        }
        imagePlus.updateAndRepaintWindow();
        imagePlus.unlock();
    }

    void applyShortOrFloatThreshold(ImagePlus imagePlus) {
        Object object;
        if (!imagePlus.lock()) {
            return;
        }
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        int n3 = n * n2;
        boolean bl = imagePlus.getType() == 2;
        int n4 = imagePlus.getStackSize();
        ImageStack imageStack = imagePlus.getStack();
        ImageStack imageStack2 = new ImageStack(n, n2);
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        float f = (float)imageProcessor.getMinThreshold();
        float f2 = (float)imageProcessor.getMaxThreshold();
        if ((double)f == -808080.0) {
            double d = imageProcessor.getMin();
            double d2 = imageProcessor.getMax();
            imageProcessor = imageProcessor.convertToByte(true);
            this.autoThreshold(imageProcessor);
            f = (float)(d + (d2 - d) * (this.minThreshold / 255.0));
            f2 = (float)(d + (d2 - d) * (this.maxThreshold / 255.0));
        }
        IJ.showStatus("Converting to mask");
        for (int i = 1; i <= n4; ++i) {
            IJ.showProgress(i, n4);
            object = imageStack.getSliceLabel(i);
            ImageProcessor imageProcessor2 = imageStack.getProcessor(i);
            ByteProcessor byteProcessor = new ByteProcessor(n, n2);
            for (int j = 0; j < n3; ++j) {
                float f3 = imageProcessor2.getf(j);
                if (f3 >= f && f3 <= f2) {
                    ((ImageProcessor)byteProcessor).set(j, 255);
                    continue;
                }
                ((ImageProcessor)byteProcessor).set(j, 0);
            }
            imageStack2.addSlice((String)object, byteProcessor);
        }
        imagePlus.setStack(null, imageStack2);
        ImageStack imageStack3 = imagePlus.getStack();
        imageStack3.setColorModel(LookUpTable.createGrayscaleColorModel(!Prefs.blackBackground));
        imagePlus.setStack(null, imageStack3);
        if (imagePlus.isComposite()) {
            object = (CompositeImage)imagePlus;
            ((CompositeImage)object).setMode(3);
            ((CompositeImage)object).resetDisplayRanges();
            ((CompositeImage)object).updateAndDraw();
        }
        imagePlus.getProcessor().setThreshold(255.0, 255.0, 2);
        IJ.showStatus("");
        imagePlus.unlock();
    }

    void convertStackToBinary(ImagePlus imagePlus) {
        Object object;
        ImageStack imageStack;
        int n = imagePlus.getStackSize();
        if (imagePlus.getBitDepth() != 8) {
            IJ.showStatus("Converting to byte");
            imageStack = imagePlus.getStack();
            ImageStack imageStack2 = new ImageStack(imagePlus.getWidth(), imagePlus.getHeight());
            for (int i = 1; i <= n; ++i) {
                IJ.showProgress(i, n);
                object = imageStack.getSliceLabel(i);
                ImageProcessor imageProcessor = imageStack.getProcessor(i);
                imageProcessor.resetMinAndMax();
                imageStack2.addSlice((String)object, imageProcessor.convertToByte(true));
            }
            imagePlus.setStack(null, imageStack2);
        }
        imageStack = imagePlus.getStack();
        IJ.showStatus("Auto-thresholding");
        for (int i = 1; i <= n; ++i) {
            IJ.showProgress(i, n);
            ImageProcessor imageProcessor = imageStack.getProcessor(i);
            this.autoThreshold(imageProcessor);
            object = new int[256];
            for (int j = 0; j < 256; ++j) {
                object[j] = (double)j >= this.minThreshold && (double)j <= this.maxThreshold ? -1 : 0;
            }
            imageProcessor.applyTable((int[])object);
        }
        imageStack.setColorModel(LookUpTable.createGrayscaleColorModel(!Prefs.blackBackground));
        imagePlus.setStack(null, imageStack);
        imagePlus.getProcessor().setThreshold(255.0, 255.0, 2);
        if (imagePlus.isComposite()) {
            CompositeImage compositeImage = (CompositeImage)imagePlus;
            compositeImage.setMode(3);
            compositeImage.resetDisplayRanges();
            compositeImage.updateAndDraw();
        }
        IJ.showStatus("");
    }

    void convertToByte(ImagePlus imagePlus) {
        int n = imagePlus.getCurrentSlice();
        ImageStack imageStack = imagePlus.getStack();
        ImageStack imageStack2 = imagePlus.createEmptyStack();
        int n2 = imagePlus.getStackSize();
        for (int i = 1; i <= n2; ++i) {
            String string = imageStack.getSliceLabel(i);
            ImageProcessor imageProcessor = imageStack.getProcessor(i);
            imageProcessor.setMinAndMax(0.0, 255.0);
            imageStack2.addSlice(string, imageProcessor.convertToByte(true));
        }
        imagePlus.setStack(null, imageStack2);
        imagePlus.setSlice(n);
        imagePlus.setCalibration(imagePlus.getCalibration());
    }

    void setInvertedLut(ImagePlus imagePlus) {
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        imageProcessor.invertLut();
        int n = imagePlus.getStackSize();
        if (n == 1) {
            imageProcessor.invert();
        } else {
            ImageStack imageStack = imagePlus.getStack();
            for (int i = 1; i <= n; ++i) {
                imageStack.getProcessor(i).invert();
            }
            imageStack.setColorModel(imageProcessor.getColorModel());
        }
    }

    void autoThreshold(ImageProcessor imageProcessor) {
        imageProcessor.setAutoThreshold(1, 2);
        this.minThreshold = imageProcessor.getMinThreshold();
        this.maxThreshold = imageProcessor.getMaxThreshold();
    }
}

