/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.plugin.PlugIn;
import ij.text.TextWindow;
import java.io.CharArrayWriter;
import java.io.PrintWriter;

public class ThreadLister
implements PlugIn {
    public void run(String string) {
        if (IJ.getApplet() != null) {
            return;
        }
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        try {
            ThreadLister.listAllThreads(printWriter);
            new TextWindow("Threads", charArrayWriter.toString(), 420, 420);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void print_thread_info(PrintWriter printWriter, Thread thread, String string) {
        if (thread == null) {
            return;
        }
        printWriter.print(string + "Thread: " + thread.getName() + "  Priority: " + thread.getPriority() + (thread.isDaemon() ? " Daemon" : "") + (thread.isAlive() ? "" : " Not Alive") + "\n");
    }

    private static void list_group(PrintWriter printWriter, ThreadGroup threadGroup, String string) {
        int n;
        if (threadGroup == null) {
            return;
        }
        int n2 = threadGroup.activeCount();
        int n3 = threadGroup.activeGroupCount();
        Thread[] threadArray = new Thread[n2];
        ThreadGroup[] threadGroupArray = new ThreadGroup[n3];
        threadGroup.enumerate(threadArray, false);
        threadGroup.enumerate(threadGroupArray, false);
        printWriter.println(string + "Thread Group: " + threadGroup.getName() + "  Max Priority: " + threadGroup.getMaxPriority() + (threadGroup.isDaemon() ? " Daemon" : "") + "\n");
        for (n = 0; n < n2; ++n) {
            ThreadLister.print_thread_info(printWriter, threadArray[n], string + "    ");
        }
        for (n = 0; n < n3; ++n) {
            ThreadLister.list_group(printWriter, threadGroupArray[n], string + "    ");
        }
    }

    public static void listAllThreads(PrintWriter printWriter) {
        ThreadGroup threadGroup;
        ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
        for (ThreadGroup threadGroup3 = threadGroup2.getParent(); threadGroup3 != null; threadGroup3 = threadGroup3.getParent()) {
            threadGroup2 = threadGroup3;
        }
        ThreadLister.list_group(printWriter, threadGroup2, "");
    }
}

