/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;

public class SubstackMaker
implements PlugIn {
    public void run(String string) {
        ImagePlus imagePlus = IJ.getImage();
        if (imagePlus.isHyperStack() || imagePlus.isComposite()) {
            IJ.error("Make Substack", "This command does not currently work with hyperstacks.");
            return;
        }
        String string2 = this.showDialog();
        if (string2 == null) {
            return;
        }
        ImagePlus imagePlus2 = this.makeSubstack(imagePlus, string2);
        if (imagePlus2 != null) {
            imagePlus2.show();
        }
    }

    public ImagePlus makeSubstack(ImagePlus imagePlus, String string) {
        String string2;
        String string3;
        int n;
        String string4 = "Substack (" + string + ")";
        if (string4.length() > 25) {
            int n2 = string4.indexOf(",", 18);
            n = string4.lastIndexOf(",");
            if (n2 >= 1 && n >= 1) {
                string3 = string4.substring(0, n2);
                string2 = string4.substring(n + 1);
                string4 = string3 + ", ... " + string2;
            }
        }
        ImagePlus imagePlus2 = null;
        try {
            n = string.indexOf("-");
            if (n >= 1) {
                string3 = string.substring(0, n);
                string2 = string.substring(n + 1);
                Integer n3 = new Integer(string3);
                int n4 = n3;
                int n5 = 1;
                int n6 = string2.indexOf("-");
                if (n6 >= 1) {
                    String string5 = string2;
                    string2 = string5.substring(0, n6);
                    String string6 = string5.substring(n6 + 1);
                    n3 = new Integer(string6);
                    n5 = n3;
                }
                n3 = new Integer(string2);
                int n7 = n3;
                imagePlus2 = this.stackRange(imagePlus, n4, n7, n5, string4);
            } else {
                int n8;
                int n9 = 1;
                for (int i = 0; i < string.length(); ++i) {
                    n8 = Character.toLowerCase(string.charAt(i));
                    if (n8 != 44) continue;
                    ++n9;
                }
                int[] nArray = new int[n9];
                for (n8 = 0; n8 < n9; ++n8) {
                    Integer n10;
                    String string7;
                    int n11 = string.indexOf(",");
                    if (n11 > 0) {
                        string7 = string.substring(0, n11);
                        n10 = new Integer(string7);
                        nArray[n8] = n10;
                        string = string.substring(n11 + 1);
                        continue;
                    }
                    string7 = string;
                    n10 = new Integer(string7);
                    nArray[n8] = n10;
                }
                imagePlus2 = this.stackList(imagePlus, n9, nArray, string4);
            }
        }
        catch (Exception exception) {
            IJ.error("Substack Maker", "Invalid input string:        \n \n  \"" + string + "\"");
        }
        return imagePlus2;
    }

    String showDialog() {
        GenericDialog genericDialog = new GenericDialog("Substack Maker");
        genericDialog.setInsets(10, 45, 0);
        genericDialog.addMessage("Enter a range (e.g. 2-14), a range with increment\n(e.g. 1-100-2) or a list (e.g. 7,9,25,27)");
        genericDialog.addStringField("Slices:", "", 40);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return null;
        }
        return genericDialog.getNextString();
    }

    ImagePlus stackList(ImagePlus imagePlus, int n, int[] nArray, String string) throws Exception {
        ImageStack imageStack = imagePlus.getStack();
        ImageStack imageStack2 = null;
        Roi roi = imagePlus.getRoi();
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            ImageProcessor imageProcessor = imageStack.getProcessor(n2);
            imageProcessor.setRoi(roi);
            imageProcessor = imageProcessor.crop();
            if (imageStack2 == null) {
                imageStack2 = new ImageStack(imageProcessor.getWidth(), imageProcessor.getHeight());
            }
            imageStack2.addSlice(imageStack.getSliceLabel(n2), imageProcessor);
        }
        ImagePlus imagePlus2 = imagePlus.createImagePlus();
        imagePlus2.setStack(string, imageStack2);
        imagePlus2.setCalibration(imagePlus.getCalibration());
        return imagePlus2;
    }

    ImagePlus stackRange(ImagePlus imagePlus, int n, int n2, int n3, String string) throws Exception {
        int n4 = imagePlus.getWidth();
        ImageStack imageStack = imagePlus.getStack();
        ImageStack imageStack2 = null;
        Roi roi = imagePlus.getRoi();
        for (int i = n; i <= n2; i += n3) {
            ImageProcessor imageProcessor = imageStack.getProcessor(i);
            imageProcessor.setRoi(roi);
            imageProcessor = imageProcessor.crop();
            if (imageStack2 == null) {
                imageStack2 = new ImageStack(imageProcessor.getWidth(), imageProcessor.getHeight());
            }
            imageStack2.addSlice(imageStack.getSliceLabel(i), imageProcessor);
        }
        ImagePlus imagePlus2 = imagePlus.createImagePlus();
        imagePlus2.setStack(string, imageStack2);
        imagePlus2.setCalibration(imagePlus.getCalibration());
        return imagePlus2;
    }
}

