/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Menus;
import ij.gui.Toolbar;
import ij.io.OpenDialog;
import ij.macro.Interpreter;
import ij.macro.MacroConstants;
import ij.macro.MacroRunner;
import ij.macro.Program;
import ij.macro.Symbol;
import ij.macro.Tokenizer;
import ij.plugin.PlugIn;
import ij.plugin.frame.Editor;
import ij.plugin.frame.Recorder;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class MacroInstaller
implements PlugIn,
MacroConstants,
ActionListener {
    public static final int MAX_SIZE = 28000;
    public static final int MAX_MACROS = 100;
    public static final int XINC = 10;
    public static final int YINC = 18;
    public static final char commandPrefix = '^';
    static final String commandPrefixS = "^";
    static final int MACROS_MENU_COMMANDS = 6;
    private int[] macroStarts;
    private String[] macroNames;
    private MenuBar mb = new MenuBar();
    private int nMacros;
    private Program pgm;
    private boolean firstEvent = true;
    private String shortcutsInUse;
    private int inUseCount;
    private int nShortcuts;
    private int toolCount;
    private String text;
    private String anonymousName;
    private Menu macrosMenu;
    private int autoRunCount;
    private int autoRunAndHideCount;
    private boolean openingStartupMacrosInEditor;
    private static String defaultDir;
    private static String fileName;
    private static MacroInstaller instance;
    private static MacroInstaller listener;

    public void run(String string) {
        if (string == null || string.equals("")) {
            string = this.showDialog();
        }
        if (string == null) {
            return;
        }
        this.openingStartupMacrosInEditor = string.indexOf("StartupMacros") != -1;
        String string2 = this.open(string);
        if (string2 != null) {
            String string3 = Interpreter.getAdditionalFunctions();
            if (string3 != null) {
                string2 = !string2.endsWith("\n") && !string3.startsWith("\n") ? string2 + "\n" + string3 : string2 + string3;
            }
            this.install(string2);
        }
    }

    void install() {
        String string;
        int n;
        int n2;
        Object object;
        if (this.text != null) {
            object = new Tokenizer();
            this.pgm = ((Tokenizer)object).tokenize(this.text);
        }
        IJ.showStatus("");
        object = this.pgm.getCode();
        Symbol[] symbolArray = this.pgm.getSymbolTable();
        int n3 = 0;
        this.shortcutsInUse = null;
        this.inUseCount = 0;
        this.nShortcuts = 0;
        this.toolCount = 0;
        this.macroStarts = new int[100];
        this.macroNames = new String[100];
        int n4 = this.macrosMenu.getItemCount();
        boolean bl = this.macrosMenu == Menus.getMacrosMenu();
        int n5 = n2 = bl ? 6 : 8;
        if (n4 > n2) {
            for (n = n4 - 1; n >= n2; --n) {
                this.macrosMenu.remove(n);
            }
        }
        if (this.pgm.hasVars() && this.pgm.macroCount() > 0 && this.pgm.getGlobals() == null) {
            new Interpreter().saveGlobals(this.pgm);
        }
        for (n = 0; n < ((Object)object).length; ++n) {
            int n6 = object[n] & 0xFFF;
            if (n6 == 200) {
                int n7 = object[n + 1] & 0xFFF;
                if (n7 != 133) continue;
                if (n3 == 100) {
                    if (!bl) break;
                    IJ.error("Macro Installer", "Macro sets are limited to 100 macros.");
                    break;
                }
                reference var6_13 = object[n + 1] >> 12;
                Symbol symbol = symbolArray[var6_13];
                String string2 = symbol.str;
                this.macroStarts[n3] = n + 2;
                this.macroNames[n3] = string2;
                if (string2.indexOf(45) != -1 && (string2.indexOf("Tool") != -1 || string2.indexOf("tool") != -1)) {
                    Toolbar.getInstance().addMacroTool(string2, this, this.toolCount);
                    ++this.toolCount;
                } else if (string2.startsWith("AutoRun")) {
                    if (this.autoRunCount == 0 && !this.openingStartupMacrosInEditor) {
                        new MacroRunner(this.pgm, this.macroStarts[n3], string2, (String)null);
                        if (string2.equals("AutoRunAndHide")) {
                            ++this.autoRunAndHideCount;
                        }
                    }
                    ++this.autoRunCount;
                    --n3;
                } else if (string2.equals("Popup Menu")) {
                    this.installPopupMenu(string2, this.pgm);
                } else if (!string2.endsWith("Tool Selected")) {
                    this.addShortcut(string2);
                    this.macrosMenu.add(new MenuItem(string2));
                }
                ++n3;
                continue;
            }
            if (n6 == 128) break;
        }
        this.nMacros = n3;
        if (this.toolCount > 0) {
            Toolbar toolbar = Toolbar.getInstance();
            if (Toolbar.getToolId() >= 15) {
                toolbar.setTool(0);
            }
            toolbar.repaint();
        }
        instance = this;
        if (this.shortcutsInUse != null && this.text != null) {
            IJ.showMessage("Install Macros", (this.inUseCount == 1 ? "This keyboard shortcut is" : "These keyboard shortcuts are") + " already in use:" + this.shortcutsInUse);
        }
        if (this.nMacros == 0 && fileName != null) {
            if (this.text == null || this.text.length() == 0) {
                return;
            }
            int n8 = fileName.lastIndexOf(46);
            this.anonymousName = n8 > 0 ? fileName.substring(0, n8) : fileName;
            this.macrosMenu.add(new MenuItem(this.anonymousName));
            this.macroNames[0] = this.anonymousName;
            this.nMacros = 1;
        }
        String string2 = string = this.nMacros == 1 ? " macro" : " macros";
        if (bl) {
            IJ.showStatus(this.nMacros + string + " installed");
        }
    }

    public int install(String string) {
        if (string == null && this.pgm == null) {
            return 0;
        }
        this.text = string;
        this.macrosMenu = Menus.getMacrosMenu();
        if (listener != null) {
            this.macrosMenu.removeActionListener(listener);
        }
        this.macrosMenu.addActionListener(this);
        listener = this;
        this.install();
        return this.nShortcuts;
    }

    public int install(String string, Menu menu) {
        this.text = string;
        this.macrosMenu = menu;
        this.install();
        int n = this.nShortcuts + this.toolCount;
        if (n == 0 && this.nMacros > 1) {
            n = this.nMacros;
        }
        return n;
    }

    public void installFile(String string) {
        String string2;
        if (string != null && (string2 = this.open(string)) != null) {
            this.install(string2);
        }
    }

    public void installLibrary(String string) {
        String string2 = this.open(string);
        if (string2 != null) {
            Interpreter.setAdditionalFunctions(string2);
        }
    }

    public void installFromIJJar(String string) {
        String string2 = this.openFromIJJar(string);
        if (string2 != null) {
            this.install(string2);
        }
    }

    void installPopupMenu(String string, Program program) {
        Hashtable hashtable = program.getMenus();
        if (hashtable == null) {
            return;
        }
        String[] stringArray = (String[])hashtable.get(string);
        if (stringArray == null) {
            return;
        }
        PopupMenu popupMenu = Menus.getPopupMenu();
        if (popupMenu == null) {
            return;
        }
        popupMenu.removeAll();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-")) {
                popupMenu.addSeparator();
                continue;
            }
            MenuItem menuItem = new MenuItem(stringArray[i]);
            menuItem.addActionListener(this);
            popupMenu.add(menuItem);
        }
    }

    void removeShortcuts() {
        Menus.getMacroShortcuts().clear();
        Hashtable hashtable = Menus.getShortcuts();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            String string = (String)hashtable.get(n);
            if (string.charAt(0) != '^') continue;
            hashtable.remove(n);
        }
    }

    void addShortcut(String string) {
        int n = string.indexOf(91);
        if (n == -1) {
            return;
        }
        int n2 = string.lastIndexOf(93);
        if (n2 <= n + 1) {
            return;
        }
        String string2 = string.substring(n + 1, n2);
        int n3 = string2.length();
        if (n3 > 1) {
            string2 = string2.toUpperCase(Locale.US);
        }
        if (n3 > 3 || n3 > 1 && string2.charAt(0) != 'F' && string2.charAt(0) != 'N') {
            return;
        }
        int n4 = Menus.convertShortcutToCode(string2);
        if (n4 == 0) {
            return;
        }
        if (this.nShortcuts == 0) {
            this.removeShortcuts();
        }
        if (n3 == 1 || string2.equals("N+") || string2.equals("N-")) {
            Hashtable hashtable = Menus.getMacroShortcuts();
            hashtable.put(new Integer(n4), '^' + string);
            ++this.nShortcuts;
            return;
        }
        Hashtable hashtable = Menus.getShortcuts();
        if (hashtable.get(new Integer(n4)) != null) {
            if (this.shortcutsInUse == null) {
                this.shortcutsInUse = "\n \n";
            }
            this.shortcutsInUse = this.shortcutsInUse + "\t  " + string + "\n";
            ++this.inUseCount;
            return;
        }
        hashtable.put(new Integer(n4), '^' + string);
        ++this.nShortcuts;
    }

    String showDialog() {
        OpenDialog openDialog;
        String string;
        if (defaultDir == null) {
            defaultDir = Menus.getMacrosPath();
        }
        if ((string = (openDialog = new OpenDialog("Install Macros", defaultDir, fileName)).getFileName()) == null) {
            return null;
        }
        String string2 = openDialog.getDirectory();
        if (!string.endsWith(".txt") && !string.endsWith(".ijm")) {
            IJ.showMessage("Macro Installer", "File name must end with \".txt\" or \".ijm\" .");
            return null;
        }
        fileName = string;
        defaultDir = string2;
        return string2 + string;
    }

    String open(String string) {
        try {
            String string2;
            StringBuffer stringBuffer = new StringBuffer(5000);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2 + "\n");
            }
            bufferedReader.close();
            return new String(stringBuffer);
        }
        catch (Exception exception) {
            IJ.error(exception.getMessage());
            return null;
        }
    }

    public String openFromIJJar(String string) {
        String string2 = null;
        try {
            int n;
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream == null) {
                return null;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[8192];
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuffer.append(cArray, 0, n);
            }
            string2 = stringBuffer.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string2;
    }

    public boolean runMacroTool(String string) {
        for (int i = 0; i < this.nMacros; ++i) {
            if (!this.macroNames[i].startsWith(string)) continue;
            new MacroRunner(this.pgm, this.macroStarts[i], string, (String)null);
            return true;
        }
        return false;
    }

    public boolean runMenuTool(String string, String string2) {
        for (int i = 0; i < this.nMacros; ++i) {
            if (!this.macroNames[i].startsWith(string)) continue;
            Recorder.recordInMacros = true;
            new MacroRunner(this.pgm, this.macroStarts[i], string, string2);
            return true;
        }
        return false;
    }

    public static boolean runMacroCommand(String string) {
        if (instance == null) {
            return false;
        }
        if (string.startsWith(commandPrefixS)) {
            string = string.substring(1);
        }
        for (int i = 0; i < MacroInstaller.instance.nMacros; ++i) {
            if (!string.equals(MacroInstaller.instance.macroNames[i])) continue;
            new MacroRunner(MacroInstaller.instance.pgm, MacroInstaller.instance.macroStarts[i], string, (String)null);
            return true;
        }
        return false;
    }

    public static void runMacroShortcut(String string) {
        if (instance == null) {
            return;
        }
        if (string.startsWith(commandPrefixS)) {
            string = string.substring(1);
        }
        for (int i = 0; i < MacroInstaller.instance.nMacros; ++i) {
            if (!string.equals(MacroInstaller.instance.macroNames[i])) continue;
            new MacroRunner().runShortcut(MacroInstaller.instance.pgm, MacroInstaller.instance.macroStarts[i], string);
            return;
        }
    }

    public void runMacro(String string) {
        this.runMacro(string, null);
    }

    public void runMacro(String string, Editor editor) {
        if (this.anonymousName != null && string.equals(this.anonymousName)) {
            new MacroRunner(this.pgm, 0, this.anonymousName, editor);
            return;
        }
        for (int i = 0; i < this.nMacros; ++i) {
            if (!string.equals(this.macroNames[i])) continue;
            new MacroRunner(this.pgm, this.macroStarts[i], string, editor);
            return;
        }
    }

    public int getMacroCount() {
        return this.nMacros;
    }

    public Program getProgram() {
        return this.pgm;
    }

    public boolean isAutoRunAndHide() {
        return this.autoRunAndHideCount > 0;
    }

    public void setFileName(String string) {
        fileName = string;
        this.openingStartupMacrosInEditor = string.startsWith("StartupMacros");
    }

    public static String getFileName() {
        return fileName;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        MenuItem menuItem = (MenuItem)actionEvent.getSource();
        MenuContainer menuContainer = menuItem.getParent();
        if (menuContainer instanceof PopupMenu) {
            for (int i = 0; i < this.nMacros; ++i) {
                if (!this.macroNames[i].equals("Popup Menu")) continue;
                new MacroRunner(this.pgm, this.macroStarts[i], "Popup Menu", string);
                return;
            }
        }
        this.runMacro(string);
    }
}

