/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.Macro;
import ij.gui.GUI;
import ij.gui.MultiLineLabel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class SaveChangesDialog
extends Dialog
implements ActionListener,
KeyListener {
    private Button dontSave;
    private Button cancel;
    private Button save;
    private boolean cancelPressed;
    private boolean savePressed;

    public SaveChangesDialog(Frame frame, String string) {
        super(frame, "Save?", true);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0, 10, 10));
        Component component = string.startsWith("Save ") ? new Label(string) : (string.length() > 22 ? new MultiLineLabel("Save changes to\n\"" + string + "\"?") : new Label("Save changes to \"" + string + "\"?"));
        component.setFont(new Font("Dialog", 1, 12));
        panel.add(component);
        this.add("Center", panel);
        panel = new Panel();
        panel.setLayout(new FlowLayout(1, 8, 8));
        this.save = new Button("  Save  ");
        this.save.addActionListener(this);
        this.save.addKeyListener(this);
        this.cancel = new Button("  Cancel  ");
        this.cancel.addActionListener(this);
        this.cancel.addKeyListener(this);
        this.dontSave = new Button("Don't Save");
        this.dontSave.addActionListener(this);
        this.dontSave.addKeyListener(this);
        if (IJ.isMacintosh()) {
            panel.add(this.dontSave);
            panel.add(this.cancel);
            panel.add(this.save);
        } else {
            panel.add(this.save);
            panel.add(this.dontSave);
            panel.add(this.cancel);
        }
        this.add("South", panel);
        if (IJ.isMacintosh()) {
            this.setResizable(false);
        }
        this.pack();
        GUI.center(this);
        this.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cancel) {
            this.cancelPressed = true;
        } else if (actionEvent.getSource() == this.save) {
            this.savePressed = true;
        }
        this.closeDialog();
    }

    public boolean cancelPressed() {
        if (this.cancelPressed) {
            Macro.abort();
        }
        return this.cancelPressed;
    }

    public boolean savePressed() {
        return this.savePressed;
    }

    void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        IJ.setKeyDown(n);
        if (n == 10) {
            this.closeDialog();
        } else if (n == 27) {
            this.cancelPressed = true;
            this.closeDialog();
            IJ.resetEscape();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

