% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/first_order.R
\encoding{UTF-8}
\name{first_order}
\alias{first_order}
\title{Calculates first-order statistical metrics for RIA_image}
\usage{
first_order(
  RIA_data_in,
  use_type = "single",
  use_orig = TRUE,
  use_slot = NULL,
  save_name = NULL,
  verbose_in = TRUE
)
}
\arguments{
\item{RIA_data_in}{\emph{RIA_image}.}

\item{use_type}{string, can be \emph{"single"} which runs the function on a single image,
which is determined using \emph{"use_orig"} or \emph{"use_slot"}. \emph{"discretized"}
takes all datasets in the \emph{RIA_image$discretized} slot and runs the analysis on them.}

\item{use_orig}{logical, indicating whether to use image present in \emph{RIA_data$orig}.
If FALSE, the modified image will be used stored in \emph{RIA_data$modif}.}

\item{use_slot}{string, name of slot where data wished to be used is. Use if the desired image
is not in the \emph{data$orig} or \emph{data$modif} slot of the \emph{RIA_image}. For example,
if the desired dataset is in \emph{RIA_image$discretized$ep_4}, then \emph{use_slot} should be
\emph{discretized$ep_4}. The results are automatically saved. If the results are not saved to
the desired slot, then please use \emph{save_name} parameter.}

\item{save_name}{string, indicating the name of subslot of \emph{$stat_fo} to save results to.
If left empty, then it will be automatically determined.}

\item{verbose_in}{logical indicating whether to print detailed information.
Most prints can also be suppresed using the \code{\link{suppressMessages}} function.}
}
\value{
\emph{RIA_image} containing the statistical information.
}
\description{
Calculates first-order statistical metrics of \emph{RIA_image}.
First-order metrics discard all spatial information. By default the \emph{$modif}
image will be used to calculate statistics. If \emph{use_slot} is given, then the data
present in \emph{RIA_image$use_slot} will be used for calculations.
Results will be saved into the \emph{$stat_fo} slot. The name of the subslot is determined
by the supplied string in \emph{$save_name}, or is automatically generated by RIA.
}
\examples{
\dontrun{
#Calculate first-order statistics on original data
RIA_image <- first_order(RIA_image, use_orig = TRUE)

#Dichotomize loaded image and then calculate first order statistics
on it and save results into the RIA_image
RIA_image <- dichotomize(RIA_image, bins_in = c(4, 8), equal_prob = TRUE,
use_orig = TRUE, write_orig = FALSE)
RIA_image <- first_order(RIA_image, use_orig = FALSE, verbose_in = TRUE)

#Use use_slot parameter to set which image to use
RIA_image <- first_order(RIA_image, use_orig = FALSE, use_slot = "discretized$ep_4")

#Batch calculation of first-order statistics on all discretized images
RIA_image <- first_order(RIA_image, use_type = "discretized")
}

}
\references{
Márton KOLOSSVÁRY et al.
Radiomic Features Are Superior to Conventional Quantitative Computed Tomographic
Metrics to Identify Coronary Plaques With Napkin-Ring Sign
Circulation: Cardiovascular Imaging (2017).
DOI: 10.1161/circimaging.117.006843
\url{https://pubmed.ncbi.nlm.nih.gov/29233836/}

Márton KOLOSSVÁRY et al.
Cardiac Computed Tomography Radiomics: A Comprehensive Review on Radiomic Techniques.
Journal of Thoracic Imaging (2018).
DOI: 10.1097/RTI.0000000000000268
\url{https://pubmed.ncbi.nlm.nih.gov/28346329/}
}
