/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.OutputStream;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileSystem;
import org.h2.store.fs.FileSystemWrapper;
import org.h2.store.fs.Recorder;
import org.h2.store.fs.RecordingFileObject;

public class RecordingFileSystem
extends FileSystemWrapper {
    public static final String PREFIX = "rec:";
    private static final RecordingFileSystem INSTANCE = new RecordingFileSystem();
    private static Recorder recorder;
    private boolean trace;

    public static void register() {
        FileSystem.register(INSTANCE);
    }

    public static void setRecorder(Recorder recorder) {
        RecordingFileSystem.recorder = recorder;
    }

    public void createDirs(String string) {
        this.log(4, this.unwrap(string));
        super.createDirs(string);
    }

    public boolean createNewFile(String string) {
        this.log(5, this.unwrap(string));
        return super.createNewFile(string);
    }

    public String createTempFile(String string, String string2, boolean bl, boolean bl2) throws IOException {
        this.log(6, this.unwrap(string) + ":" + string2 + ":" + bl + ":" + bl2);
        return super.createTempFile(string, string2, bl, bl2);
    }

    public void delete(String string) {
        this.log(7, this.unwrap(string));
        super.delete(string);
    }

    public void deleteRecursive(String string, boolean bl) {
        this.log(8, this.unwrap(string));
        super.deleteRecursive(string, bl);
    }

    public FileObject openFileObject(String string, String string2) throws IOException {
        return new RecordingFileObject(this, super.openFileObject(string, string2));
    }

    public OutputStream openFileOutputStream(String string, boolean bl) {
        this.log(9, this.unwrap(string));
        return super.openFileOutputStream(string, bl);
    }

    public void rename(String string, String string2) {
        this.log(10, this.unwrap(string) + ":" + this.unwrap(string2));
        super.rename(string, string2);
    }

    public boolean tryDelete(String string) {
        this.log(2, this.unwrap(string));
        return super.tryDelete(string);
    }

    public String getPrefix() {
        return PREFIX;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    void log(int n, String string) {
        this.log(n, string, null, 0L);
    }

    void log(int n, String string, byte[] byArray, long l) {
        if (recorder != null) {
            recorder.log(n, string, byArray, l);
        }
    }
}

