/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.message.Message;

public class DropUser
extends DefineCommand {
    private boolean ifExists;
    private String userName;

    public DropUser(Session session) {
        super(session);
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public int update() throws SQLException {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        User user = database.findUser(this.userName);
        if (user == null) {
            if (!this.ifExists) {
                throw Message.getSQLException(90032, this.userName);
            }
        } else {
            if (user == this.session.getUser()) {
                int n = 0;
                for (User user2 : database.getAllUsers()) {
                    if (!user2.isAdmin()) continue;
                    ++n;
                }
                if (n == 1) {
                    throw Message.getSQLException(90019);
                }
            }
            user.checkOwnsNoSchemas();
            database.removeDatabaseObject(this.session, user);
        }
        return 0;
    }

    public boolean isTransactional() {
        return false;
    }
}

