% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modFolderToVar.R
\name{modFolderToVar}
\alias{modFolderToVar}
\title{Compute a remote sensing index from a time series of MODIS multispectral 
images}
\usage{
modFolderToVar(src, AppRoot, fun, getStack = FALSE, overwrite = FALSE,
  verbose = FALSE, ...)
}
\arguments{
\item{src}{path to the folder with the MODIS multispectral images.}

\item{AppRoot}{the directory of the outcoming time series.}

\item{fun}{a \code{function} that computes the remote sensing index.}

\item{getStack}{logical argument. If \code{TRUE}, returns the time series of
images as a \code{RasterStack}, otherwise the images are saved in the Hard
Drive Device (HDD).}

\item{overwrite}{logical argument. If \code{TRUE}, it overwrites the existing
images with the same name.}

\item{verbose}{logical argument. If \code{TRUE}, the function prints the 
running steps and warnings.}

\item{...}{arguments for nested functions.
 \itemize{
  \item \code{dates} a vector with the capturing dates being considered
  for mosaicking. If not supplied, all dates are mosaicked.
}}
}
\value{
this function does not return anything, unless \code{getStack = TRUE}
which then returns a \code{RasterStack} with the time series of with the
index.
}
\description{
\code{modFolderToVar} computes a remote sensing index from the spectral bands
of a time series of MODIS images. The images are specified by the path to
the folder that stores the imagery (resulting from the \code{\link{modMosaic}} 
function). The function returns a \code{RasterStack} with a time series of 
images of the remote sensing index.
}
\details{
The function requires the definition of the \code{src} and \code{fun} 
arguments. The \code{src} is usually the path resulting from 
\code{\link{modMosaic}}. The \code{fun} argument can be any function from
this package beginning with “var” (\code{\link{varNDVI}}, \code{\link{varEVI}},
etc.). Custom functions can also be implemented. If \code{fun = varRGB}, then
the argument \code{getStack} must be equal to \code{FALSE} and the 
red-gree-blue (RGB) images must be imported afterwards.
}
\examples{
\dontrun{
# load a spatial polygon object of Navarre
data(ex.navarre)
# main output directory
wdir <- file.path(tempdir(),"Path_for_downloading_folder")
print(wdir)
# download MOD09 images
modDownSearch(product = "MOD09GA",
              startDate = as.Date("01-01-2018", "\%d-\%m-\%Y"),
              endDate = as.Date("03-01-2018", "\%d-\%m-\%Y"),
              username = "username",
              password = "password",
              AppRoot = wdir, # output folder for tif images
              extract.tif = TRUE, 
              collection = 6,
              extent = ex.navarre)
# assign wdir.mod as the output folder from modMosaic
wdir.mod <- file.path(wdir, "Modis", "MOD09GA") # output directory
wdir.mod.tif <- file.path(wdir.mod, "tif") # input directory
# mosaic the MODIS images
modMosaic(wdir.mod.tif,
          AppRoot = wdir.mod,
          out.name = "Navarre")
# path to the folder with the mosaicked images
wdir.mod.navarre <- file.path(wdir.mod, "Navarre")
# generate NDVI images of Navarre
wdir.mod.var <- file.path(wdir.mod, "Variables")
dir.create(wdir.mod.var)
modFolderToVar(src = wdir.mod.navarre,
               fun = varEVI,
               scfun = getRGISToolsOpt("MOD09SCL"),
               AppRoot = wdir.mod.var,
               overwrite = TRUE)
# import mosaicked images (.tif) to the environment in `R'
files.mod.evi <- list.files(file.path(wdir.mod.var,"EVI"),
                            pattern = "\\\\.tif$",
                            full.names = TRUE,
                            recursive = TRUE)

img.mod.evi <- lapply(files.mod.evi,raster)
spplot(img.mod.evi[[1]],at=seq(-1,2.5))
}
}
