% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/senPreview.R
\name{senPreview}
\alias{senPreview}
\title{Preview Sentinel-2 satellite images}
\usage{
senPreview(searchres, username, password, n, size = NULL)
}
\arguments{
\item{searchres}{a vector with the results from \code{\link{senSearch}}.}

\item{username}{ESA’s `SciHub' username.}

\item{password}{ESA’s `SciHub' password.}

\item{n}{a \code{numeric} argument identifying the row of the image in
\code{searchres}.}

\item{size}{a \code{numeric} argument specifying the size of the preview to
be displayed, in pixels.}
}
\description{
\code{senPreview} shows a preview of the \code{n}-th image from a set of
search results.
}
\details{
The function shows a preview of the \code{n}-th output image from a search
in Sentinel archives (\code{\link{modSearch}}). The preview is downloaded from
`SciHub's' website. Please, be aware that only some images may have a preview.
Credentials from an ESA’s `SciHub' account are needed, which can be obtained 
\href{https://scihub.copernicus.eu/dhus/#/self-registration}{here}.
}
\examples{
\dontrun{
# load a spatial polygon object of Navarre
data(ex.navarre)
# perform the search query
searchres <- senSearch(startDate = as.Date("2018210","\%Y\%j"),
                       endDate = as.Date("2018218","\%Y\%j"),
                       platform = "Sentinel-2",
                       extent = ex.navarre,
                       product = "S2MSI1C",
                       username = "username",
                       password = "password")
# preview some images
senPreview(searchres, 3, username = "username", password = "password")
senPreview(searchres, 1, username = "username", password = "password", 600)

# show the dates in julian days
senGetDates(names(searchres),format="\%Y\%j")
}
}
