% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genMissionGetDates.R
\name{modGetDates}
\alias{modGetDates}
\title{Return the capturing dates of MODIS images}
\usage{
modGetDates(str, ...)
}
\arguments{
\item{str}{the full path(s) or official name(s) of MODIS
images from which the capturing date is retrieved.}

\item{...}{arguments for nested functions:
\itemize{
  \item \code{format} the format of the date being returned.
}}
}
\description{
\code{modGetDates} reads the official name of MODIS images and returns its
capturing date, as \code{Date} class object.
}
\details{
The function works with file names (or their paths) regardless of their
extension. The function accepts more than on file path, which can be passed
as a \code{list} of \code{characters}. Dates are returned as 
`\code{YYYY-mm-dd}' by default. If another format is required, it can be
modified through the argument \code{format}.
}
\examples{
# getting the capturing date from the name of a MODIS image
imgPath <- 'MYD13A2.A2016361.h17v04.006.2017285133407.hdf'
modGetDates(imgPath)

# a list of the full file paths of MODIS images, mixing .hdf and .tif files
imgsPaths<-list('MYD13A2.A2013297.h17v04.006.2015269230726.hdf',
                'MYD13A2.A2013313.h17v04.006.2015271071143.tif')
modGetDates(imgsPaths, format = "\%Y\%j")
}
