% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RGF_Regressor.R
\docType{class}
\name{RGF_Regressor}
\alias{RGF_Regressor}
\title{Regularized Greedy Forest regressor}
\usage{
# init <- RGF_Regressor$new(max_leaf = 500, test_interval = 100,
#                                  algorithm = "RGF", loss = "LS", reg_depth = 1.0,
#                                  l2 = 0.1, sl2 = NULL, normalize = TRUE,
#                                  min_samples_leaf = 10, n_iter = NULL,
#                                  n_tree_search = 1, opt_interval = 100,
#                                  learning_rate = 0.5, memory_policy = "generous",
#                                  verbose = 0, init_model = NULL)
}
\description{
Regularized Greedy Forest regressor

Regularized Greedy Forest regressor
}
\details{
the \emph{fit} function builds a regressor from the training set (x, y).

the \emph{predict} function predicts the regression target for x.

the \emph{cleanup} function removes tempfiles used by this model. See the issue \emph{https://github.com/RGF-team/rgf/issues/75}, which explains in which cases the \emph{cleanup} function applies.

the \emph{get_params} function returns the parameters of the model.

the \emph{score} function returns the coefficient of determination ( R^2 ) for the predictions.

the \emph{feature_importances} function returns the feature importances for the data.

the \emph{dump_model} function currently prints information about the fitted model in the console

the \emph{save_model} function saves a model to a file from which training can do warm-start in the future.
}
\section{Methods}{


\describe{
 \item{\code{RGF_Regressor$new(max_leaf = 500, test_interval = 100,
                               algorithm = "RGF", loss = "LS", reg_depth = 1.0,
                               l2 = 0.1, sl2 = NULL, normalize = TRUE,
                               min_samples_leaf = 10, n_iter = NULL,
                               n_tree_search = 1, opt_interval = 100,
                               learning_rate = 0.5, memory_policy = "generous",
                               verbose = 0, init_model = NULL)}}{}

 \item{\code{--------------}}{}

 \item{\code{fit(x, y, sample_weight = NULL)}}{}

 \item{\code{--------------}}{}

 \item{\code{predict(x)}}{}

 \item{\code{--------------}}{}

 \item{\code{cleanup()}}{}

 \item{\code{--------------}}{}

 \item{\code{get_params(deep = TRUE)}}{}

 \item{\code{--------------}}{}

 \item{\code{score(x, y, sample_weight = NULL)}}{}

 \item{\code{--------------}}{}

 \item{\code{feature_importances()}}{}

 \item{\code{--------------}}{}

 \item{\code{dump_model()}}{}

 \item{\code{--------------}}{}

 \item{\code{save_model(filename)}}{}

 \item{\code{--------------}}{}
 }
}

\examples{

try({
    if (reticulate::py_available(initialize = FALSE)) {
        if (reticulate::py_module_available("rgf.sklearn")) {

            library(RGF)

            set.seed(1)
            x = matrix(runif(1000), nrow = 100, ncol = 10)

            y = runif(100)

            RGF_regr = RGF_Regressor$new(max_leaf = 50)

            RGF_regr$fit(x, y)

            preds = RGF_regr$predict(x)
        }
    }
}, silent = TRUE)
}
\references{
\emph{https://github.com/RGF-team/rgf/tree/master/python-package}, \emph{Rie Johnson and Tong Zhang, Learning Nonlinear Functions Using Regularized Greedy Forest}
}
\section{Super class}{
\code{\link[RGF:Internal_class]{RGF::Internal_class}} -> \code{RGF_Regressor}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{RGF_Regressor$new()}}
\item \href{#method-clone}{\code{RGF_Regressor$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="RGF" data-topic="Internal_class" data-id="cleanup">}\href{../../RGF/html/Internal_class.html#method-cleanup}{\code{RGF::Internal_class$cleanup()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="RGF" data-topic="Internal_class" data-id="dump_model">}\href{../../RGF/html/Internal_class.html#method-dump_model}{\code{RGF::Internal_class$dump_model()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="RGF" data-topic="Internal_class" data-id="feature_importances">}\href{../../RGF/html/Internal_class.html#method-feature_importances}{\code{RGF::Internal_class$feature_importances()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="RGF" data-topic="Internal_class" data-id="fit">}\href{../../RGF/html/Internal_class.html#method-fit}{\code{RGF::Internal_class$fit()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="RGF" data-topic="Internal_class" data-id="get_params">}\href{../../RGF/html/Internal_class.html#method-get_params}{\code{RGF::Internal_class$get_params()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="RGF" data-topic="Internal_class" data-id="predict">}\href{../../RGF/html/Internal_class.html#method-predict}{\code{RGF::Internal_class$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="RGF" data-topic="Internal_class" data-id="predict_proba">}\href{../../RGF/html/Internal_class.html#method-predict_proba}{\code{RGF::Internal_class$predict_proba()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="RGF" data-topic="Internal_class" data-id="save_model">}\href{../../RGF/html/Internal_class.html#method-save_model}{\code{RGF::Internal_class$save_model()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="RGF" data-topic="Internal_class" data-id="score">}\href{../../RGF/html/Internal_class.html#method-score}{\code{RGF::Internal_class$score()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RGF_Regressor$new(
  max_leaf = 500,
  test_interval = 100,
  algorithm = "RGF",
  loss = "LS",
  reg_depth = 1,
  l2 = 0.1,
  sl2 = NULL,
  normalize = TRUE,
  min_samples_leaf = 10,
  n_iter = NULL,
  n_tree_search = 1,
  opt_interval = 100,
  learning_rate = 0.5,
  memory_policy = "generous",
  verbose = 0,
  init_model = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{max_leaf}}{an integer. Training will be terminated when the number of leaf nodes in the forest reaches this value.}

\item{\code{test_interval}}{an integer. Test interval in terms of the number of leaf nodes.}

\item{\code{algorithm}}{a character string specifying the \emph{Regularization algorithm}. One of \emph{"RGF"} (RGF with L2 regularization on leaf-only models), \emph{"RGF_Opt"} (RGF with min-penalty regularization) or \emph{"RGF_Sib"} (RGF with min-penalty regularization with the sum-to-zero sibling constraints).}

\item{\code{loss}}{a character string specifying the \emph{Loss function}. One of \emph{"LS"} (Square loss), \emph{"Expo"} (Exponential loss) or \emph{"Log"} (Logistic loss).}

\item{\code{reg_depth}}{a float. Must be no smaller than 1.0. Meant for being used with the algorithm \emph{RGF Opt} or \emph{RGF Sib}. A larger value penalizes deeper nodes more severely.}

\item{\code{l2}}{a float. Used to control the degree of L2 regularization.}

\item{\code{sl2}}{a float or NULL. Override L2 regularization parameter l2 for the process of growing the forest. That is, if specified, the weight correction process uses l2 and the forest growing process uses sl2. If NULL, no override takes place and l2 is used throughout training.}

\item{\code{normalize}}{a boolean. If True, training targets are normalized so that the average becomes zero.}

\item{\code{min_samples_leaf}}{an integer or a float. Minimum number of training data points in each leaf node. If an integer, then consider \emph{min_samples_leaf} as the minimum number. If a float, then \emph{min_samples_leaf} is a percentage and ceil(min_samples_leaf * n_samples) are the minimum number of samples for each node.}

\item{\code{n_iter}}{an integer or NULL. The number of iterations of coordinate descent to optimize weights. If NULL, 10 is used for loss = "LS" and 5 for loss = "Expo" or "Log".}

\item{\code{n_tree_search}}{an integer. The number of trees to be searched for the nodes to split. The most recently grown trees are searched first.}

\item{\code{opt_interval}}{an integer. Weight optimization interval in terms of the number of leaf nodes. For example, by default, weight optimization is performed every time approximately 100 leaf nodes are newly added to the forest.}

\item{\code{learning_rate}}{a float. Step size of Newton updates used in coordinate descent to optimize weights.}

\item{\code{memory_policy}}{a character string. One of \emph{"conservative"} (it uses less memory at the expense of longer runtime. Try only when with default value it uses too much memory) or \emph{"generous"} (it runs faster using more memory by keeping the sorted orders of the features on memory for reuse). Memory using policy.}

\item{\code{verbose}}{an integer. Controls the verbosity of the tree building process.}

\item{\code{init_model}}{either NULL or a character string, optional (default=NULL). Filename of a previously saved model from which training should do warm-start. If model has been saved into multiple files, do not include numerical suffixes in the filename. \emph{NOTE:} Make sure you haven't forgotten to increase the value of the max_leaf parameter regarding to the specified warm-start model because warm-start model trees are counted in the overall number of trees.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RGF_Regressor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
