% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/list-mgmt.R
\name{list_profiles}
\alias{get_profiles}
\alias{list_profiles}
\title{Lists views (profiles) which the user has access to}
\usage{
list_profiles(account.id = "~all", webproperty.id = "~all",
  start.index = NULL, max.results = NULL, token,
  verbose = getOption("rga.verbose"))

get_profiles(account.id = "~all", webproperty.id = "~all",
  start.index = NULL, max.results = NULL, token,
  verbose = getOption("rga.verbose"))
}
\arguments{
\item{account.id}{integer or character. Account ID for the view (profiles) to retrieve. Can either be a specific account ID or '~all', which refers to all the accounts which the user has access to.}

\item{webproperty.id}{character. Web property ID for the views (profiles) to retrieve. Can either be a specific web property ID or '~all', which refers to all the web properties which the user has access to. Requires specified \code{account.id}.}

\item{start.index}{integer. An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with the max-results parameter.}

\item{max.results}{integer. The maximum number of views (profiles) to include in this response.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}

\item{verbose}{logical. Should print information verbose?}
}
\value{
A view (profile) collection lists Analytics views (profiles) to which the user has access. Each resource in the collection corresponds to a single Analytics view (profile).
\item{id}{View (Profile) ID.}
\item{accountId}{Account ID to which this view (profile) belongs.}
\item{webPropertyId}{Web property ID of the form UA-XXXXX-YY to which this view (profile) belongs.}
\item{internalWebPropertyId}{Internal ID for the web property to which this view (profile) belongs.}
\item{name}{Name of this view (profile).}
\item{currency}{The currency type associated with this view (profile).}
\item{timezone}{Time zone for which this view (profile) has been configured. Time zones are identified by strings from the TZ database.}
\item{websiteUrl}{Website URL for this view (profile).}
\item{type}{View (Profile) type. Supported types: WEB or APP.}
\item{siteSearchCategoryParameters}{Site search category parameters for this view (profile).}
\item{stripSiteSearchCategoryParameters}{Whether or not Analytics will strip search category parameters from the URLs in your reports.}
\item{excludeQueryParameters}{The query parameters that are excluded from this view (profile).}
\item{eCommerceTracking}{Indicates whether ecommerce tracking is enabled for this view (profile).}
\item{permissions}{Permissions the user has for this view (profile).}
\item{created}{Time this view (profile) was created.}
\item{updated}{Time this view (profile) was last modified.}
}
\description{
Lists views (profiles) which the user has access to
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/profiles}{Google Management API - Views (Profiles)}

\href{https://ga-dev-tools.appspot.com/account-explorer/}{Google Analytics Demos & Tools - Account Explorer}
}
\seealso{
\code{\link{authorize}}

Other The Google Analytics Management API: \code{\link{get_accounts}},
  \code{\link{list_accounts}}; \code{\link{get_goals}},
  \code{\link{list_goals}}; \code{\link{get_goal}};
  \code{\link{get_profile}}; \code{\link{get_segments}},
  \code{\link{list_segments}};
  \code{\link{get_webproperties}},
  \code{\link{list_webproperties}};
  \code{\link{get_webproperty}}
}

