% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/get-mgmt.R
\name{get_webproperty}
\alias{get_webproperty}
\title{Gets a web property to which the user has access to}
\usage{
get_webproperty(account.id, webproperty.id, token,
  verbose = getOption("rga.verbose"))
}
\arguments{
\item{account.id}{integer or character. Account ID to retrieve the web property for.}

\item{webproperty.id}{character. ID to retrieve the web property for.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}

\item{verbose}{logical. Should print information verbose?}
}
\value{
An Analytics web property.
\item{id}{Web property ID of the form UA-XXXXX-YY.}
\item{kind}{Resource type for Analytics WebProperty.}
\item{selfLink}{Link for this web property.}
\item{accountId}{Account ID to which this web property belongs.}
\item{internalWebPropertyId}{Internal ID for this web property.}
\item{name}{Name of this web property.}
\item{websiteUrl}{Website url for this web property.}
\item{level}{Level for this web property.}
\item{profileCount}{View (Profile) count for this web property.}
\item{industryVertical}{The industry vertical/category selected for this web property.}
\item{defaultProfileId}{Default view (profile) ID.}
\item{permissions}{Permissions the user has for this web property.}
\item{created}{Time this web property was created.}
\item{updated}{Time this web property was last modified.}
\item{parentLink}{Parent link for this web property. Points to the account to which this web property belongs.}
\item{childLink}{Child link for this web property. Points to the list of views (profiles) for this web property.}
}
\description{
Gets a web property to which the user has access to
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/webproperties}{Google Management API - Web Properties}
}
\seealso{
\code{\link{authorize}}

Other The Google Analytics Management API: \code{\link{get_accounts}},
  \code{\link{list_accounts}}; \code{\link{get_goals}},
  \code{\link{list_goals}}; \code{\link{get_goal}};
  \code{\link{get_profiles}}, \code{\link{list_profiles}};
  \code{\link{get_profile}}; \code{\link{get_segments}},
  \code{\link{list_segments}};
  \code{\link{get_webproperties}},
  \code{\link{list_webproperties}}
}

