/*
 * Decompiled with CFR 0.152.
 */
package freak.module.observer;

import freak.core.control.Schedule;
import freak.core.event.BatchEvent;
import freak.core.event.BatchEventListener;
import freak.core.event.EventListener;
import freak.core.event.RunEvent;
import freak.core.event.RunEventListener;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.observer.AbstractObserver;
import freak.core.population.Individual;
import freak.core.population.IndividualList;

public class SuccessfulRuns
extends AbstractObserver
implements BatchEventListener,
RunEventListener {
    private int totalRuns;
    private int successfulRuns;

    public SuccessfulRuns(Schedule schedule) {
        super(schedule);
        this.setMeasure(3);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getFitnessFunction() instanceof SingleObjectiveFitnessFunction)) {
            throw new UnsupportedEnvironmentException("This module works on single objective fitness functions only.");
        }
        try {
            ((SingleObjectiveFitnessFunction)schedule.getFitnessFunction()).getOptimalFitnessValue();
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedEnvironmentException("Optimal fitness value is unknown.");
        }
    }

    public Class getOutputDataType() {
        return Double.class;
    }

    public String getName() {
        return "Success Rate";
    }

    public String getDescription() {
        return "Computes the quota of successful runs in the current batch. Successful runs are runs that have reached the optimal fitness value by the time the run is stopped by the stopping criterion.";
    }

    public void runFinalize(RunEvent evt) {
        IndividualList population = this.getSchedule().getPopulationManager().getPopulation();
        Individual elitist = population.getIndividualWithRank(1);
        SingleObjectiveFitnessFunction fitnessFunction = (SingleObjectiveFitnessFunction)this.getSchedule().getFitnessFunction();
        double bestFitness = fitnessFunction.evaluate(elitist, population);
        if (bestFitness >= fitnessFunction.getOptimalFitnessValue()) {
            ++this.successfulRuns;
        }
        ++this.totalRuns;
    }

    public void createEvents() {
        super.createEvents();
        this.schedule.getEventController().addEvent((EventListener)this, BatchEvent.class, this.schedule);
        this.schedule.getEventController().addEvent((EventListener)this, RunEvent.class, this.schedule);
    }

    public void batchFinished(BatchEvent evt) {
        this.updateViews(new Double((double)this.successfulRuns / (double)this.totalRuns));
        this.totalRuns = 0;
        this.successfulRuns = 0;
    }
}

