/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.cycle.tsp;

import freak.core.control.Schedule;
import freak.core.event.BatchEvent;
import freak.core.event.BatchEventListener;
import freak.core.event.EventListener;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.modulesupport.ClassCollector;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.Configuration;
import freak.core.modulesupport.inspector.StringArrayWrapper;
import freak.core.population.Genotype;
import freak.module.fitness.cycle.tsp.TSPFile;
import freak.module.searchspace.Cycle;
import freak.module.searchspace.PermutationGenotype;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;

public class TSP
extends AbstractStaticSingleObjectiveFitnessFunction
implements BatchEventListener,
Configurable {
    private double[][] points;
    private double[][] distanceArrayDouble;
    private int[][] distanceArrayInt;
    private Object[] tspFileArrayCache;
    private String[] tspFileStringCache;
    private int tspChoice;
    private TSPFile tsp;
    private double[] borderRectangle;
    public static final int EXACT = 0;
    public static final int EUC_2D = 1;
    public static final int CEIL_2D = 2;
    public static final int GEO = 3;
    public static final int ATT = 4;
    public static final int MAN_2D = 5;
    public static final int MAX_2D = 6;
    private String[] propertyEdgeWeightTypeStrings = new String[]{"Exact euclidean distance", "EUC_2D: Rounded euclidean distance", "CEIL_2D: Rounded up euclidean distance", "GEO: Geographical distance (experimental)", "ATT: Pseudo-euclidean distance", "MAN_2D: Manhatten distance", "MAX_2D: Maximum distance"};
    private final int X = 0;
    private final int Y = 1;
    private int edge_weight_type = 0;

    public TSP(Schedule schedule) {
        super(schedule);
    }

    public synchronized double[][] getPoints() {
        return this.points;
    }

    public synchronized double[] getBorderRectangle() {
        return this.borderRectangle;
    }

    public String getTSPName() {
        if (this.tspChoice == 0) {
            return "Random";
        }
        return this.tsp.getName();
    }

    private String[] createTSPFileList() {
        if (this.tspFileStringCache != null) {
            return this.tspFileStringCache;
        }
        String[] classpaths = System.getProperty("java.class.path").split(System.getProperty("path.separator"));
        String startedFrom = ClassCollector.getStartedFrom();
        if (startedFrom.toLowerCase().endsWith(".jar")) {
            String resDir = String.valueOf(startedFrom.substring(0, startedFrom.lastIndexOf("/") + 1)) + "resource";
            classpaths = new String[]{resDir};
        }
        LinkedList<TSPFileInfo> auswahl = new LinkedList<TSPFileInfo>();
        int cp = 0;
        while (cp < classpaths.length) {
            File tspFolder = new File(String.valueOf(classpaths[cp]) + "/freak/module/fitness/cycle/tsp");
            if (tspFolder.exists()) {
                File[] files = tspFolder.listFiles(new TSPFileFilter());
                int i = 0;
                while (i < files.length) {
                    auswahl.add(new TSPFileInfo(files[i]));
                    ++i;
                }
            }
            ++cp;
        }
        Object[] o = auswahl.toArray();
        Arrays.sort(o);
        this.tspFileArrayCache = o;
        String[] result = new String[o.length + 1];
        result[0] = "Random 2D Points";
        int i = 0;
        while (i < o.length) {
            result[i + 1] = ((TSPFileInfo)o[i]).name;
            ++i;
        }
        this.tspFileStringCache = result;
        return result;
    }

    public synchronized void setPropertyPoints(StringArrayWrapper wrapper) {
        int i = wrapper.getIndex();
        if (i == 0) {
            this.tsp = null;
        } else {
            try {
                this.tsp = new TSPFile(((TSPFileInfo)this.tspFileArrayCache[i - 1]).file);
                this.edge_weight_type = this.tsp.getEdgeWeightType();
            }
            catch (Exception e) {
                System.out.println(e);
                return;
            }
            this.tspFileStringCache[i] = String.valueOf(this.tsp.getName()) + ": " + this.tsp.getComment();
            ((Cycle)this.getSchedule().getGenotypeSearchSpace()).setPropertyDimension(new Integer(this.tsp.getDimension()));
            this.schedule.callInitialize();
        }
        this.tspChoice = i;
    }

    public synchronized StringArrayWrapper getPropertyPoints() {
        return new StringArrayWrapper(this.createTSPFileList(), this.tspChoice);
    }

    public String getShortDescriptionForPoints() {
        return "Coordinates";
    }

    public String getLongDescriptionForPoints() {
        return "Select a sample instances for the TSP. This changes the search space dimension!";
    }

    public void setPropertyEdgeWeightType(StringArrayWrapper wrapper) {
        this.edge_weight_type = wrapper.getIndex();
    }

    public StringArrayWrapper getPropertyEdgeWeightType() {
        return new StringArrayWrapper(this.propertyEdgeWeightTypeStrings, this.edge_weight_type);
    }

    public String getShortDescriptionForEdgeWeightType() {
        return "Distance function";
    }

    public String getLongDescriptionForEdgeWeightType() {
        return "Edge weight type";
    }

    private double getDegree(double p) {
        double deg = Math.floor(p);
        double min = p - deg;
        return Math.PI * (deg + min * 1.6666666666666667) / 180.0;
    }

    private int intDistance(int p1, int p2) {
        int value;
        if (this.distanceArrayInt != null && (value = this.distanceArrayInt[p1][p2]) != 0) {
            return value;
        }
        int result = 0;
        double[] point1 = this.points[p1];
        double[] point2 = this.points[p2];
        double dx = point1[0] - point2[0];
        double dy = point1[1] - point2[1];
        switch (this.edge_weight_type) {
            case 1: {
                result = (int)Math.round(Math.sqrt(dx * dx + dy * dy));
                break;
            }
            case 2: {
                result = (int)Math.ceil(Math.sqrt(dx * dx + dy * dy));
                break;
            }
            case 3: {
                double latitude1 = this.getDegree(point1[0]);
                double longitude1 = this.getDegree(point1[1]);
                double latitude2 = this.getDegree(point2[0]);
                double longitude2 = this.getDegree(point2[1]);
                double q1 = Math.cos(longitude1 - longitude2);
                double q2 = Math.cos(latitude1 - latitude2);
                double q3 = Math.cos(latitude1 + latitude2);
                result = (int)Math.floor(6378.388 * Math.acos(0.5 * ((1.0 + q1) * q2 - (1.0 - q1) * q3)) + 1.0);
                break;
            }
            case 4: {
                result = (int)Math.ceil(Math.sqrt((dx * dx + dy * dy) / 10.0));
                break;
            }
            case 5: {
                result = (int)Math.round(Math.abs(dx) + Math.abs(dy));
                break;
            }
            case 6: {
                result = (int)Math.max(Math.round(Math.abs(dx)), Math.round(Math.abs(dy)));
            }
        }
        if (this.distanceArrayInt != null) {
            this.distanceArrayInt[p1][p2] = result;
        }
        return result;
    }

    private double doubleDistance(int p1, int p2) {
        double value;
        if (this.distanceArrayDouble != null && (value = this.distanceArrayDouble[p1][p2]) != 0.0) {
            return value;
        }
        double[] point1 = this.points[p1];
        double[] point2 = this.points[p2];
        double dx = point1[0] - point2[0];
        double dy = point1[1] - point2[1];
        double result = Math.sqrt(dx * dx + dy * dy);
        if (this.distanceArrayDouble != null) {
            this.distanceArrayDouble[p1][p2] = result;
        }
        return result;
    }

    public double evaluate(Genotype genotype) {
        int[] gene = ((PermutationGenotype)genotype).getIntArray();
        if (this.tspChoice == 0) {
            double cost = 0.0;
            int pos = 0;
            while (pos < gene.length) {
                cost += this.doubleDistance(gene[pos] - 1, gene[(pos + 1) % gene.length] - 1);
                ++pos;
            }
            return 0.0 - cost;
        }
        int cost = 0;
        int pos = 0;
        while (pos < gene.length) {
            cost += this.intDistance(gene[pos] - 1, gene[(pos + 1) % gene.length] - 1);
            ++pos;
        }
        return 0 - cost;
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public double getLowerBound() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return 0.0;
    }

    public Genotype getPhenotypeOptimum() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String getDescription() {
        return "The symmetric traveling salesman problem is to find a roundtrip through n nodes with minimal length.\nThe distance calculated by a selected function between two nodes i and j is the same like the distance between node j and i.";
    }

    public String getName() {
        return "Symmetric TSP";
    }

    public Configuration getConfiguration() {
        Configuration c = Configuration.getConfigurationFor(this);
        c.setAdditional(new Integer(this.edge_weight_type), "");
        return c;
    }

    public void setConfiguration(Configuration configuration) {
        Configuration.setConfigurationFor(this, configuration);
        this.edge_weight_type = (Integer)configuration.getAdditional();
    }

    public synchronized void batchStarted(BatchEvent evt) {
        int dim = ((Cycle)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        if (this.tspChoice == 0) {
            this.borderRectangle = new double[4];
            this.borderRectangle[0] = 0.0;
            this.borderRectangle[1] = 0.0;
            this.borderRectangle[2] = 100.0;
            this.borderRectangle[3] = 100.0;
            this.points = new double[dim][2];
            int i = 0;
            while (i < dim) {
                int j = 0;
                while (j < 2) {
                    this.points[i][j] = this.getSchedule().getRandomElement().raw() * 100.0;
                    ++j;
                }
                ++i;
            }
        } else {
            this.points = this.tsp.getPoints();
            this.borderRectangle = this.tsp.getBorderRectangle();
        }
        if (dim <= 550) {
            if (this.tspChoice == 0) {
                this.distanceArrayDouble = new double[dim][dim];
            } else {
                this.distanceArrayInt = new int[dim][dim];
            }
        } else {
            this.distanceArrayInt = null;
            this.distanceArrayDouble = null;
        }
    }

    public void createEvents() {
        this.schedule.getEventController().addEvent((EventListener)this, BatchEvent.class, this.schedule);
    }

    private static class TSPFileFilter
    implements FileFilter {
        private TSPFileFilter() {
        }

        public boolean accept(File file) {
            return file.getName().endsWith(".tsp");
        }
    }

    class TSPFileInfo
    implements Comparable,
    Serializable {
        File file;
        String name;

        public TSPFileInfo(File f) {
            String tspName = f.getName();
            this.name = tspName.substring(0, tspName.length() - 4).toUpperCase();
            this.file = f;
        }

        public int compareTo(Object o) {
            return this.name.compareTo(((TSPFileInfo)o).name);
        }
    }
}

