/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jgraph.JGraph;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.Edge;
import org.jgraph.graph.EdgeRenderer;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.PortView;
import org.jgraph.plaf.GraphUI;
import org.jgraph.plaf.basic.BasicGraphUI;

public class EdgeView
extends AbstractCellView {
    public static EdgeRenderer renderer = new EdgeRenderer();
    protected List points;
    protected CellView source;
    protected CellView target;
    protected Point labelPosition;
    public Shape beginShape;
    public Shape endShape;
    public Shape lineShape;
    public transient GeneralPath sharedPath = null;
    private Rectangle cachedLabelBounds = null;
    private Rectangle cachedBounds = null;
    public static long shapeHits = 0L;

    public EdgeView(Object object, JGraph jGraph, CellMapper cellMapper) {
        super(object, jGraph, cellMapper);
    }

    public void refresh(boolean bl) {
        super.refresh(bl);
        if (this.points != null) {
            Object object = this.getModel().getSource(this.cell);
            Object object2 = this.getModel().getTarget(this.cell);
            this.setSource(this.mapper.getMapping(object, bl));
            this.setTarget(this.mapper.getMapping(object2, bl));
            Edge.Routing routing = GraphConstants.getRouting(this.allAttributes);
            if (routing != null) {
                routing.route(this, this.points);
            }
        }
    }

    public void update() {
        super.update();
        this.points = GraphConstants.getPoints(this.allAttributes);
        this.labelPosition = GraphConstants.getLabelPosition(this.allAttributes);
        Edge.Routing routing = GraphConstants.getRouting(this.allAttributes);
        if (routing != null) {
            routing.route(this, this.points);
        }
        if (this.getModel().getSource(this.cell) != null) {
            this.setSource(this.getSource());
        }
        if (this.getModel().getTarget(this.cell) != null) {
            this.setTarget(this.getTarget());
        }
        this.beginShape = null;
        this.endShape = null;
        this.lineShape = null;
        this.sharedPath = null;
        this.cachedBounds = null;
        this.cachedLabelBounds = null;
    }

    void invalidate() {
        this.sharedPath = null;
        this.cachedBounds = null;
        this.cachedLabelBounds = null;
    }

    public final Shape getShape() {
        if (this.sharedPath != null) {
            return this.sharedPath;
        }
        ++shapeHits;
        this.sharedPath = (GeneralPath)this.getEdgeRenderer().createShape();
        return this.sharedPath;
    }

    public final Rectangle getLabelBounds() {
        if (this.cachedLabelBounds != null) {
            return this.cachedLabelBounds;
        }
        this.cachedLabelBounds = this.getEdgeRenderer().getLabelBounds(this);
        return this.cachedLabelBounds;
    }

    public boolean intersects(Graphics graphics, Rectangle rectangle) {
        return this.getEdgeRenderer().intersects(graphics, this, rectangle);
    }

    public Rectangle getBounds() {
        if (this.cachedBounds != null) {
            return this.cachedBounds;
        }
        this.cachedBounds = this.getEdgeRenderer().getBounds(this);
        return this.cachedBounds;
    }

    public EdgeRenderer getEdgeRenderer() {
        return (EdgeRenderer)this.getRenderer();
    }

    public CellViewRenderer getRenderer() {
        return renderer;
    }

    public CellHandle getHandle(GraphContext graphContext) {
        return new EdgeHandle(this, graphContext);
    }

    public CellView getSource() {
        return this.source;
    }

    public void setSource(CellView cellView) {
        this.source = cellView;
        if (this.source != null) {
            this.points.set(0, this.source);
        } else {
            this.points.set(0, this.getPoint(0));
        }
        this.invalidate();
    }

    public CellView getTarget() {
        return this.target;
    }

    public void setTarget(CellView cellView) {
        this.target = cellView;
        int n = this.points.size() - 1;
        if (this.target != null) {
            this.points.set(n, this.target);
        } else {
            this.points.set(n, this.getPoint(n));
        }
        this.invalidate();
    }

    public Point getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(Point point) {
        this.labelPosition.setLocation(point);
        this.invalidate();
    }

    public List getPoints() {
        return this.points;
    }

    public int getPointCount() {
        return this.points.size();
    }

    public Point getPoint(int n) {
        Object e = this.points.get(n);
        if (e instanceof PortView) {
            return ((PortView)e).getLocation(this);
        }
        if (e instanceof CellView) {
            return ((CellView)e).getBounds().getLocation();
        }
        if (e instanceof Point) {
            return (Point)e;
        }
        return null;
    }

    public void setPoint(int n, Point point) {
        this.points.set(n, point);
        this.invalidate();
    }

    public void addPoint(int n, Point point) {
        this.points.add(n, point);
        this.invalidate();
    }

    public void removePoint(int n) {
        this.points.remove(n);
        this.invalidate();
    }

    public boolean isAddPointEvent(MouseEvent mouseEvent) {
        return SwingUtilities.isRightMouseButton(mouseEvent);
    }

    public boolean isRemovePointEvent(MouseEvent mouseEvent) {
        return SwingUtilities.isRightMouseButton(mouseEvent);
    }

    public static double getLength(CellView cellView) {
        double d = 1.0;
        if (cellView instanceof EdgeView) {
            EdgeView edgeView = (EdgeView)cellView;
            Point point = null;
            Point point2 = null;
            int n = 0;
            while (n < edgeView.getPointCount()) {
                point2 = edgeView.getPoint(n);
                if (point != null) {
                    d += point.distance(point2);
                }
                point = point2;
                ++n;
            }
        }
        return d;
    }

    public boolean isConstrainedMoveEvent(MouseEvent mouseEvent) {
        GraphUI graphUI = this.graph.getUI();
        if (graphUI instanceof BasicGraphUI) {
            return ((BasicGraphUI)graphUI).isConstrainedMoveEvent(mouseEvent);
        }
        return false;
    }

    public class EdgeHandle
    implements CellHandle,
    Serializable {
        protected JGraph graph;
        protected EdgeView edge;
        protected EdgeView orig;
        protected boolean label = false;
        protected boolean source = false;
        protected boolean target = false;
        protected Point currentPoint;
        protected transient Rectangle[] r;
        protected transient Rectangle loc;
        protected boolean firstOverlayCall = true;
        protected boolean isEdgeConnectable = true;
        protected EdgeView relevantEdge = null;

        public EdgeHandle(EdgeView edgeView2, GraphContext graphContext) {
            this.graph = graphContext.getGraph();
            this.edge = edgeView2;
            this.loc = new Rectangle();
            this.orig = (EdgeView)this.graph.getGraphLayoutCache().getMapping(edgeView2.getCell(), false);
            this.reloadPoints(this.orig);
            this.isEdgeConnectable = GraphConstants.isConnectable(edgeView2.getAllAttributes());
        }

        protected void reloadPoints(EdgeView edgeView) {
            this.relevantEdge = edgeView;
            this.r = new Rectangle[edgeView.getPointCount()];
            int n = 0;
            while (n < this.r.length) {
                this.r[n] = new Rectangle();
                ++n;
            }
            this.invalidate();
        }

        public void paint(Graphics graphics) {
            this.invalidate();
            int n = 0;
            while (n < this.r.length) {
                if (this.isEdgeConnectable) {
                    graphics.setColor(this.graph.getHandleColor());
                } else {
                    graphics.setColor(this.graph.getLockedHandleColor());
                }
                graphics.fill3DRect(this.r[n].x, this.r[n].y, this.r[n].width, this.r[n].height, true);
                CellView cellView = null;
                if (n == 0 && this.edge.getSource() != null) {
                    cellView = this.edge.getSource();
                } else if (n == this.r.length - 1 && this.edge.getTarget() != null) {
                    cellView = this.edge.getTarget();
                }
                if (cellView != null) {
                    graphics.setColor(this.graph.getLockedHandleColor());
                    Point point = GraphConstants.getOffset(cellView.getAllAttributes());
                    if (point != null) {
                        graphics.drawLine(this.r[n].x + 1, this.r[n].y + 1, this.r[n].x + this.r[n].width - 3, this.r[n].y + this.r[n].height - 3);
                        graphics.drawLine(this.r[n].x + 1, this.r[n].y + this.r[n].height - 3, this.r[n].x + this.r[n].width - 3, this.r[n].y + 1);
                    } else {
                        graphics.drawRect(this.r[n].x + 2, this.r[n].y + 2, this.r[n].width - 5, this.r[n].height - 5);
                    }
                }
                ++n;
            }
        }

        public void overlay(Graphics graphics) {
            if (this.edge != null && !this.firstOverlayCall) {
                graphics.setColor(this.graph.getForeground());
                graphics.setXORMode(this.graph.getBackground().darker());
                Graphics2D graphics2D = (Graphics2D)graphics;
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.scale(this.graph.getScale(), this.graph.getScale());
                this.graph.getUI().paintCell(graphics, this.edge, this.edge.getBounds(), true);
                graphics2D.setTransform(affineTransform);
                if (this.isSourceEditing() && this.edge.getSource() != null) {
                    this.paintPort(graphics, this.edge.getSource());
                } else if (this.isTargetEditing() && this.edge.getTarget() != null) {
                    this.paintPort(graphics, this.edge.getTarget());
                }
            }
            this.firstOverlayCall = false;
        }

        protected void paintPort(Graphics graphics, CellView cellView) {
            boolean bl = GraphConstants.getOffset(cellView.getAllAttributes()) != null;
            Rectangle rectangle = bl ? cellView.getBounds() : cellView.getParentView().getBounds();
            rectangle = this.graph.toScreen(new Rectangle(rectangle));
            int n = 3;
            rectangle.translate(-n, -n);
            rectangle.setSize(rectangle.width + 2 * n, rectangle.height + 2 * n);
            this.graph.getUI().paintCell(graphics, cellView, rectangle, true);
        }

        protected boolean snap(boolean bl, Point point) {
            CellView cellView;
            boolean bl2 = this.graph.isConnectable() && this.isEdgeConnectable;
            Object object = this.graph.getPortForLocation(point.x, point.y);
            if (object != null && bl2 && GraphConstants.isConnectable((cellView = this.graph.getGraphLayoutCache().getMapping(object, false)).getParentView().getAllAttributes())) {
                Object object2 = this.edge.getCell();
                if (bl && this.edge.getSource() != cellView && EdgeView.this.getModel().acceptsSource(object2, object)) {
                    this.overlay(this.graph.getGraphics());
                    this.edge.setSource(cellView);
                    this.edge.update();
                    this.overlay(this.graph.getGraphics());
                } else if (!bl && this.edge.getTarget() != cellView && EdgeView.this.getModel().acceptsTarget(object2, object)) {
                    this.overlay(this.graph.getGraphics());
                    this.edge.setTarget(cellView);
                    this.edge.update();
                    this.overlay(this.graph.getGraphics());
                }
                return cellView != null;
            }
            return false;
        }

        protected boolean isSourceEditing() {
            return this.source;
        }

        protected boolean isTargetEditing() {
            return this.target;
        }

        protected boolean isEditing() {
            return this.source || this.target || this.label || this.currentPoint != null;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = 0;
            while (n < this.r.length) {
                if (this.r[n].contains(mouseEvent.getPoint())) {
                    this.graph.setCursor(new Cursor(1));
                    mouseEvent.consume();
                    return;
                }
                ++n;
            }
            if (this.loc.contains(mouseEvent.getPoint()) && this.graph.isMoveable() && GraphConstants.isMoveable(this.edge.getAllAttributes())) {
                this.graph.setCursor(new Cursor(12));
                mouseEvent.consume();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            boolean bl = this.graph.isBendable() && GraphConstants.isBendable(this.edge.getAllAttributes());
            boolean bl2 = this.graph.isDisconnectable() && GraphConstants.isDisconnectable(this.orig.getAllAttributes());
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = 0;
            n3 = 0;
            while (n3 < this.r.length) {
                if (this.r[n3].contains(n, n2)) {
                    this.currentPoint = this.edge.getPoint(n3);
                    this.source = n3 == 0 && (this.edge.getSource() == null || bl2 && GraphConstants.isDisconnectable(this.edge.getSource().getParentView().getAllAttributes()));
                    this.target = n3 == this.r.length - 1 && (this.edge.getTarget() == null || bl2 && GraphConstants.isDisconnectable(this.edge.getTarget().getParentView().getAllAttributes()));
                    break;
                }
                ++n3;
            }
            if (!this.isEditing() && this.graph.isMoveable() && GraphConstants.isMoveable(this.edge.getAllAttributes()) && this.loc != null && this.loc.contains(n, n2) && !EdgeView.this.isAddPointEvent(mouseEvent) && !EdgeView.this.isRemovePointEvent(mouseEvent)) {
                if (mouseEvent.getClickCount() == this.graph.getEditClickCount()) {
                    this.graph.startEditingAtCell(this.edge);
                } else {
                    this.label = true;
                }
            }
            if (EdgeView.this.isRemovePointEvent(mouseEvent) && this.currentPoint != null && bl) {
                this.edge.removePoint(n3);
                this.mouseReleased(mouseEvent);
            } else if (EdgeView.this.isAddPointEvent(mouseEvent) && !this.isEditing() && bl) {
                int n4 = this.graph.getHandleSize();
                Rectangle rectangle = this.graph.fromScreen(new Rectangle(n - n4, n2 - n4, 2 * n4, 2 * n4));
                if (this.edge.intersects(this.graph.getGraphics(), rectangle)) {
                    Point point = this.graph.fromScreen(this.graph.snap(new Point(mouseEvent.getPoint())));
                    double d = Double.MAX_VALUE;
                    double d2 = 0.0;
                    int n5 = 0;
                    while (n5 < this.edge.getPointCount() - 1) {
                        Point point2;
                        Point point3 = this.edge.getPoint(n5);
                        d2 = new Line2D.Double(point3, point2 = this.edge.getPoint(n5 + 1)).ptLineDistSq(point);
                        if (d2 < d) {
                            d = d2;
                            n3 = n5 + 1;
                        }
                        ++n5;
                    }
                    this.edge.addPoint(n3, point);
                    this.currentPoint = point;
                    this.reloadPoints(this.edge);
                    this.paint(this.graph.getGraphics());
                }
            }
            if (this.isEditing()) {
                mouseEvent.consume();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = this.graph.fromScreen(new Point(mouseEvent.getPoint()));
            if (this.label) {
                Rectangle rectangle = this.edge.getBounds();
                if (rectangle != null) {
                    Point point2 = this.edge.getPoint(0);
                    Point point3 = this.edge.getPoint(this.edge.getPointCount() - 1);
                    int n = point.x - rectangle.x;
                    if (point2.x > point3.x) {
                        n = rectangle.x + rectangle.width - point.x;
                    }
                    int n2 = point.y - rectangle.y;
                    if (point2.y > point3.y) {
                        n2 = rectangle.y + rectangle.height - point.y;
                    }
                    int n3 = 1;
                    if (rectangle.width != 0) {
                        n3 = 1000 / rectangle.width;
                    }
                    int n4 = 1;
                    if (rectangle.height != 0) {
                        n4 = 1000 / rectangle.height;
                    }
                    point = new Point(n * n3, n2 * n4);
                    this.overlay(this.graph.getGraphics());
                    this.edge.setLabelPosition(point);
                    this.edge.update();
                    this.overlay(this.graph.getGraphics());
                }
            } else if (!(!this.isEditing() || this.source && this.snap(true, point) || this.target && this.snap(false, point) || !(this.source && EdgeView.this.getModel().acceptsSource(EdgeView.this.cell, null) || this.target && EdgeView.this.getModel().acceptsTarget(EdgeView.this.cell, null)) && (this.source || this.target))) {
                this.overlay(this.graph.getGraphics());
                point = this.graph.fromScreen(this.graph.snap(new Point(mouseEvent.getPoint())));
                if (EdgeView.this.isConstrainedMoveEvent(mouseEvent)) {
                    EdgeView edgeView = (EdgeView)this.graph.getGraphLayoutCache().getMapping(this.edge.getCell(), false);
                    int n = 0;
                    if (this.target) {
                        n = edgeView.getPointCount() - 1;
                    } else {
                        this.edge.getPoints().indexOf(this.currentPoint);
                    }
                    Point point4 = edgeView.getPoint(n);
                    int n5 = point.x - point4.x;
                    int n6 = point.y - point4.y;
                    if (Math.abs(n5) < Math.abs(n6)) {
                        point.x = point4.x;
                    } else {
                        point.y = point4.y;
                    }
                }
                point.x = Math.max(0, point.x);
                point.y = Math.max(0, point.y);
                this.currentPoint.setLocation(point);
                if (this.source) {
                    this.edge.setPoint(0, point);
                    this.edge.setSource(null);
                } else if (this.target) {
                    this.edge.setPoint(this.edge.getPointCount() - 1, point);
                    this.edge.setTarget(null);
                }
                this.edge.update();
                this.overlay(this.graph.getGraphics());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            boolean bl = mouseEvent.isControlDown() && this.graph.isCloneable();
            ConnectionSet connectionSet = this.createConnectionSet(this.edge, this.edge.getCell(), bl);
            Map map = GraphConstants.createAttributes(new CellView[]{this.edge}, null);
            if (bl) {
                Map map2 = this.graph.cloneCells(new Object[]{this.edge.getCell()});
                map = GraphConstants.replaceKeys(map2, map);
                connectionSet = connectionSet.clone(map2);
                this.graph.getGraphLayoutCache().insert(map2.values().toArray(), map, connectionSet, null, null);
            } else {
                this.graph.getGraphLayoutCache().edit(map, connectionSet, null, null);
            }
            mouseEvent.consume();
        }

        protected ConnectionSet createConnectionSet(EdgeView edgeView, Object object, boolean bl) {
            ConnectionSet connectionSet = new ConnectionSet();
            Object object2 = null;
            Object object3 = null;
            if (edgeView.getSource() != null) {
                object2 = edgeView.getSource().getCell();
            }
            if (edgeView.getTarget() != null) {
                object3 = edgeView.getTarget().getCell();
            }
            if (bl || object2 != EdgeView.this.getModel().getSource(object)) {
                connectionSet.connect(object, object2, true);
            }
            if (bl || object3 != EdgeView.this.getModel().getTarget(object)) {
                connectionSet.connect(object, object3, false);
            }
            return connectionSet;
        }

        protected void invalidate() {
            EdgeView edgeView = this.relevantEdge;
            int n = this.graph.getHandleSize();
            EdgeRenderer edgeRenderer = renderer;
            int n2 = 0;
            while (n2 < this.r.length) {
                Point point = this.graph.toScreen(new Point(edgeView.getPoint(n2)));
                this.r[n2].setBounds(point.x - n, point.y - n, 2 * n, 2 * n);
                point = this.graph.toScreen(edgeRenderer.getLabelPosition(edgeView));
                Dimension dimension = edgeRenderer.getLabelSize(edgeView);
                if (point != null && dimension != null) {
                    Point point2 = this.graph.toScreen(new Point(dimension.width, dimension.height));
                    this.loc.setBounds(point.x - point2.x / 2, point.y - point2.y / 2, point2.x, point2.y);
                }
                ++n2;
            }
        }
    }
}

